/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.dns;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;


public class SipTransports implements Externalizable {
    /**
     *
     */
    private static final long serialVersionUID = 4049076025512440630L;
    public static final int UNDEFINED = -1;
    public static final int UDP = 1;
    public static final int TCP = 2;
    public static final int TLS = 3;
    public static final UDPProtocol UDP_PROT = new UDPProtocol(UDP, "udp",
            5060, "SIP+D2U", "_sip._udp");
    public static final SipTransports TCP_PROT = new SipTransports(TCP, "tcp",
            5060, "SIP+D2T", "_sip._tcp");
    public static final SipTransports TLS_PROT = new SipTransports(TLS, "tls",
            5061, "SIPS+D2T", "_sips._tcp");
    public static final SipTransports UNDEFINED_PROT = new SipTransports(UNDEFINED,
            "undefined", UNDEFINED, "", "");

    static {
        // TODO read this from a config file
        UDP_PROT.setSupported(true);
        TCP_PROT.setSupported(true);
        TLS_PROT.setSupported(true);
    }

    private int myOrdinal;
    private boolean myIsSupported = false;
    private String myProtocolName;
    private String myNaptrString;
    private String mySRVToken;
    private int myDefaultPort;

    SipTransports(int ordinal, String protocolName, int defaultPort,
        String naptrString, String srvToken) {
        myOrdinal = ordinal;
        myProtocolName = protocolName;
        myDefaultPort = defaultPort;
        myNaptrString = naptrString;
        mySRVToken = srvToken;
    }

    public SipTransports() {
    } //For serialization

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeInt(myOrdinal);
    }

    public void readExternal(ObjectInput input) throws IOException {
        int o = input.readInt();
        SipTransports st = null;

        switch (o) {
        case UDP:
            st = UDP_PROT;

            break;

        case TCP:
            st = TCP_PROT;

            break;

        case TLS:
            st = TLS_PROT;

            break;

        default:
            st = UNDEFINED_PROT;
        }

        ;
        myOrdinal = o;
        myProtocolName = st.myProtocolName;
        myDefaultPort = st.myDefaultPort;
        myNaptrString = st.myNaptrString;
        mySRVToken = st.mySRVToken;
    }

    public boolean isSupported() {
        return myIsSupported;
    }

    public int ordinal() {
        return myOrdinal;
    }

    /*
     * hur ska vi supporta specifika instanser? och statiska dito?
     */
    public void setSupported(boolean value) {
        myIsSupported = value;
    }

    public String name() {
        return myProtocolName;
    }

    public int getDefaultPort() {
        return myDefaultPort;
    }

    public String getNAPTRId() {
        return myNaptrString;
    }

    public String getSRVToken() {
        return mySRVToken;
    }

    public static SipTransports getTransport(String transportId)
        throws Exception {
        SipTransports theProtocol = null;

        if (transportId.equalsIgnoreCase(SipTransports.UDP_PROT.name())) {
            theProtocol = SipTransports.UDP_PROT;
        } else if (transportId.equalsIgnoreCase(SipTransports.TCP_PROT.name())) {
            theProtocol = SipTransports.TCP_PROT;
        } else if (transportId.equalsIgnoreCase(SipTransports.TLS_PROT.name())) {
            theProtocol = SipTransports.TLS_PROT;
        } else {
            throw new Exception("Transport protocol not supported:" +
                transportId);
        }

        return theProtocol;
    }
}
