/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.persistence;

import javax.servlet.ServletException;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;

import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.wrapper.WrappedSipSession;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;

/**
 * Class for handle out-of-band / out-of-tree access.
 * Most of the modyfing data methods will trigger replication of the delegated sip entity.
 * All overriden method triggers replication.
 * 
 * @author epkadsz
 *
 */
public class OnModificationReplicatedSession extends WrappedSipSession {

	/**
	 * Default version id.
	 */
	private static final long serialVersionUID = 1L;
	
	/** Indicating if the local replication should override the context replication flag. */
	private boolean localReplication = false;

	
	public OnModificationReplicatedSession(SipSession session, WrapperContext context){
		super((SipSessionDialogImpl)session, context);
	}
	
	public ReplicationContext getContext() {
		return (ReplicationContext)super.getContext();
	}
	
	@Override
	public void removeAttribute(String name) {
		super.removeAttribute(name);
		saveDelegate();
	}

	@Override
	public void setAttribute(String name, Object value) {
		//just to optimize the analysis
		if (localReplication == false) {
			if (name.equals(ReplicationContext.OOB_SHALLOW_REPLICATION_FLAG)) {
				localReplication = true;
				return; // we dont store the flag
			}
		}
		super.setAttribute(name, value);
		saveDelegate();
	}

	@Override
	public void setHandler(String name) throws ServletException {
		super.setHandler(name);
		saveDelegate();
	}

	@Override
	public void setOutboundInterface(SipURI uri) {
		super.setOutboundInterface(uri);
		saveDelegate();	
	}
	
	@ReplicationTrigger(name = "Out of band / Out of tree for SS", info = "Each modification should be replicated.", condition = "")
	private void saveDelegate() {
		if (getContext().isAutoReplicationOn() || localReplication) {
			getContext().incReplications();

			SipSessionBase ssdi = (SipSessionBase)getDelegate();
			PersistenceUtil.getInstance().saveSipSessionNarrowly(ssdi);
		}
	}
}
