/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.persistence;

import java.util.Iterator;

import javax.servlet.sip.URI;

public class OnModificationURIReplication implements URI {

	private URI _delegate;
	
	public OnModificationURIReplication(URI uri) {
		_delegate = uri;
	}
	
	public String getParameter(String key) {
		return _delegate.getParameter(key);
	}

	public Iterator<String> getParameterNames() {
		return _delegate.getParameterNames();
	}

	public String getScheme() {
		return _delegate.getScheme();
	}

	public boolean isSipURI() {
		return _delegate.isSipURI();
	}

	public void removeParameter(String name) {
		_delegate.removeParameter(name);
		saveDelegate();
	}

	public void setParameter(String name, String value) {
		_delegate.setParameter(name, value);
		saveDelegate();
	}
	
	public Object clone() {
		return _delegate.clone();
	}
	
	private void saveDelegate() {
		
	}
}
