/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.SipMonitoring;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.timer.GeneralTimer;
import static com.ericsson.ssa.sip.transaction.TransactionState.COMPLETED;
import static com.ericsson.ssa.sip.transaction.TransactionState.PROCEEDING;
import static com.ericsson.ssa.sip.transaction.TransactionState.TERMINATED;
import static com.ericsson.ssa.sip.transaction.TransactionState.TRYING;
import static com.ericsson.ssa.sip.transaction.TransactionTimer.TimerJ;

import java.io.UnsupportedEncodingException;

import java.util.logging.Level;


/**
 * @author ekrigro TODO To change the template for this generated type comment
 *         go to Window - Preferences - Java - Code Style - Code Templates
 */
public class NonInviteServerTransaction extends ServerTransaction {
    private GeneralTimer _timerJ; // 64*T1 for UDP 0s TCP

    /**
     * @param state
     * @param req
     */
    public NonInviteServerTransaction(String id, SipServletRequestImpl req) {
        super(id, TRYING, req);
    }

    synchronized boolean handle(SipServletRequestImpl req) {
        if ((_response != null) &&
                ((_state == PROCEEDING) || (_state == COMPLETED))) {
            _response.restoreRetransmissionTransactionStack();

            Dispatcher d = _response.popDispatcher();

            // it's acceptable to block the transaction
            // during the response transmission since
            // it's a request re-transmission
            if (d != null) {
                d.dispatch(_response);
            }

            if (SipMonitoring.isEnabled(SipMonitoring.TRANSACTION_MANAGER)) {
                updateLastAccessTimestamp();
            }
        }

        return false; // Should not continue
    }

    // Record the last response for lost retransmissions
    public void dispatch(SipServletResponseImpl resp) {
        // a 100 Trying should never be forwarded...
        if (resp.getStatus() == 100) {
            return;
        }

        int status = resp.getStatus() / 100;

        synchronized (this) {
            switch (_state) {
            case TRYING:
                _response = resp;

                try {
                    resp.serializeForTransmission();
                } catch (UnsupportedEncodingException e) {
                    // If SipFactoryImpl.SIP_CHARSET = "UTF-8", no exception
                    // should
                    // occur since it is mandatory for this charset to exist.
                }

                if (status == 1) {
                    _state = PROCEEDING;
                } else {
                    toCompleted();
                }

                break;

            case PROCEEDING:
                _response = resp;

                try {
                    resp.serializeForTransmission();
                } catch (UnsupportedEncodingException e) {
                    // If SipFactoryImpl.SIP_CHARSET = "UTF-8", no exception
                    // should
                    // occur since it is mandatory for this charset to exist.
                }

                // 2XX - &XX response
                if ((status >= 2) && (status <= 6)) {
                    toCompleted();
                }

                break;

            case COMPLETED:
                return; // Should not get any response from TU in this state

            case TERMINATED:
                return; // Should not get any response from TU in this state

            default:

                if (_log.isLoggable(Level.FINE)) {
                    _log.log(Level.FINE, "IllegalState in ICT = " + _state);
                }
            }
        }

        Dispatcher d = resp.popDispatcher();

        try {
            if (d != null) {
                d.dispatch(resp);
            }
        } // Transport Error
        catch (Exception e) {
            terminate();

            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Handled : ", e);
            }
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see javax.servlet.sip.TimerListener#timeout(javax.servlet.sip.ServletTimer)
     */
    public void timeout(GeneralTimer timer) {
        TransactionTimer tt = (TransactionTimer) timer.getInfo();

        if (tt == TimerJ) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Timer J fired - terminating()");
            }

            synchronized (this) {
                _timerJ = null;
                terminate();
            }
        } else if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "IllegalTimer in ICT = " + tt);
        }
    }

    /* TODO check synchronization */
    protected synchronized void terminate() {
        _state = TERMINATED;
        super.terminate();

        if (_timerJ != null) {
            _timerJ.cancel();
            _timerJ = null;
        }
    }

    private void toCompleted() {
        if (!_reliableTransport) { // Start timer J

            if (SipMonitoring.isEnabled(SipMonitoring.TRANSACTION_MANAGER)) {
                // do not measure transationtime including timerJ
                updateLastAccessTimestamp();
            }

            _state = COMPLETED;

            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Timer J started - toCompleted()");
            }

            _timerJ = _timerService.createTimer(this, 64 * T1, false, TimerJ);
            // optimization during timerJ
            _request = null;
        } else {
            _state = TERMINATED; // TimerJ = 0
            super.terminate();
        }
    }

    void handleCancel(ServerTransaction st) {
        // N/A
    }
}
