/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.wrapper;

import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;

import com.ericsson.ssa.utils.objectwrapping.AbstractWrapperObject;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;


public class WrappedConvergedHttpSession extends AbstractWrapperObject<ConvergedHttpSession> implements ConvergedHttpSession {

	public WrappedConvergedHttpSession(ConvergedHttpSession session, WrapperContext context) {
		super(session, context);
	}

	public Object getAttribute(String arg0) {
		return getDelegate().getAttribute(arg0);
	}

	public Enumeration getAttributeNames() {
		return getDelegate().getAttributeNames();
	}

	public long getCreationTime() {
		return getDelegate().getCreationTime();
	}

	public String getId() {
		return getDelegate().getId();
	}

	public long getLastAccessedTime() {
		return getDelegate().getLastAccessedTime();
	}

	public int getMaxInactiveInterval() {
		return getDelegate().getMaxInactiveInterval();
	}

	/**
	 * Gets the servlets context. Modifications in servlet context will not trigger any replication 
	 * since replication of servlet context is not supported.
	 */
	public ServletContext getServletContext() {
		return getDelegate().getServletContext();
	}

	public HttpSessionContext getSessionContext() {
		return getDelegate().getSessionContext();
	}

	public Object getValue(String arg0) {
		return getDelegate().getValue(arg0);
	}

	public String[] getValueNames() {
		return getDelegate().getValueNames();
	}

	public void invalidate() {
		getDelegate().invalidate();
	}

	public boolean isNew() {
		return getDelegate().isNew();
	}

	public void putValue(String arg0, Object arg1) {
		getDelegate().putValue(arg0, arg1);
	}

	public void removeAttribute(String arg0) {
		getDelegate().removeAttribute(arg0);
	}

	public void removeValue(String arg0) {
		getDelegate().removeValue(arg0);
	}

	public void setAttribute(String arg0, Object arg1) {
		getDelegate().setAttribute(arg0, arg1);
	}

	public void setMaxInactiveInterval(int arg0) {
		getDelegate().setMaxInactiveInterval(arg0);
	}

	public String encodeURL(String url) {
		return getDelegate().encodeURL(url);
	}

	public String encodeURL(String relativePath, String scheme) {
		return getDelegate().encodeURL(relativePath, scheme);
	}

	public SipApplicationSession getApplicationSession() {
		return WrapperFactorySet.getSASFactory().wrap(getDelegate().getApplicationSession(), getContext());
	}
}
