/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.wrapper;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.URI;


import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.utils.objectwrapping.AbstractWrapperObject;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;
import com.ericsson.ssa.utils.objectwrapping.WrapperUtil;

/**
 * Makes sure that all methods are delegated to its delegate.
 *  
 * @author epkadsz
 *
 */
public class WrappedSipApplicationSession extends AbstractWrapperObject<SipApplicationSession> implements SipApplicationSession {

	/**
	 * Constructor.
	 * @param sas the sas to be wrapped.
	 */
	public WrappedSipApplicationSession(SipApplicationSession sas, WrapperContext context) {
		super(sas, context);
	}
	
	/**
	 * {@inheritDoc}
	 */
	public void encodeURI(URI uri) {
		getDelegate().encodeURI(uri);
	}

	/**
	 * {@inheritDoc}
	 */
	public URL encodeURL(URL url) {
		return getDelegate().encodeURL(url);
	}

	/**
	 * {@inheritDoc}
	 */
	public Object getAttribute(String name) {
		return getDelegate().getAttribute(name);
	}

	/**
	 * This shall not return any wrapped iterator.
	 * {@inheritDoc}
	 */
	public Iterator<String> getAttributeNames() {
		return getDelegate().getAttributeNames();
	}

	/**
	 * {@inheritDoc}
	 */
	public long getCreationTime() {
		return getDelegate().getCreationTime();
	}

	/**
	 * {@inheritDoc}
	 */
	public long getExpirationTime() {
		return getDelegate().getExpirationTime();
	}

	/**
	 * {@inheritDoc}
	 */
	public String getId() {
		return getDelegate().getId();
	}

	/**
	 * {@inheritDoc}
	 */
	public long getLastAccessedTime() {
		return getDelegate().getLastAccessedTime();
	}

	/**
	 * Returns a special iterator that will automatically wrap session into on-change replication sessions.
	 * No replication is invoked on SAS since its not modified.
	 * 
	 * @param id the session to retrieve
	 * @return a wrapped iterator providing On-Modify-Replication sip session instances.
	 */
	@SuppressWarnings("unchecked")
	public Iterator<?> getSessions() {
		Iterator<?> sourceIterator = getDelegate().getSessions();
		if (sourceIterator == Collections.EMPTY_LIST.iterator())
			return sourceIterator; //skip wrapping since there are are no elements
		else
			return WrapperUtil.wrap((Iterator)sourceIterator, WrapperFactorySet.getConvergedSessionFactory(), getContext());		
	}

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public Iterator<?> getSessions(String protocol) {
		Iterator<?> sourceIterator = getDelegate().getSessions(protocol);
		if (sourceIterator == Collections.EMPTY_LIST.iterator())
			return sourceIterator;
		else
		{
			if (SipFactoryImpl.SIP_URI_PROTOCOL.equalsIgnoreCase(protocol)) 
				return WrapperUtil.wrap((Iterator)sourceIterator, WrapperFactorySet.getSipSessionFactory(), getContext());
			else
				return WrapperUtil.wrap((Iterator)sourceIterator, WrapperFactorySet.getHttpSessionFactory(), getContext());
		}
	}
	
	/**
	 * Returns a wrapped SipSession that on each modification will replicate it self.
	 * No replication is invoked on SAS since its not modified.
	 * 
	 * @param id the session to retrieve
	 * @return a wrapped On-Modify-Replication sip session.
	 */
	public SipSession getSipSession(String id) {
		SipSession session = getDelegate().getSipSession(id);
		if (session != null)
			session = WrapperFactorySet.getSipSessionFactory().wrap(session, getContext());
		
		return session;
	}

	/**
	 * {@inheritDoc}
	 */
	public Collection<ServletTimer> getTimers() {
		Collection<ServletTimer> timers = getDelegate().getTimers();
		if (timers.size() == 0)
			return timers;
		
		return WrapperUtil.wrap(timers, WrapperFactorySet.getServletTimerFactory(), getContext());
	}

	/**
	 * {@inheritDoc}
	 */
	public void invalidate() {
		getDelegate().invalidate();
	}

	/**
	 * {@inheritDoc}
	 */
	public boolean isValid() {
		return getDelegate().isValid();
	}

	/**
	 * {@inheritDoc}
	 */
	public void removeAttribute(String name) {
		getDelegate().removeAttribute(name);
	}

	/**
	 * {@inheritDoc}
	 */
	public void setAttribute(String name, Object value) {
		getDelegate().setAttribute(name, value);
	}

	/**
	 * {@inheritDoc}
	 */
	public int setExpires(int expires) {
		return getDelegate().setExpires(expires);
	}
}
