/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.sip.wrapper;

import java.util.Enumeration;

import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

import com.ericsson.ssa.utils.objectwrapping.AbstractWrapperObject;
import com.ericsson.ssa.utils.objectwrapping.WrapperContext;

/**
 * Class for handle out-of-band / out-of-tree access.
 * Most of the modyfing method will trigger replication of the delegated sip entity.
 * @author epkadsz
 *
 */
public class WrappedSipSession extends AbstractWrapperObject<SipSession> implements SipSession {

	/**
	 * Default version id.
	 */
	private static final long serialVersionUID = 1L;
	
	public WrappedSipSession(SipSession session, WrapperContext context){
		super(session, context);
	}
	
	/**
	 * @param method the request type to create
	 * @return newly created request. 
	 */
	public SipServletRequest createRequest(String method) {
		return WrapperFactorySet.getSipRequestFactory().wrap(getDelegate().createRequest(method), getContext());
	}

	/**
	 * This access is considered as out-of-band access within this class.
	 * We don't bother to keep the wrapped reference since this is propably overkill. 
	 * 
	 * @return a wrapped On-Modify-Replication application session.
	 */
	public SipApplicationSession getApplicationSession() {
		return WrapperFactorySet.getSASFactory().wrap(getDelegate().getApplicationSession(), getContext());
	}

	public Object getAttribute(String name) {
		return getDelegate().getAttribute(name);
	}

	public Enumeration<String> getAttributeNames() {
		return getDelegate().getAttributeNames();
	}

	public String getCallId() {
		return getDelegate().getCallId();
	}

	public long getCreationTime() {
		return getDelegate().getCreationTime();
	}

	public String getId() {
		return getDelegate().getId();
	}

	public long getLastAccessedTime() {
		return getDelegate().getLastAccessedTime();
	}

	public Address getLocalParty() {
		return getDelegate().getLocalParty();
	}

	public String getRegion() {
		return getDelegate().getRegion();
	}

	public Address getRemoteParty() {
		return getDelegate().getRemoteParty();
	}

	public State getState() {
		return getDelegate().getState();
	}

	public URI getSubscriberURI() throws IllegalStateException {
		return getDelegate().getSubscriberURI();
	}

	public void invalidate() {
		getDelegate().invalidate();
	}

	public boolean isOngoingTransaction() {
		return getDelegate().isOngoingTransaction();
	}

	public boolean isValid() {
		return getDelegate().isValid();
	}

	public void removeAttribute(String name) {
		getDelegate().removeAttribute(name);
	}

	public void setAttribute(String name, Object value) {
		getDelegate().setAttribute(name, value);
	}

	public void setHandler(String name) throws ServletException {
		getDelegate().setHandler(name);
	}

	public void setOutboundInterface(SipURI uri) {
		getDelegate().setOutboundInterface(uri);
	}
}
