/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

/**
 * Factory for wrapping object instances. 
 * When wrapping objects the object look the same since delegate and the wrapped object have the same interface.
 * 
 * Generic interface used by collection and iterators so we dont need to write specific wrapper iterators but only ObjectWrappers.
 * 
 * @author epkadsz
 *
 * @param <T> type of object to wrap in.
 */
public interface ObjectWrapper<T> {
	/**
	 * The wrapping is done by wrapping an object of type T and returning the wrapped version of type T.
	 * If there are chained wrapped objects the WrapperContext is used as shared context between these.
	 * 
	 * @param object
	 * @param context the shared context to be set on the wrapped version
	 * @return
	 */
	public T wrap(T object, WrapperContext context);

}
