/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

import java.util.Iterator;


/**
 * This iterator wraps in object instances.
 * Every time an iterator is returning object, the object is wrapped by using the ObjectWrapper factory defined for this iterator.
 * 
 * @author epkadsz
 *
 * @param <E>
 */
public class ObjectWrapperIterator<E> extends AbstractWrapperObject<Iterator<E>> implements Iterator<E> {

	/**
	 * The actual instance wrapper for wrapping in returned instances by this iterator.
	 */
	private ObjectWrapper<E> _instanceWrapper;
	
	protected ObjectWrapper<E> getInstanceWrapper() {
		return _instanceWrapper;
	}
	
	/**
	 * Constructor of wrapping iterator.
	 * @param delegate
	 * @param instanceWrapper
	 */
	public ObjectWrapperIterator(Iterator<E> delegate, ObjectWrapper<E> instanceWrapper, WrapperContext context){
		super(delegate, context);
		_instanceWrapper = instanceWrapper;
	}
	public boolean hasNext() {
		return getDelegate().hasNext();
	}

	public E next() {
		return getInstanceWrapper().wrap(getDelegate().next(), getContext());
	}

	public void remove() {
		getDelegate().remove();
	}
}
