/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import javax.servlet.sip.SipServletRequest;

import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.wrapper.WrapperFactorySet;

/**
 * Wrapper list.
 * This wrapper does not consider is elements are retrieved and wrapped and then stored back again in this list.
 * This mean it does not unwrap it before adding to the list.  
 * 
 * @author EPKADSZ
 * @since 2007 nov 22
 *
 */
public class WrapperList<E> extends WrapperCollection<E> implements List<E> {

	public WrapperList(List<E> list, ObjectWrapper<E> instanceWrapper, WrapperContext context) {
		super(list, instanceWrapper, context);
	}

	public List<E> getDelegate() {
		return (List<E>)super.getDelegate();
	}
	public void add(int index, E element) {
		getDelegate().add(index, element);
	}

	public boolean addAll(int index, Collection<? extends E> c) {
		return getDelegate().addAll(index, c);
	}

	public E get(int index) {
		return getInstanceWrapper().wrap(getDelegate().get(index), getContext());
	}

	public int indexOf(Object o) {
		return getDelegate().indexOf(o);
	}

	public int lastIndexOf(Object o) {
		return getDelegate().lastIndexOf(o);
	}

	public ListIterator<E> listIterator() {
		return WrapperUtil.wrap(getDelegate().listIterator(), getInstanceWrapper(), getContext());
	}

	public ListIterator<E> listIterator(int index) {
		return getDelegate().listIterator(index);
	}

	public E remove(int index) {
		return getInstanceWrapper().wrap(getDelegate().remove(index), getContext());
	}

	public E set(int index, E element) {
		return getDelegate().set(index, element);
	}

	public List<E> subList(int fromIndex, int toIndex) {
		List<E> list = getDelegate().subList(fromIndex, toIndex);
		if (list.size() == 0)
			return list;
		
		return WrapperUtil.wrap(list, getInstanceWrapper(), getContext());
	}
	
	public static void main(String[] args)
	{
		try
		{
			SipServletRequestImpl ssr = new SipServletRequestImpl(); 
			List<SipServletRequest> list = new ArrayList<SipServletRequest>();
			list.add(ssr);
			List<SipServletRequest> newList = WrapperUtil.wrap(list, WrapperFactorySet.getSipRequestFactory(), null);
			Iterator<SipServletRequest> iter = newList.iterator();
			while (iter.hasNext())
			{
				isWrapped(iter.next());
			}
			isWrapped(newList.get(0));
			newList = newList.subList(0, 1);
			Iterator<SipServletRequest> iter2 = newList.iterator();
			isWrapped(iter2.next());
			ListIterator<SipServletRequest> listIterator = newList.listIterator(); 
			isWrapped(listIterator.next());
			isWrapped(listIterator.previous());
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
    private static void isWrapped(Object object) throws Exception
    {
    	if (!WrapperUtil.isWrapped(object))
    		throw new Exception("Object of type: " + object.getClass().getName() + " is not of type " + WrapperObject.class.getSimpleName());
    }

}
