/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.ssa.utils.objectwrapping;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/**
 * Util class for unwrapping objects if they are wrapped.
 * Additional general wrapping util methods are also added here.
 * 
 * @author epkadsz
 * @since 2007 nov 20
 *
 */
public class WrapperUtil {
	/**
	 * Unwrap the object if its already wrapped.
	 * 
	 * @param <T> The type to be autocasted to. This is either of type T or WrapperObject<T>
	 * @param candidate the object instance to check for wrapping
	 * 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public static <T>T unwrap(T candidate)
	{
		if (candidate instanceof WrapperObject)
			return ((WrapperObject<T>)candidate).getDelegate();
		
		return candidate;
	}
	
	/**
	 * Type cast to a wrapper object is possible.
	 * @param candidate the expected object to be made visible.
	 * @return casted candidate to WrapperObject
	 */
	public static WrapperObject revealWrapper(Object candidate) {
		return (WrapperObject)candidate;
	}
	
	public static boolean isWrapped(Object candidate) {
		if (candidate instanceof WrapperObject)
			return true;
		
		return false;
	}
	
	public static <T>List<T> wrap(List<T> list, ObjectWrapper<T> objectWrapper, WrapperContext context)
	{
		return new WrapperList<T>(list, objectWrapper, context);
	}
	
	public static <T>Iterator<T> wrap(Iterator<T> list, ObjectWrapper<T> objectWrapper, WrapperContext context)
	{
		return new ObjectWrapperIterator<T>(list, objectWrapper, context);
	}
	
	public static <T>ListIterator<T> wrap(ListIterator<T> list, ObjectWrapper<T> objectWrapper, WrapperContext context)
	{
		return new ObjectWrapperListIterator<T>(list, objectWrapper, context);
	}
	
	public static <T>Collection<T> wrap(Collection<T> list, ObjectWrapper<T> objectWrapper, WrapperContext context)
	{
		return new WrapperCollection<T>(list, objectWrapper, context);
	}	
}