/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package com.ericsson.util.os;

import sun.management.ManagementFactory;

import java.util.logging.Level;

// inserted by hockey (automatic)
import java.util.logging.Logger;


/**
 * Sun Microsystems' platform extensions for supporting operating system calls
 * in java.
 *
 * @author ehsroha
 * @since 2006-mar-31
 */
public class OSUtilSunspecific implements OSUtil {
    private static final Logger _log = (Logger) Logger.getLogger("SipContainer");
    private com.sun.management.OperatingSystemMXBean _mxbean = (com.sun.management.OperatingSystemMXBean) ManagementFactory.getOperatingSystemMXBean();
    private boolean _noPlatformSupport = false;
    private long _lastTime = 0;
    private long _lastProcessCpuTime = 0;
    private int _savedBusy = 0;

    public OSUtilSunspecific() {
        _lastTime = System.currentTimeMillis();
        _lastProcessCpuTime = _mxbean.getProcessCpuTime();
        _lastTime = System.currentTimeMillis();

        if (_lastProcessCpuTime == -1) {
            _log.log(Level.WARNING,
                "No platform support for com.sun.management.OperatingSystemMXBean.getProcessCpuTime()");
            // unfortunately no support on this platform...
            _noPlatformSupport = true;
        }
    }

    public String getInfo() {
        return getClass().getName() +
        " : Sun Microsystems' platform extensions";
    }

    /**
     * Get the Sun-specific attribute Process CPU time. Returns the cpu
     * utilization as an int. If this feature is not supported by the current
     * platform 0 is always returned.
     *
     * @return the cpu utilization as an int.
     */
    public int cpuBusy() {
        if (_noPlatformSupport) {
            return 0;
        }

        long now = System.currentTimeMillis();

        if ((now - _lastTime) > 1000) {
            // Returns the CPU time used by the process on which the Java virtual
            // machine is running in nanoseconds. The returned value is of
            // nanoseconds precision but not necessarily nanoseconds accuracy. This
            // method returns -1 if the the platform does not support this
            // operation.
            long currentProcessCpuTime = _mxbean.getProcessCpuTime();
            double busyPercent = (100 * (currentProcessCpuTime -
                _lastProcessCpuTime)) / (1000000 * (now - _lastTime));
            // save for next access.
            _lastTime = now;
            _lastProcessCpuTime = currentProcessCpuTime;
            _savedBusy = new Double(busyPercent).intValue();

            return _savedBusy;
        } else {
            return _savedBusy;
        }
    }

    /**
     * @param args
     */
    public static void main(String[] args) {
        OSUtilSunspecific osutil = new OSUtilSunspecific();
        Thread t = new Thread(new Runnable() {
                    public long fib(int n) {
                        if (n <= 1) {
                            return n;
                        } else {
                            return fib(n - 1) + fib(n - 2);
                        }
                    }

                    public void run() {
                        int N = 35;

                        for (int i = 1; i <= N; i++) {
                            fib(N);
                        }
                    }
                });
        t.start();

        for (int i = 0; i < 10; i++) {
            try {
                Thread.sleep(2000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }

            System.out.println("cpuBusy = " + osutil.cpuBusy());
        }
    }
}
