/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import javax.servlet.http.HttpSession;


/**
 * The ConvergedHttpSession class provides access to HttpSession related
 * functionality which is only present in a converged HTTP/SIP container.
 * In a converged container, an instance of HttpSession can be cast to
 * ConvergedHttpSession in order to access methods available only to
 * converged applications.
 *
 * @since 1.1
 */
public interface ConvergedHttpSession extends HttpSession {
    /**
     * Returns the parent <code>SipApplicationSession</code> if it exists,
     * if none exists then a new one is created and returned after
     * associating it with the converged http session.
     *
     * @return the parent SipApplicationSession
     */
    public SipApplicationSession getApplicationSession();

    /**
     * Encodes the HTTP URL with the jsessionid. ";jsessionid=http-session-id".
     * The URL parameter should be an absolute URL. For example,
     * http://server:7001/mywebapp/foo.jsp. Where "/mywebapp" is the context
     * path of the the current ServletContext, because that is where the
     * httpSession belongs to.
     *
     * @param url the HTTP URL String to be encoded
     *
     * @return encoded URL with jsessionid
     */
    public String encodeURL(String url);

    /**
     * Converts the given relative path to an absolute URL by prepending
     * the contextPath for the current ServletContext, the given scheme
     * ("http" or "https"), and the host:port, and then encoding the
     * resulting URL with the jsessionid.
     *
     * For example, this method converts:
     *
     *   from: "/foo.jsp"
     *   to: "http://server:8888/mywebapp/foo.jsp;jsessionid=http-session-id"
     *
     * Where, "/mywebapp" is the contextPath for the current ServletContext
     * server is the front end host defined for the web server.
     *
     * @param relativePath relative to the current webapp
     * @param scheme the scheme ("http" or "https")
     *
     * @return encoded URL with jsessionid
     */
    public String encodeURL(String relativePath, String scheme);
}
