/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;


/**
 * Enumerated type to represent routing regions in the application selection
 * process.
 *
 */
public class SipApplicationRoutingRegion {
    public static final SipApplicationRoutingRegion NEUTRAL_REGION = 
    	new SipApplicationRoutingRegion("Neutral Region",
            SipApplicationRoutingRegionType.NEUTRAL);
    public static final SipApplicationRoutingRegion ORIGINATING_REGION = 
    	new SipApplicationRoutingRegion("Originating Region",
            SipApplicationRoutingRegionType.ORIGINATING);
    public static final SipApplicationRoutingRegion TERMINATING_REGION = 
    	new SipApplicationRoutingRegion("Terminating Region",
            SipApplicationRoutingRegionType.TERMINATING);
    private SipApplicationRoutingRegionType type;
    private String label;

    public SipApplicationRoutingRegion(String label,
        SipApplicationRoutingRegionType type) {
        this.label = label;
        this.type = type;
    }

    public String getLabel() {
        return label;
    }

    public SipApplicationRoutingRegionType getType() {
        return type;
    }

    public String toString() {
        return "SipApplicationRoutingRegion : label " + label + " type " +
        type;
    }
}
