/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.IOException;

import javax.servlet.*;


public abstract class SipServlet extends GenericServlet {
    public static final String SIP_FACTORY = "javax.servlet.sip.SipFactory";
    public static final String SIP_SESSIONS_UTIL = "javax.servlet.sip.SipSessionsUtil";
    public static final String TIMER_SERVICE = "javax.servlet.sip.TimerService";
    public static final String SUPPORTED = "javax.servlet.sip.supported";
    public static final String OUTBOUND_INTERFACES = "javax.servlet.sip.outboundInterfaces";

    public SipServlet() {
    }

    public void service(ServletRequest req, ServletResponse resp)
        throws ServletException, IOException {
        if (req != null) {
            doRequest((SipServletRequest) req);
        } else {
            doResponse((SipServletResponse) resp);
        }
    }

    protected void doRequest(SipServletRequest req)
        throws ServletException, IOException {
        String m = req.getMethod();

        if ("INVITE".equals(m)) {
            doInvite(req);
        } else if ("ACK".equals(m)) {
            doAck(req);
        } else if ("OPTIONS".equals(m)) {
            doOptions(req);
        } else if ("BYE".equals(m)) {
            doBye(req);
        } else if ("CANCEL".equals(m)) {
            doCancel(req);
        } else if ("REGISTER".equals(m)) {
            doRegister(req);
        } else if ("SUBSCRIBE".equals(m)) {
            doSubscribe(req);
        } else if ("NOTIFY".equals(m)) {
            doNotify(req);
        } else if ("MESSAGE".equals(m)) {
            doMessage(req);
        } else if ("INFO".equals(m)) {
            doInfo(req);
        } else if ("PRACK".equals(m)) {
            doPrack(req);
        } else if ("PUBLISH".equals(m)) {
            doPublish(req);
        } else if ("REFER".equals(m)) {
            doRefer(req);
        } else if ("UPDATE".equals(m)) {
            doUpdate(req);
        } else if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doInvite(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doAck(SipServletRequest req)
        throws ServletException, IOException {
    }

    protected void doPublish(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doOptions(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doBye(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doCancel(SipServletRequest req)
        throws ServletException, IOException {
    }

    protected void doRegister(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doSubscribe(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doNotify(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doMessage(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doInfo(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doPrack(SipServletRequest req)
        throws ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    private void notHandled(SipServletRequest req) throws IOException {
        SipServletResponse resp = req.createResponse(500,
                "Request not handled by app");
        resp.send();
    }

    protected void doResponse(SipServletResponse resp)
        throws ServletException, IOException {
        int status = resp.getStatus();

        if (status < 200) {
            doProvisionalResponse(resp);
        } else if (status < 300) {
            doSuccessResponse(resp);
        } else if (status < 400) {
            doRedirectResponse(resp);
        } else {
            doErrorResponse(resp);
        }
    }

    protected void doProvisionalResponse(SipServletResponse resp)
        throws ServletException, IOException {
    }

    protected void doSuccessResponse(SipServletResponse resp)
        throws ServletException, IOException {
    }

    protected void doRedirectResponse(SipServletResponse resp)
        throws ServletException, IOException {
    }

    protected void doErrorResponse(SipServletResponse resp)
        throws ServletException, IOException {
    }

    protected void doRefer(SipServletRequest req)
        throws javax.servlet.ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    protected void doUpdate(SipServletRequest req)
        throws javax.servlet.ServletException, IOException {
        if (req.isInitial()) {
            notHandled(req);
        }
    }

    public void log(String message) {
        getServletContext().log(message);
    }

    public void log(String message, Throwable t) {
        getServletContext().log(message, t);
    }
}
