/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;

import java.io.BufferedReader;
import java.io.IOException;

import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;


public interface SipServletRequest extends ServletRequest, SipServletMessage {
    //289
    Address getPoppedRoute();

    void setRoutingDirective(SipApplicationRoutingDirective directive,
        SipServletRequest origRequest);

    B2buaHelper getB2buaHelper();

    void pushRoute(Address route);

    void pushPath(Address path);

    //116
    URI getRequestURI();

    void setRequestURI(URI reqUri);

    void pushRoute(SipURI route);

    int getMaxForwards();

    void setMaxForwards(int maxFw);

    void send() throws IOException;

    boolean isInitial();

    ServletInputStream getInputStream() throws IOException;

    BufferedReader getReader() throws IOException;

    Proxy getProxy() throws TooManyHopsException;

    Proxy getProxy(boolean create) throws TooManyHopsException;

    SipServletResponse createResponse(int statusCode);

    SipServletResponse createResponse(int statusCode, String reasonPhrase);

    SipServletRequest createCancel() throws IllegalStateException;

    void addAuthHeader(SipServletResponse chanllengeResponse, String username,
        String password);

    void addAuthHeader(SipServletResponse chanllengeResponse, AuthInfo authinfo);
}
