/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright (c) Ericsson AB, 2004-2007. All rights reserved.
 */
package javax.servlet.sip;


/**
 * A utility class providing additional support for converged HTTP/SIP applications and converged J2EE/SIP applications.
 *
 *
 * This class can be accessed through the ServletContext parameter named javax.servlet.sip.sessionsutil.
 *
 * @since 1.1
 *
 */
public interface SipSessionsUtil {
    /**
     * Returns the SipApplicationSession for a given applicationSessionId. The applicationSessionId String is the same as that obtained through SipApplicationSession.getId(). The method shall return the Application Session only if the queried application session belongs to the application from where this method is invoked. As an example if there exists a SIP Application with some J2EE component like a Message Driven Bean, bundled in the same application archive file (.war), then if the id of SipApplicationSession is known to the MDB it can get a reference to the SipApplicationSession object using this method. If this MDB were in a different application then it would not possible for it to access the SipApplicationSession. The method returns null in case the container does not find the SipApplicationSession instance matching the ID.
     *
     *
     * @param applicationSessionId - the SipApplicationSession's id
     * @return SipApplicationSession object or a null if it is not found
     * @throws NullPointerException - if the applicationSessionId is null.
     * @see SipApplicationSession.getId()
     */
    SipApplicationSession getApplicationSession(String applicationSessionId);

    void linkSession(Object key, String applicationSessionId);

    SipApplicationSession getLinkedSession(Object key);
}
