/*
 * BackupDeleteHandler.java
 *
 * Created on December 23, 2003, 1:23 AM
 */

package com.sun.enterprise.config.backup.phase;

import com.sun.enterprise.config.backup.utils.FactoryHelper;
import com.sun.enterprise.config.backup.utils.BackupHelper;
import com.sun.enterprise.config.backup.utils.LoggerHelper;
import com.sun.enterprise.config.backup.utils.LocalStringsHelper;
import com.sun.enterprise.config.backup.status.Status;
import com.sun.enterprise.config.backup.status.RemoveStatus;
import com.sun.enterprise.config.backup.status.StatusConstants;
import com.sun.enterprise.config.backup.BackupException;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;

/**
 *
 * @author  sridatta
 */
public class RemovePhases extends PhasesBase {
    
    /** Creates a new instance of BackupDeleteHandler */
    public RemovePhases() {
    }
    
    public RemoveStatus deleteBackup(File f, boolean system) {
        LoggerHelper.fine("deleting_backup_file " + f.getName());
        RemoveStatus rs = null;
        try {
           rs = new RemoveStatus(f.getName(), system);
           if(!f.exists()) {
               throw new BackupException(
                "error_delete_invalid_file",
                LocalStringsHelper.getString("error_delete_invalid_file",f));
           }
           FileUtils.liquidate(f);
           setSuccess(rs);
           //updateHistory(rs);//fixme
        } catch(Exception e) {
            RemoveStatus rs1 = null;
            try {
               rs1 = new RemoveStatus();
               setFailure(rs1, e);
            }catch (Exception ex){}
            return rs1;
        }
        return rs;
    }
    
    private void setSuccess(Status rs) {
        try {
                    rs.setStatusCode(StatusConstants.STATUS_SUCCESS);
        } catch (Exception e) {
            //ignore
        }
    }
    
    
    private void setFailure(Status rs, Exception e) {
        try {
                    rs.setStatusCode(StatusConstants.STATUS_FAILURE);
                    rs.setException(e);
        } catch (Exception e1) {
            //ignore
        }
    }
    
    public RemoveStatus deleteBackup(String name, boolean system) {
        File f;
        try {
            f = new File(BackupHelper.getAbsoluteBackupFileName(name));
        } catch(Exception e) {
            RemoveStatus rs = null;
            try {
               rs = new RemoveStatus();
               setFailure(rs, e);
            } catch(Exception ex){}
            return rs;
        }
        return deleteBackup(f, system);
    }
    
    private void updateHistory(Status rs) {
        try {
            FactoryHelper.getHistoryManager().addHistoryEntry(rs);
        } catch(Exception e) {
            LoggerHelper.warning("error_adding_history_entry", e);
            //ignore
        }
    }
}
