/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SvcTagException
extends Exception {
    public static final int GENERAL_ERROR = 0;
    public static final int AGENT_ALREADY_EXISTS = 1;
    public static final int SVCTAG_ALREADY_EXISTS = 2;
    public static final int INVALID_AGENT_REF = 3;
    public static final int INVALID_PRODUCT_REF = 4;
    public static final int XML_VALIDATION_FAILED = 5;
    public static final int RESOURCE_NOT_FOUND = 6;
    public static final int INVALID_EMAIL_FORMAT = 7;
    public static final int INVALID_COUNTRY = 8;
    public static final int USERNAME_ALREADY_EXISTS = 9;
    public static final int PASSWORD_TOO_SHORT = 10;
    public static final int ERROR_CREATING_ACCOUNT = 11;
    public static final int INVALID_USERNAME_PASSWORD = 12;
    public static final int CONNECTION_ERROR = 13;
    public static final int HTTP_ERROR = 14;
    public static final int IO_ERROR = 15;
    public static final int UNKNOWN_HOST = 16;
    public static final int MALFORMED_URL = 17;
    private static final String[] MESSAGES = new String[]{"General Error", "Agent Already Exists", "SvcTag Already Exists", "Invalid Agent Reference", "Invalid Product Reference", "XML Validation Failed", "Resource Not Found", "Invalid Email Format", "Invalid Country", "Username Already Exists", "Password Too Short", "Error Creating Account", "Invalid Sun Online Account UserName/Pasword", "Cannot connect to host", "Error HTTP response", "I/O Error", "Unknown Host", "Malformed URL"};
    public static final int ERROR_CODE_START = 12;
    private int code;
    private String msg;
    private int minorCode;
    private int majorCode;

    private SvcTagException() {
        this.code = 0;
        this.msg = MESSAGES[this.code];
    }

    public SvcTagException(int code) {
        this.code = code;
        this.minorCode = this.minorCode;
        this.msg = MESSAGES[code];
    }

    public SvcTagException(String message) {
        super(message);
    }

    public SvcTagException(Document doc) {
        this(0, doc);
    }

    public SvcTagException(int code, Document doc) {
        this.code = code;
        if (doc == null) {
            return;
        }
        try {
            Node n;
            String s;
            NodeList list = doc.getElementsByTagName("major-code");
            if (list.getLength() > 0 && (s = (n = list.item(0)).getTextContent()) != null) {
                try {
                    this.majorCode = Integer.parseInt(s.trim());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((list = doc.getElementsByTagName("minor-code")).getLength() > 0 && (s = (n = list.item(0)).getTextContent()) != null) {
                try {
                    this.minorCode = Integer.parseInt(s.trim());
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((list = doc.getElementsByTagName("message")).getLength() > 0) {
                n = list.item(0);
                this.msg = n.getTextContent();
            }
        }
        catch (Exception e) {
            this.msg = MESSAGES[code];
        }
    }

    public SvcTagException(int code, String message) {
        super(message);
        this.code = code;
        this.msg = message;
    }

    public SvcTagException(int code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.msg = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getDetailMessage() {
        return this.msg;
    }

    public int getMajorCode() {
        return this.majorCode;
    }

    public int getMinorCode() {
        return this.minorCode;
    }
}

