/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DTMNodeList
implements NodeList {
    private DTMIterator dtm_iter;
    private boolean valid = true;
    private int m_firstChild;
    private DTM m_parentDTM;

    public DTMNodeList(DTMIterator dtmIterator) {
        int pos = dtmIterator.getCurrentPos();
        try {
            this.dtm_iter = dtmIterator.cloneWithReset();
        }
        catch (CloneNotSupportedException cnse) {
            // empty catch block
        }
        this.dtm_iter.setShouldCacheNodes(true);
        this.dtm_iter.runTo(-1);
        this.dtm_iter.setCurrentPos(pos);
    }

    public DTMNodeList(DTM parentDTM, int parentHandle) {
        this.dtm_iter = null;
        this.m_parentDTM = parentDTM;
        this.m_firstChild = parentDTM.getFirstChild(parentHandle);
    }

    DTMIterator getDTMIterator() {
        return this.dtm_iter;
    }

    public Node item(int index) {
        if (this.dtm_iter != null) {
            int handle = this.dtm_iter.item(index);
            return this.dtm_iter.getDTM(handle).getNode(handle);
        }
        int handle = this.m_firstChild;
        while (--index >= 0 && handle != -1) {
            handle = this.m_parentDTM.getNextSibling(handle);
        }
        return this.m_parentDTM.getNode(handle);
    }

    public int getLength() {
        if (this.dtm_iter != null) {
            return this.dtm_iter.getLength();
        }
        int count = 0;
        int handle = this.m_firstChild;
        while (handle != -1) {
            ++count;
            handle = this.m_parentDTM.getNextSibling(handle);
        }
        return count;
    }
}

