/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;

public class CvsFileSet
extends FileSet {
    private static final Set[] NO_ENTRIES = new Set[]{Collections.EMPTY_SET, Collections.EMPTY_SET};
    private String mode = "controlled";

    public void setMode(Mode m) {
        this.mode = m.getValue();
    }

    public DirectoryScanner getDirectoryScanner(Project proj) throws BuildException {
        CvsFileSet cvsFileSet = this;
        if (cvsFileSet == null) {
            throw null;
        }
        CvsDirectoryScanner scan = cvsFileSet.new CvsDirectoryScanner();
        this.setupDirectoryScanner((FileScanner)scan, proj);
        scan.scan();
        return scan;
    }

    public static final class Mode
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"controlled", "uncontrolled", "text", "binary"};
        }
    }

    private class CvsDirectoryScanner
    extends DirectoryScanner {
        private final Map entries = new HashMap(100);

        protected boolean isIncluded(String name) throws BuildException {
            if (!super.isIncluded(name)) {
                return false;
            }
            File f = new File(this.getBasedir(), name);
            if (!f.exists()) {
                throw new IllegalStateException();
            }
            if (!f.isFile()) {
                return false;
            }
            Set[] entries = this.loadEntries(f.getParentFile());
            Set text = entries[0];
            Set binary = entries[1];
            String bname = f.getName();
            if (CvsFileSet.this.mode.equals("controlled")) {
                return text.contains(bname) || binary.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("uncontrolled")) {
                return !text.contains(bname) && !binary.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("text")) {
                return text.contains(bname);
            }
            if (CvsFileSet.this.mode.equals("binary")) {
                return binary.contains(bname);
            }
            throw new IllegalStateException(CvsFileSet.this.mode);
        }

        private Set[] loadEntries(File dir) throws BuildException {
            Set[] tb = (Set[])this.entries.get(dir);
            if (tb == null) {
                block10: {
                    File efile = new File(new File(dir, "CVS"), "Entries");
                    if (efile.exists()) {
                        tb = new Set[]{new HashSet(10), new HashSet(10)};
                        try {
                            FileReader r = new FileReader(efile);
                            try {
                                String line;
                                BufferedReader buf = new BufferedReader(r);
                                while ((line = buf.readLine()) != null) {
                                    String string;
                                    if (!string.startsWith("/")) continue;
                                    string = string.substring(1);
                                    int idx = string.indexOf(47);
                                    String name = string.substring(0, idx);
                                    idx = string.lastIndexOf(47);
                                    String subst = (string = string.substring(0, idx)).substring((idx = string.lastIndexOf(47)) + 1);
                                    if (subst.equals("")) {
                                        tb[0].add(name);
                                        continue;
                                    }
                                    if (subst.equals("-kb")) {
                                        tb[1].add(name);
                                        continue;
                                    }
                                    throw new BuildException("Strange key subst mode in " + efile + ": " + subst);
                                }
                                break block10;
                            }
                            finally {
                                Object var6_11 = null;
                                ((Reader)r).close();
                            }
                        }
                        catch (IOException ioe) {
                            throw new BuildException("While reading " + efile, (Throwable)ioe);
                        }
                    }
                    tb = NO_ENTRIES;
                }
                this.entries.put(dir, tb);
            }
            return tb;
        }

        protected boolean couldHoldIncluded(String name) {
            if (!super.couldHoldIncluded(name)) {
                return false;
            }
            return !name.endsWith(File.separatorChar + "CVS");
        }

        CvsDirectoryScanner() {
        }
    }
}

