/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.MakeLNBM;

public class LocMakeNBM
extends Task {
    protected String locales = null;
    protected String mainDir = null;
    protected File topDir = null;
    protected String fileName = null;
    protected String baseFileName = null;
    protected boolean deleteInfo = false;
    protected String nbmIncludes = null;
    protected String modInfo = null;
    protected String findLocBundle = ".";
    protected File locBundle = null;
    protected String locIncludes = null;
    static /* synthetic */ Class class$org$netbeans$nbbuild$MakeLNBM;

    public void setLocales(String string) {
        this.locales = string;
    }

    public void setMainDir(String string) {
        this.mainDir = string;
    }

    public void setTopDir(File file) {
        this.topDir = file;
    }

    public void setFile(String string) {
        this.fileName = string;
        if (!this.fileName.substring(this.fileName.length() - 4).equals(".nbm")) {
            throw new BuildException("NBM file name must end in '.nbm'");
        }
        this.baseFileName = this.fileName.substring(0, this.fileName.length() - 4);
    }

    public void setDeleteInfo(boolean bl) {
        this.deleteInfo = bl;
    }

    public void setNbmIncludes(String string) {
        this.nbmIncludes = string;
    }

    public void setModInfo(String string) {
        this.modInfo = string;
    }

    public void setLocBundle(File file) {
        this.locBundle = file;
    }

    public void setFindLocBundle(String string) {
        this.findLocBundle = string;
    }

    public void setLocIncludes(String string) {
        this.locIncludes = string;
    }

    public void execute() throws BuildException {
        try {
            this.really_execute();
        }
        catch (BuildException buildException) {
            buildException.printStackTrace();
            throw buildException;
        }
    }

    public void really_execute() throws BuildException {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.mainDir == null) {
            this.mainDir = new String("netbeans");
        }
        if (this.topDir == null) {
            this.topDir = this.getProject().getBaseDir();
        }
        if (this.printMissingDirWarning()) {
            return;
        }
        String string = this.getLocales();
        if (string == null || string.trim().equals("")) {
            throw new BuildException("Must specify 1 or more locales.");
        }
        if (this.fileName == null) {
            throw new BuildException("Must specify the file attribute.");
        }
        this.project.addTaskDefinition("makelnbm", class$org$netbeans$nbbuild$MakeLNBM == null ? (class$org$netbeans$nbbuild$MakeLNBM = LocMakeNBM.class$("org.netbeans.nbbuild.MakeLNBM")) : class$org$netbeans$nbbuild$MakeLNBM);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!this.hasFilesInLocale(string2)) continue;
            linkedList.add(string2);
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            this.buildNbm((String)listIterator.next());
        }
    }

    protected void buildNbm(String string) throws BuildException {
        Object object;
        LinkedList linkedList = new LinkedList();
        String string2 = new String();
        if (this.deleteInfo) {
            Delete delete = (Delete)this.project.createTask("delete");
            delete.init();
            delete.setDir(new File(this.topDir.getAbsolutePath() + File.separator + "Info"));
            delete.execute();
            delete.setDir(new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + string));
            delete.execute();
        } else {
            this.switchInfo(true, string);
        }
        MakeLNBM makeLNBM = (MakeLNBM)this.project.createTask("makelnbm");
        makeLNBM.init();
        makeLNBM.setModInfo(this.modInfo);
        makeLNBM.setLangCode(string);
        makeLNBM.setFile(new File(this.getProject().getBaseDir().getAbsolutePath() + File.separator + this.getLocalizedFileName(string)));
        makeLNBM.setTopdir(this.topDir);
        makeLNBM.setIsStandardInclude(false);
        File file = this.getLicenseFile(string);
        if (file != null) {
            object = makeLNBM.createLicense();
            ((MakeLNBM.Blurb)object).setFile(file);
        }
        if (this.locBundle != null) {
            this.setLocBundle(makeLNBM, this.getSpecificLocBundleFile(this.locBundle, string));
        } else {
            this.setLocBundle(makeLNBM, this.findLocBundle(makeLNBM, string));
        }
        if (this.getKeystore() != null && this.getStorepass() != null && this.getAlias() != null) {
            object = makeLNBM.createSignature();
            ((MakeLNBM.Signature)object).setKeystore(new File(this.getKeystore()));
            ((MakeLNBM.Signature)object).setStorepass(this.getStorepass());
            ((MakeLNBM.Signature)object).setAlias(this.getAlias());
        }
        this.addLocalePatterns(linkedList, string);
        ListIterator listIterator = linkedList.listIterator();
        boolean bl = true;
        while (listIterator.hasNext()) {
            String string3 = (String)listIterator.next();
            if (!bl) {
                string2 = string2 + ",";
            }
            string2 = string2 + string3;
            bl = false;
        }
        if (this.nbmIncludes != null && !this.nbmIncludes.trim().equals("")) {
            if (!bl) {
                string2 = string2 + ",";
            }
            string2 = string2 + this.nbmIncludes;
        }
        makeLNBM.setIncludes(string2);
        makeLNBM.execute();
        this.switchInfo(false, string);
    }

    protected File getLicenseFile(String string) {
        String string2 = string + ".license.file";
        String string3 = this.project.getProperty(string2);
        File file = null;
        if (string3 != null) {
            file = new File(string3);
        }
        return file;
    }

    protected void switchInfo(boolean bl, String string) {
        if (bl) {
            File file = new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + string);
            file.renameTo(new File(this.topDir.getAbsolutePath() + File.separator + "Info"));
        } else {
            File file = new File(this.topDir.getAbsolutePath() + File.separator + "Info");
            file.renameTo(new File(this.topDir.getAbsolutePath() + File.separator + "Info_" + string));
        }
    }

    protected String getLocalizedFileName(String string) {
        return this.baseFileName + "_" + string + ".nbm";
    }

    protected String getLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        return this.getGlobalProp("locmakenbm.locales");
    }

    protected boolean hasFilesInLocale(String string) {
        boolean bl = true;
        FileSet fileSet = new FileSet();
        fileSet.setDir(this.topDir);
        this.addLocalePatterns(fileSet, string);
        String[] stringArray = fileSet.getDirectoryScanner(this.project).getIncludedFiles();
        if (stringArray.length == 0) {
            bl = false;
        }
        return bl;
    }

    protected void addLocalePatterns(FileSet fileSet, String string) {
        LinkedList linkedList = new LinkedList();
        this.addLocalePatterns(linkedList, string);
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            fileSet.createInclude().setName((String)listIterator.next());
        }
    }

    protected void addLocalePatterns(LinkedList linkedList, String string) {
        String string2 = new String();
        String string3 = new String();
        string2 = this.mainDir;
        string3 = string2 + "/**/*_" + string + ".*";
        linkedList.add(new String(string3));
        string3 = string2 + "/**/" + string + "/";
        linkedList.add(new String(string3));
        this.addLocIncludes(linkedList, string);
        if (string.equals("ja")) {
            this.addLocalePatterns(linkedList, "ja_JP.PCK");
            this.addLocalePatterns(linkedList, "ja_JP.eucJP");
            this.addLocalePatterns(linkedList, "ja_JP.SJIS");
            this.addLocalePatterns(linkedList, "ja_JP.UTF-8");
            this.addLocalePatterns(linkedList, "ja_JP.UTF8");
        }
    }

    protected void addLocIncludes(LinkedList linkedList, String string) {
        if (this.locIncludes == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.locIncludes, ",\n\t ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(":");
            if (n != -1) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                if (!string3.equals(string)) continue;
                linkedList.add(new String(string4));
                continue;
            }
            linkedList.add(new String(string2));
        }
    }

    protected String getGlobalProp(String string) {
        String string2 = this.project.getProperty(string);
        if (string2 != null) {
            if (string2.trim().equals("")) {
                string2 = null;
            } else if (string2.indexOf("${") != -1) {
                string2 = null;
            }
        }
        return string2;
    }

    protected String getKeystore() {
        return this.getGlobalProp("locmakenbm.keystore");
    }

    protected String getStorepass() {
        return this.getGlobalProp("locmakenbm.storepass");
    }

    protected String getAlias() {
        return this.getGlobalProp("locmakenbm.alias");
    }

    protected boolean printMissingDirWarning() {
        boolean bl = false;
        if (!this.topDir.exists()) {
            this.log("WARNING: Skipping this task: Directory " + this.topDir.getPath() + " doesn't exist.");
            bl = true;
        }
        return bl;
    }

    protected void setLocBundle(MakeLNBM makeLNBM, File file) {
        if (file != null && file.exists()) {
            makeLNBM.setLocBundle(file);
        } else {
            this.log("WARNING: Localizing bundle not found: " + (file == null ? "" : file.getPath()));
        }
    }

    protected String getSrcDir(File file) {
        char[] cArray = new char[200];
        String string = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            int n = inputStreamReader.read(cArray);
            if (n != -1) {
                int n2;
                if (cArray[n - 1] == '\n') {
                    --n;
                }
                if ((n2 = (string = new String(cArray, 0, n)).indexOf("=")) != -1) {
                    string = string.substring(n2 + 1);
                    string.trim();
                } else {
                    string = null;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.getMessage());
            exception.printStackTrace();
            throw new BuildException();
        }
        return string;
    }

    protected File findLocBundle(MakeLNBM makeLNBM, String string) {
        String string2 = null;
        File file = new File(this.topDir.getAbsolutePath() + File.separator + "srcdir.properties");
        if (file.exists()) {
            string2 = this.getSrcDir(file);
        }
        if (string2 == null) {
            throw new BuildException("ERROR: Could not get source dir from: " + file.getPath());
        }
        int n = this.modInfo.indexOf("/");
        String string3 = n != -1 ? this.modInfo.substring(0, n) : new String(this.modInfo);
        string3 = string3.replace('.', '/');
        File file2 = new File(this.getRelPath(string2 + "/" + string3, this.findLocBundle).replace('/', File.separatorChar));
        return this.getDefaultLocBundleFile(file2, string);
    }

    protected File getDefaultLocBundleFile(File file, String string) {
        return new File(file.getPath() + File.separator + "Bundle_" + string + ".properties");
    }

    protected File getSpecificLocBundleFile(File file, String string) {
        String string2 = file.getPath();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            return new File(string2.substring(0, n) + "_" + string + string2.substring(n));
        }
        return new File(string2 + "_" + string);
    }

    protected String getRelPath(String string, String string2) {
        int n;
        if (string2.equals(".")) {
            return string;
        }
        while ((n = string2.indexOf("..")) != -1) {
            int n2;
            n = (string2 = string2.substring(2)).indexOf("/");
            if (n == 0) {
                string2 = string2.substring(1);
            }
            if ((n2 = string.lastIndexOf("/")) == -1) continue;
            string = string.substring(0, n2);
        }
        return string + "/" + string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

