/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scn.client.comm;

import com.sun.scn.client.comm.AuthenticationException;
import com.sun.scn.client.comm.RegSender;
import com.sun.scn.client.comm.SvcTagException;
import com.sun.scn.client.util.SCRKClientHelper;
import com.sun.scn.dao.Domain;
import com.sun.scn.servicetags.Agent;
import com.sun.scn.servicetags.AuthenticationCredential;
import com.sun.scn.servicetags.EnvironmentInformation;
import com.sun.scn.servicetags.SunOnlineAccount;
import com.sun.scn.servicetags.SvcTag;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistrationWrapper {
    private String registratorId;
    private String proxyHost;
    private int proxyPort;

    public RegistrationWrapper(String registratorId) {
        if (registratorId == null) {
            registratorId = "";
        } else {
            this.registratorId = registratorId + ":";
        }
        this.proxyHost = null;
        this.proxyPort = -1;
    }

    public RegistrationWrapper(String registratorId, String proxyHost, int proxyPort) {
        if (registratorId == null) {
            registratorId = "";
        } else {
            this.registratorId = registratorId + ":";
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void createSunOnlineAccount(SunOnlineAccount soa) throws SvcTagException {
        RegSender.createSunOnlineAccount(soa, this.proxyHost, this.proxyPort);
    }

    public void registerServiceTag(EnvironmentInformation environment, SvcTag serviceTag, String registryURN, String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        ArrayList<SvcTag> set = new ArrayList<SvcTag>();
        set.add(serviceTag);
        this.registerServiceTags(environment, set, registryURN, user, pass);
    }

    public AuthenticationCredential authenticate(String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        KeyPair keyPair = null;
        String clientId = null;
        try {
            SCRKClientHelper clientHelper = new SCRKClientHelper();
            keyPair = clientHelper.getKeyPair();
            clientId = clientHelper.getClientRegId(keyPair, user, pass, this.proxyHost, this.proxyPort);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (UnknownHostException uhe) {
            throw uhe;
        }
        catch (RuntimeException rte) {
            throw new SvcTagException(rte.getMessage());
        }
        catch (Exception e) {
            throw new AuthenticationException(e.getMessage());
        }
        if (keyPair == null) {
            throw new SvcTagException("Failed to generate a keypair for communication with SCRK.\n");
        }
        if (clientId == null) {
            throw new AuthenticationException("Failed to retrieve the client registration ID.\n");
        }
        AuthenticationCredential cred = new AuthenticationCredential(keyPair, clientId, user);
        return cred;
    }

    public void registerServiceTags(EnvironmentInformation environment, List<SvcTag> serviceTags, String registryURN, String user, String pass) throws SvcTagException, AuthenticationException, ConnectException, UnknownHostException {
        this.registerServiceTags(environment, serviceTags, registryURN, this.authenticate(user, pass));
    }

    public void registerServiceTags(EnvironmentInformation environment, List<SvcTag> serviceTags, String registryURN, AuthenticationCredential cred) throws SvcTagException, ConnectException, UnknownHostException {
        String agentUrn;
        if (cred == null) {
            throw new SvcTagException("Authentication credentials cannot be null");
        }
        String clientId = cred.getRegistrationClientId();
        KeyPair keyPair = cred.getKeyPair();
        String user = cred.getUsername();
        List<Domain> domains = null;
        domains = this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1 ? RegSender.getUserDomains(user, keyPair, clientId) : RegSender.getUserDomains(user, this.proxyHost, this.proxyPort, keyPair, clientId);
        Domain domain = this.getDefaultDomain(domains, user);
        if (domain == null) {
            throw new SvcTagException("Attempt to obtain default domain to register service tag under was unsuccessful.");
        }
        try {
            agentUrn = registryURN;
            if (agentUrn == null) {
                agentUrn = "urn:st:" + this.registratorId + UUID.randomUUID().toString();
            }
            Agent agent = new Agent(agentUrn);
            agent.host = environment.getHostname();
            agent.hostid = environment.getHostId();
            agent.serialNumber = environment.getSerialNumber();
            agent.system = environment.getOsName();
            agent.release = environment.getOsVersion();
            agent.architecture = environment.getOsArchitecture();
            agent.platform = environment.getSystemModel();
            agent.manufacturer = environment.getSystemManufacturer();
            agent.cpuManufacturer = environment.getCpuManufacturer();
            if (this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1) {
                RegSender.sendPut(agent.toXMLElement(false), "agent/" + agent.getAgentURN(), keyPair, clientId);
            } else {
                RegSender.sendPut(agent.toXMLElement(false), "agent/" + agent.getAgentURN(), this.proxyHost, this.proxyPort, keyPair, clientId);
            }
        }
        catch (SvcTagException ste) {
            throw ste;
        }
        catch (Exception e) {
            throw new SvcTagException("Attempt to register service tag was unsuccessful. Problem detected while registering Service Tag Agent: " + e.getMessage());
        }
        for (SvcTag serviceTag : serviceTags) {
            try {
                serviceTag.setRegistrationClientURN("urn:st:" + this.registratorId + UUID.randomUUID().toString());
                serviceTag.setUserID(user);
                serviceTag.setAgentURN(agentUrn);
                serviceTag.setStatus("REGISTERED");
                serviceTag.setDomainId(domain.getDomainId());
                serviceTag.setDomainName(domain.getDomainName());
                if (this.proxyHost == null || this.proxyHost.equals("") || this.proxyPort == -1) {
                    RegSender.sendPut(serviceTag.toXMLElement(), "svctag/" + serviceTag.getInstanceURN(), keyPair, clientId);
                    continue;
                }
                RegSender.sendPut(serviceTag.toXMLElement(), "svctag/" + serviceTag.getInstanceURN(), this.proxyHost, this.proxyPort, keyPair, clientId);
            }
            catch (SvcTagException ste) {
                throw ste;
            }
            catch (Exception e) {
                throw new SvcTagException("Attempt to register service tag was unsuccessful. Problem detected while registering Service Tag: " + e.getMessage());
            }
        }
    }

    public List<String> getAvailableSecurityQuestions() {
        ArrayList<String> secQuestions = new ArrayList<String>();
        secQuestions.add("What is your favorite color?");
        secQuestions.add("What is your pet's name?");
        secQuestions.add("Where is your favorite vacation destination?");
        return secQuestions;
    }

    public List<String> getAvailableCountries() {
        ArrayList<String> countries = new ArrayList<String>();
        countries.add("Albania");
        countries.add("Algeria");
        countries.add("American Samoa");
        countries.add("Andorra");
        countries.add("Angola");
        countries.add("Anguilla");
        countries.add("Antarctica");
        countries.add("Antigua & Barbuda");
        countries.add("Argentina");
        countries.add("Armenia");
        countries.add("Aruba");
        countries.add("Ascension Island");
        countries.add("Australia");
        countries.add("Austria");
        countries.add("Azerbaijan");
        countries.add("Bahamas");
        countries.add("Bahrain");
        countries.add("Bangladesh");
        countries.add("Barbados");
        countries.add("Belarus");
        countries.add("Belgium");
        countries.add("Belize");
        countries.add("Benin");
        countries.add("Bermuda");
        countries.add("Bhutan");
        countries.add("Bolivia");
        countries.add("Bosnia and Herzegovina");
        countries.add("Botswana");
        countries.add("Bouvet Island");
        countries.add("Brazil");
        countries.add("British Indian Ocean Territory");
        countries.add("Brunei Darussalam");
        countries.add("Bulgaria");
        countries.add("Burkina Faso");
        countries.add("Burundi");
        countries.add("Cambodia");
        countries.add("Cameroon");
        countries.add("Canada");
        countries.add("Cape Verde");
        countries.add("Cayman Islands");
        countries.add("Central African Republic");
        countries.add("Chad");
        countries.add("Chile");
        countries.add("China");
        countries.add("Christmas Island");
        countries.add("Cocos (Keeling) Islands");
        countries.add("Colombia");
        countries.add("Comoros");
        countries.add("Congo, Democratic Republic of the");
        countries.add("Congo, Republic of");
        countries.add("Cook Islands");
        countries.add("Costa Rica");
        countries.add("Cote d'Ivoire");
        countries.add("Croatia/Hrvatska");
        countries.add("Cyprus");
        countries.add("Czech Republic");
        countries.add("Denmark");
        countries.add("Djibouti");
        countries.add("Dominica");
        countries.add("Dominican Republic");
        countries.add("East Timor");
        countries.add("Ecuador");
        countries.add("Egypt");
        countries.add("El Salvador");
        countries.add("Equatorial Guinea");
        countries.add("Eritrea");
        countries.add("Estonia");
        countries.add("Ethiopia");
        countries.add("Falkland Islands (Malvina)");
        countries.add("Faroe Islands");
        countries.add("Fiji");
        countries.add("Finland");
        countries.add("France");
        countries.add("France (Metropolitan)");
        countries.add("French Guiana");
        countries.add("French Polynesia");
        countries.add("French Southern Territories");
        countries.add("Gabon");
        countries.add("Gambia");
        countries.add("Georgia");
        countries.add("Germany");
        countries.add("Ghana");
        countries.add("Gibraltar");
        countries.add("Greece");
        countries.add("Greenland");
        countries.add("Grenada");
        countries.add("Guadeloupe");
        countries.add("Guam");
        countries.add("Guatemala");
        countries.add("Guernsey");
        countries.add("Guinea");
        countries.add("Guinea-Bissau");
        countries.add("Guyana");
        countries.add("Haiti");
        countries.add("Heard and McDonald Islands");
        countries.add("Holy See (City Vatican State)");
        countries.add("Honduras");
        countries.add("Hong Kong");
        countries.add("Hungary");
        countries.add("Iceland");
        countries.add("India");
        countries.add("Indonesia");
        countries.add("Ireland");
        countries.add("Isle of Man");
        countries.add("Israel");
        countries.add("Italy");
        countries.add("Jamaica");
        countries.add("Japan");
        countries.add("Jersey");
        countries.add("Jordan");
        countries.add("Kazakhstan");
        countries.add("Kenya");
        countries.add("Kiribati");
        countries.add("Korea, Republic of");
        countries.add("Kuwait");
        countries.add("Kyrgyzstan");
        countries.add("Lao People's Democratic Republic");
        countries.add("Latvia");
        countries.add("Lebanon");
        countries.add("Lesotho");
        countries.add("Liberia");
        countries.add("Libyan Arab Jamahiriya");
        countries.add("Liechtenstein");
        countries.add("Lithuania");
        countries.add("Luxembourg");
        countries.add("Macau");
        countries.add("Macedonia, Former Yugoslav Republic");
        countries.add("Madagascar");
        countries.add("Malawi");
        countries.add("Malaysia");
        countries.add("Maldives");
        countries.add("Mali");
        countries.add("Malta");
        countries.add("Marshall Islands");
        countries.add("Martinique");
        countries.add("Mauritania");
        countries.add("Mauritius");
        countries.add("Mayotte");
        countries.add("Mexico");
        countries.add("Micronesia, Federal State of");
        countries.add("Moldova, Republic of");
        countries.add("Monaco");
        countries.add("Mongolia");
        countries.add("Montserrat");
        countries.add("Morocco");
        countries.add("Mozambique");
        countries.add("Namibia");
        countries.add("Nauru");
        countries.add("Nepal");
        countries.add("Netherlands");
        countries.add("Netherlands Antilles");
        countries.add("New Caledonia");
        countries.add("New Zealand");
        countries.add("Nicaragua");
        countries.add("Niger");
        countries.add("Nigeria");
        countries.add("Niue");
        countries.add("Norfolk Islands");
        countries.add("Northern Mariana Islands");
        countries.add("Norway");
        countries.add("Not Determined");
        countries.add("Oman");
        countries.add("Pakistan");
        countries.add("Palau");
        countries.add("Panama");
        countries.add("Papua New Guinea");
        countries.add("Paraguay");
        countries.add("Peru");
        countries.add("Philippines");
        countries.add("Pitcairn Island");
        countries.add("Poland");
        countries.add("Portugal");
        countries.add("Puerto Rico");
        countries.add("Qatar");
        countries.add("Reunion Island");
        countries.add("Romania");
        countries.add("Russian Federation");
        countries.add("Rwanda");
        countries.add("Saint Kitts and Nevis");
        countries.add("Saint Lucia");
        countries.add("Saint Vincent and the Grenadines");
        countries.add("San Marino");
        countries.add("Sao Tome and Principe");
        countries.add("Saudi Arabia");
        countries.add("Senegal");
        countries.add("Seychelles");
        countries.add("Sierra Leone");
        countries.add("Singapore");
        countries.add("Slovak Republic");
        countries.add("Slovenia");
        countries.add("Solomon Islands");
        countries.add("Somalia");
        countries.add("South Africa");
        countries.add("South Georgia and the South Sandwich Islands");
        countries.add("Spain");
        countries.add("Sri Lanka");
        countries.add("St Pierre and Miquelon");
        countries.add("St. Helena");
        countries.add("Suriname");
        countries.add("Svalbard and Jan Mayen Islands");
        countries.add("Swaziland");
        countries.add("Sweden");
        countries.add("Switzerland");
        countries.add("Taiwan");
        countries.add("Tajikistan");
        countries.add("Tanzania");
        countries.add("Thailand");
        countries.add("Togo");
        countries.add("Tokelau");
        countries.add("Tonga");
        countries.add("Trinidad and Tobago");
        countries.add("Tunisia");
        countries.add("Turkey");
        countries.add("Turkmenistan");
        countries.add("Turks and Caicos Islands");
        countries.add("Tuvalu");
        countries.add("US Minor Outlying Islands");
        countries.add("Uganda");
        countries.add("Ukraine");
        countries.add("United Arab Emirates");
        countries.add("United Kingdom");
        countries.add("United States");
        countries.add("Uruguay");
        countries.add("Uzbekistan");
        countries.add("Vanuatu");
        countries.add("Venezuela");
        countries.add("Vietnam");
        countries.add("Virgin Island (British)");
        countries.add("Virgin Islands (USA)");
        countries.add("Wallis and Futuna Islands");
        countries.add("Western Sahara");
        countries.add("Western Samoa");
        countries.add("Yemen");
        countries.add("Yugoslavia");
        countries.add("Zambia");
        countries.add("Zimbabwe");
        return countries;
    }

    private Domain getDefaultDomain(List<Domain> domains, String user) {
        Domain defaultDomain = null;
        if (domains != null && user != null) {
            for (Domain d : domains) {
                if (!d.getDomainName().toLowerCase().contains(user.toLowerCase())) continue;
                defaultDomain = d;
                return defaultDomain;
            }
            defaultDomain = domains.get(0);
        }
        return defaultDomain;
    }
}

