/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf.shale;

import java.io.IOException;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jmaki.runtime.jsf.AjaxResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.impl.FilteringProcessor;

public class RemotingProcessor
extends FilteringProcessor {
    private static Log logger;

    public static Log getLogger() {
        if (logger == null) {
            logger = LogFactory.getLog((String)"jmaki.runtime.Log");
        }
        return logger;
    }

    public void process(FacesContext context, String resourceId) throws IOException {
        if (context.getResponseComplete()) {
            return;
        }
        if (!this.accept(resourceId)) {
            RemotingProcessor.getLogger().debug((Object)("Resource id '" + resourceId + "' rejected by include/exclude rules"));
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        this.processAjaxRequest(context, resourceId);
        context.responseComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAjaxRequest(FacesContext context, String rootId) {
        block10: {
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            Object object = context.getExternalContext().getRequest();
            if (!(object instanceof HttpServletRequest)) {
                return;
            }
            HttpServletRequest request = (HttpServletRequest)object;
            String cmd = request.getParameter("cmd");
            int targetIndex = rootId.lastIndexOf("/");
            if (targetIndex < 0) {
                targetIndex = 0;
            }
            String target = rootId.substring(targetIndex, rootId.length());
            String[] bindingArgs = target.split("-");
            String tO = bindingArgs[0].substring(1, bindingArgs[0].length());
            String tM = bindingArgs[1].substring(0, bindingArgs[1].length());
            String bindingExpression = "#{" + tO + "." + tM + "}";
            try {
                if (cmd != null && "update".equals(cmd)) {
                    String value = request.getParameter("value");
                    if (value != null) {
                        boolean success = this.updateValueBoundObject(context, bindingExpression, value);
                        response.setHeader("Cache-Control", "no-cache");
                        response.getWriter().write("<status>" + success + "</status>");
                    }
                    break block10;
                }
                AjaxResult result = this.invokeBinding(context, bindingExpression);
                if (result.getResponseType() == AjaxResult.XML) {
                    response.setContentType("text/xml");
                }
                response.setHeader("Cache-Control", "no-cache");
                response.getWriter().write(result.toString());
            }
            catch (EvaluationException ee) {
                RemotingProcessor.getLogger().fatal((Object)ee.toString());
            }
            catch (IOException ioe) {
                RemotingProcessor.getLogger().fatal((Object)ioe.toString());
            }
        }
        context.responseComplete();
    }

    private AjaxResult invokeBinding(FacesContext context, String methodBinding) {
        if (UIComponentTag.isValueReference((String)methodBinding)) {
            Class[] argTypes = new Class[]{FacesContext.class, AjaxResult.class};
            MethodBinding vb = context.getApplication().createMethodBinding(methodBinding, argTypes);
            AjaxResult result = new AjaxResult();
            Object[] args = new Object[]{context, result};
            vb.invoke(context, args);
            return result;
        }
        RemotingProcessor.getLogger().fatal((Object)("AjaxWrapperPhaseListener Error: Bad method binding: " + methodBinding));
        return null;
    }

    private boolean updateValueBoundObject(FacesContext context, String valueBinding, String value) {
        try {
            ValueBinding vb = context.getApplication().createValueBinding(valueBinding);
            vb.setValue(context, (Object)value);
        }
        catch (EvaluationException ex) {
            return false;
        }
        return true;
    }

    private void sendNotFound(FacesContext context, String resourceId) throws IOException {
        if (!this.servletRequest(context)) {
            throw new IllegalArgumentException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(404, resourceId);
    }

    private boolean servletRequest(FacesContext context) {
        return context.getExternalContext().getContext() instanceof ServletContext;
    }
}

