/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Arch
extends Task
implements ErrorHandler {
    private Map answers;
    private Map questions;
    private File questionsFile;
    private File output;
    private String stylesheet = null;
    private String overviewlink = null;
    private String footer = null;

    public void setAnswers(File f) {
        this.questionsFile = f;
    }

    public void setOutput(File f) {
        this.output = f;
    }

    public void setStylesheet(String s) {
        this.stylesheet = s;
    }

    public void setOverviewlink(String s) {
        this.overviewlink = s;
    }

    public void setFooter(String s) {
        this.footer = s;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        Object s;
        void q;
        boolean generateTemplate;
        if (this.questionsFile == null) {
            throw new BuildException("questions file must be provided");
        }
        if (this.output == null) {
            throw new BuildException("output file must be specified");
        }
        boolean bl = generateTemplate = !this.questionsFile.exists();
        if (!generateTemplate && this.output.exists() && this.questionsFile.lastModified() <= this.output.lastModified() && this.getProject().getProperty("arch.generate") == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this);
            Document document = generateTemplate ? builder.parse(this.getClass().getResourceAsStream("Arch-api-questions.xml")) : builder.parse(this.questionsFile);
        }
        catch (SAXParseException ex) {
            this.log(ex.getSystemId() + ":" + ex.getLineNumber() + ": " + ex.getLocalizedMessage(), 0);
            throw new BuildException(this.questionsFile.getAbsolutePath() + " is malformed or invalid", (Throwable)ex, this.location);
        }
        catch (Exception ex) {
            throw new BuildException("File " + this.questionsFile + " cannot be parsed: " + ex.getLocalizedMessage(), (Throwable)ex, this.location);
        }
        this.questions = Arch.readElements((Document)q, "question");
        NodeList apiQuestions = q.getElementsByTagName("api-questions");
        if (apiQuestions.getLength() != 1) {
            throw new BuildException("No element api-questions");
        }
        String questionsVersion = ((Element)apiQuestions.item(0)).getAttribute("version");
        if (questionsVersion == null) {
            throw new BuildException("Element api-questions does not have attribute version");
        }
        if (this.questions.size() == 0) {
            throw new BuildException("There are no <question> elements in the file!");
        }
        if (generateTemplate) {
            this.log("Input file " + this.questionsFile + " does not exists. Generating it filled with skeleton answers.");
            try {
                s = new TreeSet(this.questions.keySet());
                this.generateTemplateFile(Arch.removeRevisionTags(questionsVersion), (Set)s);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            return;
        }
        this.answers = Arch.readElements((Document)q, "answer");
        NodeList apiAnswers = q.getElementsByTagName("api-answers");
        if (apiAnswers.getLength() != 1) {
            throw new BuildException("No element api-answers");
        }
        String answersVersion = ((Element)apiAnswers.item(0)).getAttribute("question-version");
        if (answersVersion == null) {
            throw new BuildException("Element api-answers does not have attribute question-version");
        }
        if (!Arch.removeRevisionTags(answersVersion).equals(Arch.removeRevisionTags(questionsVersion))) {
            String msg = this.questionsFile.getAbsolutePath() + ": answers were created for questions version \"" + answersVersion + "\" but current version of questions is \"" + questionsVersion + "\"";
            if ("true".equals(this.getProject().getProperty("arch.warn"))) {
                this.log(msg, 1);
            } else {
                throw new BuildException(msg);
            }
        }
        s = new TreeSet(this.questions.keySet());
        ((AbstractSet)s).removeAll(this.answers.keySet());
        if (!((TreeSet)s).isEmpty()) {
            if ("true".equals(this.getProject().getProperty("arch.generate"))) {
                this.log("Missing answers to questions: " + s);
                this.log("Generating the answers to end of file " + this.questionsFile);
                try {
                    this.generateMissingQuestions((Set)s);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            } else {
                this.log(this.questionsFile.getAbsolutePath() + ": some questions have not been answered: " + s + "\n" + "Run with -Darch.generate=true to add missing questions into the end of question file", 1);
            }
        }
        try {
            StreamSource ss;
            String file = this.getProject().getProperty("arch.xsl");
            if (file != null) {
                this.log("Using " + file + " as the XSL stylesheet");
                try {
                    s = new StreamSource(new FileInputStream(file));
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            } else {
                ss = new StreamSource(this.getClass().getResourceAsStream("Arch.xsl"));
            }
            this.log("Transforming " + this.questionsFile + " into " + this.output);
            Transformer t = TransformerFactory.newInstance().newTransformer(ss);
            DOMSource s2 = new DOMSource((Node)q);
            StreamResult r = new StreamResult(this.output);
            if (this.stylesheet != null) {
                t.setParameter("arch.stylesheet", this.stylesheet);
            }
            if (this.overviewlink != null) {
                t.setParameter("arch.overviewlink", this.overviewlink);
            }
            if (this.footer != null) {
                t.setParameter("arch.footer", this.footer);
            }
            t.transform(s2, r);
        }
        catch (TransformerConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateMissingQuestions(Set missing) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(this.questionsFile.toString(), true));
        w.write("<!-- Copy this above the </api-answers> tag! -->\n\n");
        this.writeQuestions(w, missing);
        ((Writer)w).close();
    }

    private void writeQuestions(Writer w, Set missing) throws IOException {
        ElementToString convertor;
        Iterator it = missing.iterator();
        try {
            Class<?> c = Class.forName(this.getClass().getName() + "$XercesE2S");
            Constructor<?> cc = c.getDeclaredConstructor(new Class[0]);
            ((AccessibleObject)cc).setAccessible(true);
            convertor = (ElementToString)cc.newInstance(null);
            convertor.convertElement(null);
        }
        catch (Throwable ex) {
            this.log("Cannot initialize xerces to print out DOM elements: " + ex + ". Trying org.w3c.dom.Node.toString() which might work as well");
            convertor = new ToStringE2S();
        }
        boolean useXerces = true;
        while (it.hasNext()) {
            String s = (String)it.next();
            Element n = (Element)this.questions.get(s);
            w.write("\n\n<!--\n        ");
            w.write(convertor.convertElement(n));
            w.write("\n-->\n");
            w.write("<answer id=\"" + s + "\">\nNo answer\n</answer>\n\n");
        }
    }

    private static String findNbRoot(File f) {
        StringBuffer result = new StringBuffer();
        f = f.getParentFile();
        while (f != null) {
            File x = new File(f, "nbbuild" + File.separatorChar + "antsrc" + File.separatorChar + "org" + File.separatorChar + "netbeans" + File.separatorChar + "nbbuild" + File.separatorChar + "Arch.dtd");
            if (x.exists()) {
                return result.toString();
            }
            result.append("..");
            result.append(File.separatorChar);
            f = f.getParentFile();
        }
        return "${nbroot}/";
    }

    private void generateTemplateFile(String versionOfQuestions, Set missing) throws IOException {
        String nbRoot = Arch.findNbRoot(this.questionsFile);
        FileWriter w = new FileWriter(this.questionsFile);
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        w.write("<!DOCTYPE api-answers PUBLIC \"-//NetBeans//DTD Arch Answers//EN\" \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch.dtd\" [\n");
        w.write("  <!ENTITY api-questions SYSTEM \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch-api-questions.xml\">\n");
        w.write("]>\n");
        w.write("\n");
        w.write("<api-answers\n");
        w.write("  version=\"$Revision: 1.15 $\" date=\"$date$\"\n");
        w.write("  question-version=\"");
        w.write(versionOfQuestions);
        w.write("\"\n");
        w.write("  module=\"name of your module\"\n");
        w.write("  author=\"yourname@netbeans.org\"\n");
        w.write(">\n\n");
        w.write("  &api-questions;\n");
        this.writeQuestions(w, missing);
        w.write("</api-answers>\n");
        ((Writer)w).close();
    }

    private static String removeRevisionTags(String s) {
        if (s.startsWith("$Revision: ")) {
            s = s.substring("$Revision: ".length());
        }
        if (s.endsWith(" $")) {
            s = s.substring(0, s.length() - 2);
        }
        return s;
    }

    private static HashMap readElements(Document q, String name) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList list = q.getElementsByTagName(name);
        int i = 0;
        while (i < list.getLength()) {
            Node n = list.item(i).getAttributes().getNamedItem("id");
            if (n == null) {
                throw new BuildException("Question without id tag");
            }
            String id = n.getNodeValue();
            map.put(id, list.item(i));
            ++i;
        }
        return map;
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log(exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage(), 0);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (exception.getLocalizedMessage().startsWith("Using original entity definition for")) {
            return;
        }
        this.log(exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage(), 1);
    }

    private static interface ElementToString {
        public String convertElement(Element var1) throws BuildException;
    }

    private static final class XercesE2S
    implements ElementToString {
        public String convertElement(Element n) throws BuildException {
            XMLSerializer ser = new XMLSerializer();
            StringWriter wr = new StringWriter();
            ser.setOutputCharStream((Writer)wr);
            OutputFormat fmt = new OutputFormat();
            fmt.setIndenting(false);
            fmt.setOmitXMLDeclaration(true);
            fmt.setOmitDocumentType(true);
            fmt.setPreserveSpace(true);
            fmt.setOmitComments(true);
            ser.setOutputFormat(fmt);
            try {
                if (n != null) {
                    ser.serialize(n);
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            return wr.toString();
        }

        XercesE2S() {
        }
    }

    private static final class ToStringE2S
    implements ElementToString {
        public String convertElement(Element e) throws BuildException {
            String str = e.toString();
            if (str == null || str.length() == 0) {
                throw new BuildException("DOM model does not support Element.toString conversion");
            }
            return str;
        }

        ToStringE2S() {
        }
    }
}

