/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.StreamCharacterIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Mapper;

public class CheckLinks
extends MatchingTask {
    static RE hrefOrAnchor;
    private File basedir;
    private boolean checkexternal = true;
    private List mappers = new LinkedList();

    public void setCheckexternal(boolean ce) {
        this.checkexternal = ce;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public Mapper createMapper() {
        Mapper m = new Mapper(this.getProject());
        this.mappers.add(m);
        return m;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        if (this.basedir == null) {
            throw new BuildException("Must specify the basedir attribute");
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.basedir);
        scanner.scan();
        String message = "Scanning for broken links in " + this.basedir + " ...";
        if (!this.checkexternal) {
            message = message + " (external URLs will be skipped)";
        }
        this.log(message);
        String[] files = scanner.getIncludedFiles();
        HashSet okurls = new HashSet(1000);
        HashSet badurls = new HashSet(100);
        HashSet cleanurls = new HashSet(100);
        int i = 0;
        while (i < files.length) {
            File file = new File(this.basedir, files[i]);
            try {
                URL uRL = file.toURL();
            }
            catch (MalformedURLException mfue) {
                throw new BuildException((Throwable)mfue, ((Task)this).location);
            }
            this.log("Scanning " + file, 3);
            try {
                void fileurl;
                CheckLinks.scan((Task)this, file.getAbsolutePath(), (URL)fileurl, okurls, badurls, cleanurls, this.checkexternal, 1, this.mappers);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not scan " + file + ": " + ioe, (Throwable)ioe, ((Task)this).location);
            }
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void scan(Task task, String referrer, URL u, Set okurls, Set badurls, Set cleanurls, boolean checkexternal, int recurse, List mappers) throws IOException {
        Object it;
        HashSet<URL> others;
        block18: {
            block19: {
                void rd;
                block16: {
                    block17: {
                        String mimeType;
                        if (okurls.contains(u) && recurse == 0) {
                            return;
                        }
                        String b = u.toString();
                        int i = b.lastIndexOf(35);
                        if (i != -1) {
                            b = b.substring(0, i);
                        }
                        URL base = new URL(b);
                        String frag = u.getRef();
                        if (badurls.contains(u) || badurls.contains(base)) {
                            task.log(CheckLinks.normalize(referrer, mappers) + ": broken link (already reported): " + u, 1);
                            return;
                        }
                        if (!checkexternal && !"file".equals(u.getProtocol())) {
                            task.log("Skipping external link: " + base, 3);
                            cleanurls.add(base);
                            okurls.add(base);
                            okurls.add(u);
                            return;
                        }
                        task.log("Checking " + u + " (recursion level " + recurse + ")", 3);
                        try {
                            URLConnection conn = base.openConnection();
                            conn.connect();
                            mimeType = conn.getContentType();
                            InputStream inputStream = conn.getInputStream();
                        }
                        catch (IOException ioe) {
                            task.log(CheckLinks.normalize(referrer, mappers) + ": broken link: " + base, 1);
                            badurls.add(base);
                            badurls.add(u);
                            return;
                        }
                        okurls.add(base);
                        others = null;
                        if (recurse > 0 && cleanurls.add(base)) {
                            others = new HashSet<URL>(100);
                        }
                        try {
                            if (recurse == 0 && frag == null) {
                                Object var17_17 = null;
                                break block16;
                            }
                            if ("text/html".equals(mimeType)) {
                                task.log("Parsing " + base, 3);
                                it = new StreamCharacterIterator((InputStream)rd);
                                int idx = 0;
                                HashSet<String> names = new HashSet<String>(100);
                                while (hrefOrAnchor.match((CharacterIterator)it, idx)) {
                                    idx = hrefOrAnchor.getParenEnd(0);
                                    String type = hrefOrAnchor.getParen(3);
                                    if (type.equalsIgnoreCase("name")) {
                                        String name = CheckLinks.unescape(hrefOrAnchor.getParen(4));
                                        if (names.add(name)) {
                                            okurls.add(new URL(base, "#" + name));
                                            continue;
                                        }
                                        if (recurse != 1) continue;
                                        task.log(CheckLinks.normalize(referrer, mappers) + ": duplicate anchor name: " + name, 1);
                                        continue;
                                    }
                                    if (others == null) continue;
                                    String otherbase = CheckLinks.unescape(hrefOrAnchor.getParen(4));
                                    String otheranchor = CheckLinks.unescape(hrefOrAnchor.getParen(5));
                                    if (otherbase.startsWith("mailto:")) continue;
                                    URL o = new URL(base, otheranchor == null ? otherbase : otherbase + otheranchor);
                                    others.add(o);
                                }
                                break block17;
                            }
                            task.log("Not checking contents of " + base, 3);
                        }
                        catch (Throwable throwable) {
                            Object var17_19 = null;
                            rd.close();
                            throw throwable;
                        }
                    }
                    Object var17_18 = null;
                    rd.close();
                    if (okurls.contains(u)) break block18;
                    break block19;
                }
                rd.close();
                return;
            }
            task.log(CheckLinks.normalize(referrer, mappers) + ": broken link: " + u, 1);
        }
        if (others != null) {
            it = others.iterator();
            while (it.hasNext()) {
                URL other = (URL)it.next();
                CheckLinks.scan(task, u.getPath(), other, okurls, badurls, cleanurls, checkexternal, recurse == 1 ? 0 : 2, mappers);
            }
        }
    }

    private static String normalize(String path, List mappers) throws IOException {
        try {
            Iterator it = mappers.iterator();
            while (it.hasNext()) {
                Mapper m = (Mapper)it.next();
                String[] nue = m.getImplementation().mapFileName(path);
                if (nue == null) continue;
                int i = 0;
                while (i < nue.length) {
                    if (new File(nue[i]).isFile()) {
                        return nue[i];
                    }
                    ++i;
                }
            }
            return path;
        }
        catch (BuildException e) {
            throw new IOException(e.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String unescape(String text) {
        int search;
        if (text == null) {
            return null;
        }
        int pos = 0;
        while ((search = text.indexOf(38, pos)) != -1) {
            void repl;
            String string;
            void var2_2;
            int semi = text.indexOf(59, (int)(var2_2 + true));
            if (semi == -1) {
                return text;
            }
            String entity = text.substring((int)(var2_2 + true), semi);
            if (entity.equals("amp")) {
                string = "&";
            } else if (entity.equals("quot")) {
                string = "\"";
            } else if (entity.equals("lt")) {
                string = "<";
            } else if (entity.equals("gt")) {
                string = ">";
            } else if (entity.equals("apos")) {
                string = "'";
            } else {
                pos = semi + 1;
                continue;
            }
            text = text.substring(0, (int)var2_2) + (String)repl + text.substring(semi + 1);
            pos = var2_2 + repl.length();
        }
        return text;
    }

    static {
        try {
            hrefOrAnchor = new RE("<(a|img)(\\s+shape=\"rect\")?\\s+(href|name|src)=\"([^\"#]*)(#[^\"]+)?\"(\\s+shape=\"rect\")?>");
        }
        catch (RESyntaxException rese) {
            throw new Error(rese.toString());
        }
        hrefOrAnchor.setMatchFlags(1);
    }
}

