/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.regexp.CharacterIterator;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.apache.regexp.ReaderCharacterIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.netbeans.nbbuild.CvsFileSet;

public class FindBadConstructions
extends Task {
    private List filesets = new LinkedList();
    private List bad = new LinkedList();

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void addCvsFileset(CvsFileSet fs) {
        this.filesets.add(fs);
    }

    public Construction createConstruction() {
        FindBadConstructions findBadConstructions = this;
        if (findBadConstructions == null) {
            throw null;
        }
        Construction c = findBadConstructions.new Construction();
        this.bad.add(c);
        return c;
    }

    public void execute() throws BuildException {
        if (this.filesets.isEmpty()) {
            throw new BuildException("Must give at least one fileset", this.location);
        }
        if (this.bad.isEmpty()) {
            throw new BuildException("Must give at least one construction", this.location);
        }
        Iterator it = this.filesets.iterator();
        while (it.hasNext()) {
            FileSet fs = (FileSet)it.next();
            DirectoryScanner scanner = fs.getDirectoryScanner(((ProjectComponent)this).project);
            File dir = scanner.getBasedir();
            String[] files = scanner.getIncludedFiles();
            this.log("Scanning " + files.length + " files in " + dir);
            int i = 0;
            while (i < files.length) {
                File f = new File(dir, files[i]);
                try {
                    Iterator it2 = this.bad.iterator();
                    while (it2.hasNext()) {
                        Construction c = (Construction)it2.next();
                        if (c.regexp == null) {
                            throw new BuildException("Must specify regexp on a construction", this.location);
                        }
                        LineIndexedReader lir = new LineIndexedReader(new FileReader(f));
                        try {
                            ReaderCharacterIterator cit = new ReaderCharacterIterator((Reader)lir);
                            int idx = 0;
                            while (c.regexp.match((CharacterIterator)cit, idx)) {
                                idx = c.regexp.getParenEnd(0);
                                StringBuffer message = new StringBuffer(1000);
                                message.append(f.getAbsolutePath());
                                message.append(':');
                                message.append(lir.findLine(c.regexp.getParenStart(Math.max(c.show, 0))) + 1);
                                message.append(": ");
                                if (c.message != null) {
                                    message.append(c.message);
                                }
                                if (c.show != -1) {
                                    if (c.message != null) {
                                        message.append(": ");
                                    }
                                    message.append(c.regexp.getParen(c.show));
                                }
                                if (c.show == -1 && c.message == null) {
                                    message.append("bad construction found");
                                }
                                this.log(message.toString(), 1);
                            }
                        }
                        finally {
                            Object var12_12 = null;
                            lir.close();
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("Error reading " + f, (Throwable)ioe, this.location);
                }
                ++i;
            }
        }
    }

    public class Construction {
        private boolean caseInsens = false;
        RE regexp;
        String message = null;
        int show = -1;

        public void setRegexp(String r) throws BuildException {
            try {
                this.regexp = new RE(r);
            }
            catch (RESyntaxException rese) {
                throw new BuildException((Throwable)rese, FindBadConstructions.this.location);
            }
            if (this.caseInsens) {
                this.regexp.setMatchFlags(1);
            }
        }

        public void setCaseInsensitive(boolean ci) {
            this.caseInsens = ci;
            if (ci && this.regexp != null) {
                this.regexp.setMatchFlags(1);
            }
        }

        public void setMessage(String m) {
            this.message = m;
        }

        public void setShowMatch(int s) {
            this.show = s;
        }
    }

    private static final class LineIndexedReader
    extends Reader {
        private final BufferedReader buf;
        private final List lines = new ArrayList(1000);
        private char[] pending = null;
        private int pendingIdx = 0;

        public void close() throws IOException {
            this.buf.close();
        }

        public int read(char[] cs, int off, int len) throws IOException {
            int off2 = off;
            while (len > 0) {
                int avail;
                if (this.pending == null) {
                    String l = this.buf.readLine();
                    if (l == null) break;
                    int sz = l.length();
                    this.pending = new char[sz + 1];
                    this.pendingIdx = 0;
                    l.getChars(0, sz, this.pending, 0);
                    this.pending[sz] = 10;
                    this.lines.add(new Integer((Integer)this.lines.get(this.lines.size() - 1) + sz + 1));
                }
                if (len < (avail = this.pending.length - this.pendingIdx)) {
                    System.arraycopy(this.pending, this.pendingIdx, cs, off2, len);
                    this.pendingIdx += len;
                    off2 += len;
                    len = 0;
                    continue;
                }
                System.arraycopy(this.pending, this.pendingIdx, cs, off2, avail);
                this.pending = null;
                off2 += avail;
                len -= avail;
            }
            return off == off2 ? -1 : off2 - off;
        }

        public int findLine(int idx) {
            int line = -1;
            Iterator it = this.lines.iterator();
            while (idx >= (Integer)it.next()) {
                ++line;
            }
            return line;
        }

        public LineIndexedReader(Reader r) {
            this.buf = new BufferedReader(r);
            this.lines.add(new Integer(0));
        }
    }
}

