/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.sip.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class PropertiesImporter
implements LifecycleListener {
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            File propFile = new File(System.getProperty("catalina.home") + "/conf/system.properties");
            Properties sysProps = new Properties(System.getProperties());
            try {
                sysProps.load(new FileInputStream(propFile));
                System.setProperties(sysProps);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.loadPreferenceProperties();
        }
    }

    private void loadPreferenceProperties() {
        String preferenceDirectory = "preferences";
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome != null) {
            preferenceDirectory = catalinaHome + "/conf/preferences";
        }
        try {
            File preferenceDir = new File(preferenceDirectory);
            File[] prefFiles = preferenceDir.listFiles();
            for (int i = 0; i < prefFiles.length; ++i) {
                if (prefFiles[i].isDirectory()) continue;
                String currentFile = prefFiles[i].getName();
                System.out.println("Processing Preferences from " + currentFile);
                FileInputStream fis = new FileInputStream(prefFiles[i]);
                Preferences.importPreferences(fis);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidPreferencesFormatException e) {
            e.printStackTrace();
        }
    }
}

