/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.RuntimeConfig;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class ConfigManager
extends RuntimeConfig {
    private static Logger logger = Logger.getLogger("SipContainer");
    private static Preferences userPreferences = Preferences.userRoot().node("com/ericsson/eas/tm");
    private static Preferences timerPreferences = Preferences.userRoot().node("com/ericsson/eas/tm/timer");
    private static Preferences systemPreferences = Preferences.systemRoot().node("com/ericsson/eas/tm");
    private int m_HostNumber = -1;
    private String m_LanAddress = null;
    private String m_EnumTopDomain = null;
    private String m_DnsServerList = null;
    private int m_ProxyPoolSize = -1;
    private int m_ProxyRetries = -1;
    private int m_ProxySocketTimeout = -1;
    private int m_ProxyConnectionTimeout = -1;
    private boolean m_OverloadRegulation = false;
    private int m_SampleRate = -1;
    private int m_NumberOfSamples = -1;
    private int m_HttpThreshold = -1;
    private int m_IrThreshold = -1;
    private int m_SrThreshold = -1;
    private int m_MmThreshold = -1;
    private boolean m_CpuAlarmEnabled = true;
    private int m_CpuAlarmThreshold = -1;
    private int m_SipLinkTimeout = -1;
    private int m_SipLinkTimeoutRetries = -1;
    private int m_SipLinkMaxQueueLen = -1;
    private int m_SipLinkAliveTimeout = -1;
    private boolean m_Eas503DisabledFetched = false;
    private boolean m_Eas503Disabled = true;
    private boolean m_ErrorResponseEnabledFetched = false;
    private boolean m_ErrorResponseEnabled = true;

    private String getStringParameter(String parameterName, boolean isSystemProperty, String defaultValue) {
        String value = isSystemProperty ? systemPreferences.get(parameterName, "") : userPreferences.get(parameterName, "");
        if (value.equalsIgnoreCase("") && defaultValue != null) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using default value: '" + defaultValue + "'");
            return defaultValue;
        }
        if (value.equalsIgnoreCase("") && defaultValue == null) {
            logger.log(Level.WARNING, "parameter <" + parameterName + ">: no value specified and no default available, using empty string.");
            return "";
        }
        if (defaultValue != null && value.equals(defaultValue)) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: '" + value + "' (which is also the default value)");
            return value;
        }
        if (defaultValue == null) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: '" + value + "'");
            return value;
        }
        logger.log(Level.INFO, "parameter <" + parameterName + ">: using non-default value: '" + value + "'");
        return value;
    }

    private int getIntParameter(String parameterName, boolean isSystemProperty, int defaultValue) {
        if (isSystemProperty) {
            return this.getIntParameter(systemPreferences, parameterName, defaultValue);
        }
        return this.getIntParameter(userPreferences, parameterName, defaultValue);
    }

    private int getIntParameter(Preferences prefnode, String parameterName, int defaultValue) {
        int value = prefnode.getInt(parameterName, -1);
        if (value == -1 && defaultValue > -1) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using default value: " + defaultValue);
            return defaultValue;
        }
        if (value == -1 && defaultValue == -1) {
            logger.log(Level.WARNING, "parameter <" + parameterName + ">: no value specified and no default available. Using " + -1);
            return -1;
        }
        if (defaultValue != -1 && value == defaultValue) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: " + value + " (which is also the default value)");
            return value;
        }
        if (defaultValue == -1) {
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: " + value);
            return value;
        }
        logger.log(Level.INFO, "parameter <" + parameterName + ">: using non-default value: " + value);
        return value;
    }

    private boolean getBooleanParameter(String parameterName, boolean isSystemProperty, String defaultString) {
        boolean result;
        boolean defaultValue = Boolean.valueOf(defaultString);
        String value = isSystemProperty ? systemPreferences.get(parameterName, "") : userPreferences.get(parameterName, "");
        if (value.equalsIgnoreCase("true")) {
            result = true;
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: " + result + (result != defaultValue ? "" : " (same as default)"));
        } else if (value.equalsIgnoreCase("false")) {
            result = false;
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using specified value: " + result + (result != defaultValue ? "" : " (same as default)"));
        } else if (value.equals("")) {
            result = defaultValue;
            logger.log(Level.INFO, "parameter <" + parameterName + ">: using default value: " + defaultValue);
        } else {
            logger.log(Level.WARNING, "parameter <" + parameterName + ">: illegal value specified: " + value + ", assumed to mean: false, using: false");
            result = false;
        }
        return result;
    }

    public boolean getDefaultTCPTransport() {
        return this.getBooleanParameter("defaultTCPTransport", false, String.valueOf(false));
    }

    public int getThreadPoolSize() {
        return this.getIntParameter("ThreadPoolSize", false, 10);
    }

    public String getJMXDefaultHost() {
        return this.getLanAddress();
    }

    public int getJMXDefaultPort() {
        return this.getIntParameter("JmxDefaultPort", false, 1099);
    }

    public boolean getErrorResponseEnabled() {
        if (this.m_ErrorResponseEnabledFetched) {
            return this.m_ErrorResponseEnabled;
        }
        this.m_ErrorResponseEnabled = this.getBooleanParameter("ErrorResponseEnabled", false, String.valueOf(false));
        this.m_ErrorResponseEnabledFetched = true;
        return this.m_ErrorResponseEnabled;
    }

    public int getHostNumber() {
        if (this.m_HostNumber != -1) {
            return this.m_HostNumber;
        }
        String key = "HostNumber";
        String hn = System.getProperty(key);
        this.m_HostNumber = hn == null || hn.trim().length() == 0 ? 0 : Integer.parseInt(hn);
        logger.log(Level.INFO, "parameter <HostNumber>: using value " + this.m_HostNumber);
        return this.m_HostNumber;
    }

    public String getLanAddress() {
        if (this.m_LanAddress != null) {
            return this.m_LanAddress;
        }
        String lanAddress = "";
        String preferedPrefix = "172.";
        String avoidedPrefix = "127.";
        String avoidedInterfacenamePrefix = "i4dd";
        String me = "getLanAddress(): ";
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, me + "try to find a configured IP address of a physical network interface");
        }
        int score = 0;
        Enumeration<NetworkInterface> nifs = null;
        try {
            nifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            logger.log(Level.SEVERE, me + "SocketException when trying to get our network interfaces", se);
        }
        if (nifs != null) {
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                String ifName = nif.getName();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, me + "found interface: " + ifName);
                }
                int addrCount = 0;
                Enumeration<InetAddress> addrs = nif.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    int newscore;
                    String addrString;
                    InetAddress addr = addrs.nextElement();
                    ++addrCount;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, me + "found address " + addr + " for interface " + ifName);
                    }
                    if ((addrString = addr.getHostAddress()).startsWith(preferedPrefix)) {
                        newscore = 40;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (addrString.startsWith(avoidedPrefix)) {
                        newscore = 10;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (ifName.startsWith(avoidedInterfacenamePrefix)) {
                        newscore = 20;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (addrString.indexOf(":") >= 0) {
                        newscore = 25;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    newscore = 30;
                    if (score < newscore) {
                        lanAddress = addrString;
                        score = newscore;
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                        continue;
                    }
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                }
                if (addrCount < 1) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.log(Level.INFO, me + "found no configured IP addresses for interface " + ifName);
                    continue;
                }
                if (addrCount <= 1 || !logger.isLoggable(Level.INFO)) continue;
                logger.log(Level.INFO, me + "found " + addrCount + " configured IP addresses for interface " + ifName);
            }
        }
        if (lanAddress == null) {
            logger.log(Level.SEVERE, me + "no interface with a configured IP address found, using 0.0.0.0");
            lanAddress = "0.0.0.0";
        } else if (score < 30) {
            logger.log(Level.WARNING, me + "only found unsuitable IP addresses; using " + lanAddress + " in lack of better");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "parameter <LanAddress>: using " + (score > 30 ? "preferred " : "") + "value '" + lanAddress + "'");
        }
        this.m_LanAddress = lanAddress;
        return lanAddress;
    }

    public boolean getApplicationDispatcherLoopInternal() {
        return this.getBooleanParameter("ApplicationDispatcherLoopInternal", false, String.valueOf(true));
    }

    public String getEnumTopDomain() {
        if (this.m_EnumTopDomain != null) {
            return this.m_EnumTopDomain;
        }
        String parmName = "EnumTopDomain";
        String defaultValue = String.valueOf("e164.arpa");
        this.m_EnumTopDomain = this.getStringParameter(parmName, false, defaultValue);
        return this.m_EnumTopDomain;
    }

    public int getDnsCacheSize() {
        return this.getIntParameter("DnsCacheSize", false, 20000);
    }

    public String getDnsServerList() {
        if (this.m_DnsServerList != null) {
            return this.m_DnsServerList;
        }
        this.m_DnsServerList = this.getStringParameter("DnsServerList", false, null);
        return this.m_DnsServerList;
    }

    public int getProxyPoolSize() {
        if (this.m_ProxyPoolSize != -1) {
            return this.m_ProxyPoolSize;
        }
        this.m_ProxyPoolSize = this.getIntParameter("ProxyPoolSize", false, 2);
        return this.m_ProxyPoolSize;
    }

    public int getProxyRetries() {
        if (this.m_ProxyRetries != -1) {
            return this.m_ProxyRetries;
        }
        this.m_ProxyRetries = this.getIntParameter("ProxyRetries", false, 2);
        return this.m_ProxyRetries;
    }

    public int getProxySocketTimeout() {
        if (this.m_ProxySocketTimeout != -1) {
            return this.m_ProxySocketTimeout;
        }
        this.m_ProxySocketTimeout = this.getIntParameter("ProxySocketTimeout", false, 120000);
        return this.m_ProxySocketTimeout;
    }

    public int getProxyConnectionTimeout() {
        if (this.m_ProxyConnectionTimeout != -1) {
            return this.m_ProxyConnectionTimeout;
        }
        this.m_ProxyConnectionTimeout = this.getIntParameter("ProxyConnectionTimeout", false, 0);
        return this.m_ProxyConnectionTimeout;
    }

    public int getTimerT1() {
        return this.getIntParameter(timerPreferences, "timerT1", 500);
    }

    public int getTimerT2() {
        return this.getIntParameter(timerPreferences, "timerT2", 4000);
    }

    public int getTimerT4() {
        return this.getIntParameter(timerPreferences, "timerT4", 5000);
    }

    public boolean getOverloadRegulation() {
        return this.getBooleanParameter("OverloadRegulation", false, String.valueOf(false));
    }

    public int getSampleRate() {
        if (this.m_SampleRate != -1) {
            return this.m_SampleRate;
        }
        this.m_SampleRate = this.getIntParameter("SampleRate", false, 1);
        return this.m_SampleRate;
    }

    public int getNumberOfSamples() {
        if (this.m_NumberOfSamples != -1) {
            return this.m_NumberOfSamples;
        }
        this.m_NumberOfSamples = this.getIntParameter("NumberOfSamples", false, 2);
        return this.m_NumberOfSamples;
    }

    public int getHttpThreshold() {
        if (this.m_HttpThreshold != -1) {
            return this.m_HttpThreshold;
        }
        this.m_HttpThreshold = this.getIntParameter("HttpThreshold", false, 70);
        return this.m_HttpThreshold;
    }

    public int getIrThreshold() {
        if (this.m_IrThreshold != -1) {
            return this.m_IrThreshold;
        }
        this.m_IrThreshold = this.getIntParameter("IrThreshold", false, 70);
        return this.m_IrThreshold;
    }

    public int getSrThreshold() {
        if (this.m_SrThreshold != -1) {
            return this.m_SrThreshold;
        }
        this.m_SrThreshold = this.getIntParameter("SrThreshold", false, 80);
        return this.m_SrThreshold;
    }

    public int getMmThreshold() {
        if (this.m_MmThreshold != -1) {
            return this.m_MmThreshold;
        }
        this.m_MmThreshold = this.getIntParameter("MmThreshold", false, 99);
        return this.m_MmThreshold;
    }

    public boolean getCpuAlarmEnabled() {
        return this.getBooleanParameter("CpuAlarmEnabled", false, String.valueOf(true));
    }

    public int getCpuAlaramThreshold() {
        if (this.m_CpuAlarmThreshold != -1) {
            return this.m_CpuAlarmThreshold;
        }
        this.m_CpuAlarmThreshold = this.getIntParameter("CpuAlarmThreshold", false, 70);
        return this.m_CpuAlarmThreshold;
    }

    public int getSipLinkMaxQueueLength() {
        if (this.m_SipLinkMaxQueueLen == -1) {
            this.m_SipLinkMaxQueueLen = this.getIntParameter("SipLinkMaxQueueLength", false, 50);
        }
        return this.m_SipLinkMaxQueueLen;
    }

    public int getSipLinkAliveTimeout() {
        if (this.m_SipLinkAliveTimeout == -1) {
            this.m_SipLinkAliveTimeout = this.getIntParameter("SipLinkAliveTimeout", false, 120);
        }
        return this.m_SipLinkAliveTimeout;
    }

    public int getSipLinkTimeout() {
        if (this.m_SipLinkTimeout == -1) {
            this.m_SipLinkTimeout = this.getIntParameter("SipLinkTimeout", false, 10);
        }
        return this.m_SipLinkTimeout;
    }

    public int getSipLinkTimeoutRetries() {
        if (this.m_SipLinkTimeoutRetries == -1) {
            this.m_SipLinkTimeoutRetries = this.getIntParameter("SipLinkTimeoutRetries", false, 25);
        }
        return this.m_SipLinkTimeoutRetries;
    }

    public boolean getEas503Disabled() {
        if (this.m_Eas503DisabledFetched) {
            return this.m_Eas503Disabled;
        }
        this.m_Eas503Disabled = this.getBooleanParameter("Eas503Disabled", false, String.valueOf(false));
        this.m_Eas503DisabledFetched = true;
        return this.m_Eas503Disabled;
    }

    public void uninitialize() {
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "Uninitialize parameters that can be changed in runtime in order to read again.");
        }
        this.m_OverloadRegulation = false;
        this.m_SampleRate = -1;
        this.m_NumberOfSamples = -1;
        this.m_HttpThreshold = -1;
        this.m_IrThreshold = -1;
        this.m_SrThreshold = -1;
        this.m_MmThreshold = -1;
    }
}

