/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.config.ConvergedContextRuleSet;
import com.ericsson.ssa.config.SARDirContext;
import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.config.SipFactoryMap;
import com.ericsson.ssa.container.auth.DescriptorProcessor;
import com.ericsson.ssa.container.sim.ApplicationDispatcher;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.dd.ConvergedDescriptor;
import com.ericsson.ssa.dd.EjbLocalReference;
import com.ericsson.ssa.dd.EjbReference;
import com.ericsson.ssa.dd.EnvironmentEntry;
import com.ericsson.ssa.dd.Parameter;
import com.ericsson.ssa.dd.ResourceEnvironmentReference;
import com.ericsson.ssa.dd.ResourceReference;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.dd.SipParser;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.dns.DnsResolver;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.web.WebModuleContextConfig;
import com.sun.org.apache.commons.digester.Digester;
import com.sun.org.apache.commons.digester.RuleSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.directory.DirContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.sip.SipFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ContextEjb;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextLocalEjb;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

public final class ConvergedContextConfig
extends WebModuleContextConfig {
    private static Logger logger = Logger.getLogger("SipContainer");
    private static final String APPLICATION_SIP_XML = "/WEB-INF/sip.xml";
    protected NamingManager namingManager;
    Switch theSwitch = Switch.getSwitch();
    protected ConvergedContext convergedContext;

    public ConvergedContextConfig() {
        this.namingManager = this.theSwitch.getNamingManager();
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        ConvergedContextRuleSet contextRuleSet = new ConvergedContextRuleSet("", false);
        digester.addRuleSet((RuleSet)contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet((RuleSet)namingRuleSet);
        return digester;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.convergedContext = (ConvergedContext)event.getLifecycle();
        }
        catch (ClassCastException e) {
            logger.log(Level.FINE, "Lifecycle event data object {0} is not a ConvergedContext", e);
            return;
        }
        super.lifecycleEvent(event);
    }

    protected void beforeStart() {
        this.setContextResources();
    }

    protected synchronized void start() {
        ServletContext servletContext;
        InputStream sipXml;
        super.start();
        this.ok = true;
        Container container = this.context.getParent();
        if (!this.context.getOverride() && container instanceof Host) {
            container = container.getParent();
        }
        if ((sipXml = (servletContext = this.context.getServletContext()).getResourceAsStream(APPLICATION_SIP_XML)) != null) {
            try {
                this.getSipApplication();
                this.initServletContextAttributes();
                this.copyContextProperties();
                PolicyBuilder builder = new PolicyBuilder();
                String pContextId = this.convergedContext.getSipApplication().getAppName();
                if (pContextId == null) {
                    pContextId = "noname";
                }
                pContextId = pContextId + "/" + pContextId;
                builder.createRoleMapper(super.getDescriptor(), pContextId);
                new DescriptorProcessor().process(this.convergedContext.getSipApplication());
                this.initializeServletDispatcher();
            }
            catch (Exception e) {
                this.ok = false;
            }
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            logger.log(Level.WARNING, "contextConfig.unavailable");
            this.context.setAvailable(false);
        }
    }

    protected synchronized void stop() {
        super.stop();
        if (this.convergedContext.getSipApplicationListeners() != null) {
            ServletContextEvent servletContextEvent = new ServletContextEvent(this.context.getServletContext());
            for (ServletContextListener listener : this.convergedContext.getSipApplicationListeners().getServletContextListener()) {
                listener.contextDestroyed(servletContextEvent);
            }
        }
        if (this.convergedContext.getDispatcher() != null) {
            this.convergedContext.getDispatcher().unInitialize();
        }
        if (this.convergedContext.getSipApplicationListeners() != null) {
            this.convergedContext.getSipApplicationListeners().clean();
        }
        this.convergedContext.setSipApplication(null);
        this.convergedContext.setDispatcher(null);
        this.convergedContext.setSipFactory(null);
        try {
            this.namingManager.unpublishObject("sip" + this.context.getName());
            SipFactory sf = SipFactoryMap.getInstance().removeSipFactory(this.context.getName());
            if (sf != null) {
                logger.log(Level.INFO, "SipFactory object corresponding to" + this.context.getName() + "removed");
            }
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    protected synchronized void destroy() {
        String workDir = ((StandardContext)this.context).getWorkPath();
        if (workDir != null) {
            ExpandWar.delete((File)new File(workDir));
        }
    }

    private void parseSipDD(InputStream sipXml) throws Exception {
        try {
            this.convergedContext.setSipApplication(SipParser.parse(sipXml));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (sipXml != null) {
                sipXml.close();
            }
        }
    }

    private void initServletContextAttributes() {
        ServletContext servletContext = this.context.getServletContext();
        ArrayList<String> supportedExt = new ArrayList<String>();
        supportedExt.add("100rel");
        servletContext.setAttribute("javax.servlet.sip.supported", supportedExt);
        SipApplication sipApplication = this.convergedContext.getSipApplication();
        SipFactoryImpl.getInstance().setServiceHandler(ApplicationDispatcher.getInstance());
        SipApplicationListeners sipApplicationListeners = new SipApplicationListeners(sipApplication.getListeners(), this.context.getLoader().getClassLoader());
        this.convergedContext.setSipApplicationListeners(sipApplicationListeners);
        SipFactoryFacade sipFactory = new SipFactoryFacade(this.convergedContext, SipFactoryImpl.getInstance(), sipApplicationListeners, sipApplication);
        this.convergedContext.setSipFactory(sipFactory);
        servletContext.setAttribute("javax.servlet.sip.SipFactory", (Object)sipFactory);
        try {
            String sipFactoryMappedName = "sip" + this.context.getName();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "sipFactoryMappedName = " + sipFactoryMappedName);
            }
            Reference sipFactoryRef = new Reference("javax.servlet.sip.SipFactory", new StringRefAddr("url", sipFactoryMappedName), "org.jvnet.glassfish.comms.deployment.backend.SipFactoryObjectFactory", null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "SipFactoryRef = " + sipFactoryRef);
            }
            this.namingManager.publishObject(sipFactoryMappedName, (Object)sipFactoryRef, false);
            SipFactoryMap.getInstance().addSipFactory(sipFactoryMappedName, sipFactory);
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
        servletContext.setAttribute("javax.servlet.sip.TimerService", (Object)TimerServiceImpl.getInstance());
        servletContext.setAttribute("TelUrlResolver", (Object)DnsResolver.getInstance());
        ServletContextEvent servletContextEvent = new ServletContextEvent(servletContext);
        for (ServletContextListener listener : sipApplicationListeners.getServletContextListener()) {
            listener.contextInitialized(servletContextEvent);
        }
    }

    private void initializeServletDispatcher() {
        ServletDispatcher dispatcher = new ServletDispatcher(this.convergedContext.getSipSessionManager());
        dispatcher.setSipApplicationModel(this.convergedContext.getSipApplication());
        this.context.getPipeline().addValve((Valve)dispatcher);
        dispatcher.setSipFactory(this.convergedContext.getSipFactory());
        dispatcher.initialize();
        this.convergedContext.setDispatcher(dispatcher);
    }

    protected void fixDocBase() throws IOException {
        File file;
        File canonicalAppBase;
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs() && ((StandardContext)this.context).getUnpackWAR();
        }
        canonicalAppBase = (canonicalAppBase = new File(appBase)).isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            docBase = path.equals("") ? "ROOT" : (path.startsWith("/") ? path.substring(1) : path);
        }
        docBase = !(file = new File(docBase)).isAbsolute() ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        if ((docBase.toLowerCase().endsWith(".sar") || docBase.toLowerCase().endsWith(".war")) && !file.isDirectory() && unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURL() + "!/");
            String contextPath = this.context.getPath();
            if (contextPath.equals("")) {
                contextPath = "ROOT";
            }
            docBase = ExpandWar.expand((Host)host, (URL)war, (String)contextPath);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                String[] extensions;
                for (String extension : extensions = new String[]{".sar", ".war"}) {
                    File archiveFile = new File(docBase + extension);
                    if (!archiveFile.exists()) continue;
                    if (unpackWARs) {
                        URL war = new URL("jar:" + archiveFile.toURL() + "!/");
                        docBase = ExpandWar.expand((Host)host, (URL)war, (String)this.context.getPath());
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                        break;
                    }
                    docBase = archiveFile.getCanonicalPath();
                    break;
                }
            }
        }
        if (docBase.startsWith(canonicalAppBase.getPath())) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }

    private void copyContextProperties() {
        SipApplication sipApplication = this.convergedContext.getSipApplication();
        this.context.setDisplayName(sipApplication.getDisplayName());
        this.context.setDistributable(sipApplication.isDistributable());
        this.copyContextParameters();
        this.copyResourceEnvRefs();
        this.copyResourceRefs();
        this.copySecurityRoles();
        this.copyEnvironmentEntries();
        this.copyEjbReferences();
        this.copyEjbLocalReferences();
    }

    private void copyEjbLocalReferences() {
        Collection<EjbLocalReference> references = this.convergedContext.getSipApplication().getEjbLocalReferences();
        if (references != null) {
            for (EjbLocalReference ref : references) {
                ContextLocalEjb ejb = new ContextLocalEjb();
                ejb.setDescription(ref.getDescription());
                ejb.setHome(ref.getLocalHome());
                ejb.setLink(ref.getEjbLink());
                ejb.setLocal(ref.getLocal());
                ejb.setName(ref.getName());
                ejb.setType(ref.getType());
            }
        }
    }

    private void copyEjbReferences() {
        Collection<EjbReference> references = this.convergedContext.getSipApplication().getEjbReferences();
        if (references != null) {
            for (EjbReference ref : references) {
                ContextEjb ejb = new ContextEjb();
                ejb.setDescription(ref.getDescription());
                ejb.setHome(ref.getHome());
                ejb.setLink(ref.getEjbLink());
                ejb.setName(ref.getName());
                ejb.setRemote(ref.getRemote());
                ejb.setType(ref.getType());
            }
        }
    }

    private void copyEnvironmentEntries() {
        Collection<EnvironmentEntry> entries = this.convergedContext.getSipApplication().getEnvironmentEntries();
        if (entries != null) {
            for (EnvironmentEntry entry : entries) {
                ContextEnvironment env = new ContextEnvironment();
                env.setDescription(entry.getDescription());
                env.setName(entry.getName());
                env.setType(entry.getType());
                env.setValue(entry.getValue());
            }
        }
    }

    private void copySecurityRoles() {
        Map<String, SecurityRole> roles = this.convergedContext.getSipApplication().getSecurityRoles();
        if (roles != null) {
            Iterator<SecurityRole> it = roles.values().iterator();
            while (it.hasNext()) {
                this.context.addSecurityRole(it.next().getName());
            }
        }
    }

    private void copyResourceEnvRefs() {
        Collection<ResourceEnvironmentReference> resources = this.convergedContext.getSipApplication().getResourceEnvironmentReferences();
        if (resources != null) {
            for (ResourceEnvironmentReference resourceEnvironmentReference : resources) {
            }
        }
    }

    private void copyResourceRefs() {
        Collection<ResourceReference> resources = this.convergedContext.getSipApplication().getResourceReferences();
        if (resources != null) {
            for (ResourceReference resource : resources) {
                ContextResource contextResource = new ContextResource();
                contextResource.setAuth(resource.getAuthentication());
                contextResource.setDescription(resource.getDescription());
                contextResource.setName(resource.getName());
                contextResource.setScope(resource.getSharingScope());
                contextResource.setType(resource.getType());
            }
        }
    }

    private void copyContextParameters() {
        Map<String, Parameter> parameters = this.convergedContext.getSipApplication().getContextParameters();
        if (parameters != null) {
            for (Parameter param : parameters.values()) {
                this.context.addParameter(param.getName(), param.getValue());
            }
        }
    }

    private String getBasePath(StandardContext context) {
        StandardContext container;
        String docBase = null;
        for (container = context; container != null && !(container instanceof Host); container = container.getParent()) {
        }
        File file = new File(context.getDocBase());
        if (!file.isAbsolute()) {
            if (container == null) {
                docBase = new File(this.engineBase(context), context.getDocBase()).getPath();
            } else {
                String appBase = ((Host)container).getAppBase();
                file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(this.engineBase(context), appBase);
                }
                docBase = new File(file, context.getDocBase()).getPath();
            }
        } else {
            docBase = file.getPath();
        }
        return docBase;
    }

    protected File engineBase(StandardContext context) {
        String base = System.getProperty("catalina.base");
        if (base == null) {
            StandardEngine engine = (StandardEngine)context.getParent().getParent();
            base = engine.getBaseDir();
        }
        return new File(base);
    }

    private void setContextResources() {
        try {
            if (this.context.getDocBase() != null && this.context.getDocBase().endsWith(".war") && !new File(this.getBasePath((StandardContext)this.context)).isDirectory()) {
                this.context.setResources((DirContext)new WARDirContext());
            } else if (this.context.getDocBase() != null && this.context.getDocBase().endsWith(".sar") && !new File(this.getBasePath((StandardContext)this.context)).isDirectory()) {
                this.context.setResources((DirContext)((Object)new SARDirContext()));
            } else {
                this.context.setResources((DirContext)new FileDirContext());
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.SEVERE, "Error initializing resources: " + e.getMessage());
        }
    }

    private void getSipApplication() throws Exception {
        SipApplication sipApplication = null;
        if (super.getDescriptor() != null && super.getDescriptor() instanceof ConvergedDescriptor) {
            sipApplication = ((ConvergedDescriptor)super.getDescriptor()).getSipApplication();
            this.convergedContext.setSipApplication(sipApplication);
        }
    }
}

