/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.config;

import com.ericsson.ssa.container.mbeans.MBeanUtil;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class RuntimeConfig
extends TimerTask {
    private static final Long DELAY = 0L;
    private static final Long CHECKINTERVAL = 60000L;
    Logger _logger = Logger.getLogger("SipContainer");
    private Timer m_timerMonitor = new Timer();

    public void loadRuntimeConfiguration() {
        MBeanServer server = MBeanUtil.getInstance().getServer();
        try {
            ObjectName oname = new ObjectName("EAS:type=Dispatcher,name=NetworkManager");
            AttributeList attrList = new AttributeList();
            Attribute attrib = null;
            attrList.addAll(this.getInitialParams());
            attrList.addAll(this.getRuntimeParams());
            server.setAttributes(oname, attrList);
            oname = new ObjectName("EAS:type=JMX Configuration");
            attrList = new AttributeList();
            attrib = new Attribute("JmxDefaultHost", this.getJMXDefaultHost());
            attrList.add(attrib);
            attrib = new Attribute("JmxDefaultPort", this.getJMXDefaultPort());
            attrList.add(attrib);
            server.setAttributes(oname, attrList);
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Failed loading properties", e);
            e.printStackTrace();
        }
    }

    private AttributeList getRuntimeParams() {
        AttributeList attrList = new AttributeList();
        Attribute attrib = null;
        attrib = new Attribute("OverloadRegulation", this.getOverloadRegulation());
        attrList.add(attrib);
        attrib = new Attribute("HttpThreshold", this.getHttpThreshold());
        attrList.add(attrib);
        attrib = new Attribute("IrThreshold", this.getIrThreshold());
        attrList.add(attrib);
        attrib = new Attribute("SrThreshold", this.getSrThreshold());
        attrList.add(attrib);
        attrib = new Attribute("MmThreshold", this.getMmThreshold());
        attrList.add(attrib);
        attrib = new Attribute("SampleRate", this.getSampleRate());
        attrList.add(attrib);
        attrib = new Attribute("NumberOfSamples", this.getNumberOfSamples());
        attrList.add(attrib);
        return attrList;
    }

    private AttributeList getInitialParams() {
        AttributeList attrList = new AttributeList();
        Attribute attrib = null;
        attrib = new Attribute("ApplicationDispatcherLoopInternal", this.getApplicationDispatcherLoopInternal());
        attrList.add(attrib);
        attrib = new Attribute("ErrorResponseEnabled", this.getErrorResponseEnabled());
        attrList.add(attrib);
        attrib = new Attribute("HostNumber", this.getHostNumber());
        attrList.add(attrib);
        attrib = new Attribute("defaultTCPTransport", this.getDefaultTCPTransport());
        attrList.add(attrib);
        attrib = new Attribute("LanAddress", this.getLanAddress());
        attrList.add(attrib);
        attrib = new Attribute("ThreadPoolSize", this.getThreadPoolSize());
        attrList.add(attrib);
        attrib = new Attribute("EnumTopDomain", this.getEnumTopDomain());
        attrList.add(attrib);
        attrib = new Attribute("timerT1", this.getTimerT1());
        attrList.add(attrib);
        attrib = new Attribute("timerT2", this.getTimerT2());
        attrList.add(attrib);
        attrib = new Attribute("timerT4", this.getTimerT4());
        attrList.add(attrib);
        attrib = new Attribute("ProxyPoolSize", this.getProxyPoolSize());
        attrList.add(attrib);
        attrib = new Attribute("ProxyRetries", this.getProxyRetries());
        attrList.add(attrib);
        attrib = new Attribute("ProxySocketTimeout", this.getProxySocketTimeout());
        attrList.add(attrib);
        attrib = new Attribute("ProxyConnectionTimeout", this.getProxyConnectionTimeout());
        attrList.add(attrib);
        attrib = new Attribute("OverloadRegulation", this.getOverloadRegulation());
        attrList.add(attrib);
        attrib = new Attribute("SampleRate", this.getSampleRate());
        attrList.add(attrib);
        attrib = new Attribute("NumberOfSamples", this.getNumberOfSamples());
        attrList.add(attrib);
        attrib = new Attribute("HttpThreshold", this.getHttpThreshold());
        attrList.add(attrib);
        attrib = new Attribute("IrThreshold", this.getIrThreshold());
        attrList.add(attrib);
        attrib = new Attribute("SrThreshold", this.getSrThreshold());
        attrList.add(attrib);
        attrib = new Attribute("MmThreshold", this.getMmThreshold());
        attrList.add(attrib);
        attrib = new Attribute("CpuAlarmEnabled", this.getCpuAlarmEnabled());
        attrList.add(attrib);
        attrib = new Attribute("CpuAlarmThreshold", this.getCpuAlaramThreshold());
        attrList.add(attrib);
        attrib = new Attribute("Eas503Disabled", this.getEas503Disabled());
        attrList.add(attrib);
        return attrList;
    }

    public abstract void uninitialize();

    public synchronized void run() {
        MBeanServer server = MBeanUtil.getInstance().getServer();
        this.uninitialize();
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "Load runtime parameters again.");
            }
            ObjectName oname = new ObjectName("EAS:type=Dispatcher,name=NetworkManager");
            server.setAttributes(oname, this.getRuntimeParams());
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, "Failed loading updated runtime properties", e);
            e.printStackTrace();
        }
    }

    protected void destroy() {
        this.m_timerMonitor.cancel();
    }

    public abstract int getThreadPoolSize();

    public abstract String getJMXDefaultHost();

    public abstract int getJMXDefaultPort();

    public abstract int getHostNumber();

    public abstract boolean getDefaultTCPTransport();

    public abstract String getLanAddress();

    public abstract boolean getApplicationDispatcherLoopInternal();

    public abstract String getEnumTopDomain();

    public abstract int getTimerT1();

    public abstract int getTimerT2();

    public abstract int getTimerT4();

    public abstract int getProxyPoolSize();

    public abstract int getProxyRetries();

    public abstract int getProxySocketTimeout();

    public abstract int getProxyConnectionTimeout();

    public abstract boolean getOverloadRegulation();

    public abstract int getSampleRate();

    public abstract int getNumberOfSamples();

    public abstract int getHttpThreshold();

    public abstract int getIrThreshold();

    public abstract int getSrThreshold();

    public abstract int getMmThreshold();

    public abstract boolean getCpuAlarmEnabled();

    public abstract int getCpuAlaramThreshold();

    public abstract boolean getErrorResponseEnabled();

    public abstract int getSipLinkTimeout();

    public abstract int getSipLinkTimeoutRetries();

    public abstract int getSipLinkMaxQueueLength();

    public abstract int getSipLinkAliveTimeout();

    public abstract boolean getEas503Disabled();
}

