/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.lease.Lease;
import com.ericsson.ssa.config.lease.LeaseExpiredException;
import com.ericsson.ssa.container.MessageProcessorFilter;
import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.SipBindingListener;
import com.ericsson.ssa.container.SipBindingResolver;
import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.sun.grizzly.CallbackHandler;
import com.sun.grizzly.ConnectorHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.DefaultProtocolChain;
import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Pipeline;
import com.sun.grizzly.ProtocolChain;
import com.sun.grizzly.ProtocolChainInstanceHandler;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SSLCallbackHandler;
import com.sun.grizzly.SSLConnectorHandler;
import com.sun.grizzly.SSLSelectorHandler;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.TCPConnectorHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.UDPConnectorHandler;
import com.sun.grizzly.UDPSelectorHandler;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.filter.SSLReadFilter;
import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public class CtxAwareGrizzlyNetworkManager
extends NetworkManager
implements Runnable {
    private static ConcurrentLinkedQueue<ByteBuffer> byteBuffersPool = new ConcurrentLinkedQueue();
    private Logger logger = Logger.getLogger("SipContainer");
    private Controller controller = new Controller();
    private Pipeline<Callable> ericssonThreadPoolWrapper = null;
    private Layer nextLayer = null;
    private SSLContext sslContext;
    private Config _config = ConfigFactory.getConfig();
    ConnectionManager connectionManager = null;

    public CtxAwareGrizzlyNetworkManager() {
        this.initPipeline();
    }

    public synchronized void start() throws IOException {
        int keepAliveTimeoutInSeconds = 600;
        this.controller = new Controller();
        for (String ctx : SipBindingResolver.instance().getLocalContexts()) {
            this.startCtx(ctx);
        }
        SipBindingResolver.instance().registerSipBindingListener(new SipBindingListener(){

            public void newSipBindingAvaliable(String context) {
                CtxAwareGrizzlyNetworkManager.this.startCtx(context);
            }
        });
        DefaultSelectionKeyHandler keyHandler = new DefaultSelectionKeyHandler(){

            public void expire(SelectionKey key) {
            }
        };
        keyHandler.setLogger(this.logger);
        keyHandler.setTimeout((long)(keepAliveTimeoutInSeconds * 1000));
        this.controller.setSelectionKeyHandler((SelectionKeyHandler)keyHandler);
        final DefaultProtocolChain protocolChain = new DefaultProtocolChain();
        protocolChain.addFilter((ProtocolFilter)new ReadFilter());
        protocolChain.addFilter((ProtocolFilter)new MessageProcessorFilter(this));
        ProtocolChainInstanceHandler instanceHandler = new ProtocolChainInstanceHandler(){

            public ProtocolChain poll() {
                return protocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return true;
            }
        };
        this.controller.setProtocolChainInstanceHandler(instanceHandler);
        this.controller.setPipeline(this.ericssonThreadPoolWrapper);
        this.connectionManager = new ConnectionManager(this.controller);
    }

    private ProtocolChainInstanceHandler setupTLSSupport() throws IOException {
        ServerSocketFactory serverSF = null;
        try {
            SSLImplementation sslHelper = SSLImplementation.getInstance();
            serverSF = sslHelper.getServerSocketFactory();
            serverSF.setAttribute("keystoreType", (Object)"JKS");
            serverSF.setAttribute("keystore", (Object)System.getProperty("javax.net.ssl.keyStore"));
            serverSF.setAttribute("truststoreType", (Object)"JKS");
            serverSF.setAttribute("truststore", (Object)System.getProperty("javax.net.ssl.trustStore"));
            String keyAlias = System.getProperty("sip.network.tls.keyAlias", "s1as");
            serverSF.setAttribute("keyAlias", (Object)keyAlias);
            serverSF.init();
        }
        catch (ClassNotFoundException t) {
            throw new RuntimeException(t);
        }
        this.sslContext = serverSF.getSSLContext();
        SSLReadFilter readFilter = new SSLReadFilter();
        readFilter.setSSLContext(this.sslContext);
        Boolean clientAuth = new Boolean(System.getProperty("sip.network.tls.clientAuth", Boolean.FALSE.toString()));
        readFilter.setNeedClientAuth(clientAuth.booleanValue());
        DefaultProtocolChain tlsProtocolChain = new DefaultProtocolChain();
        tlsProtocolChain.addFilter((ProtocolFilter)readFilter);
        tlsProtocolChain.addFilter((ProtocolFilter)new MessageProcessorFilter(this));
        ProtocolChainInstanceHandler tlsProtocolChainHandler = new ProtocolChainInstanceHandler((ProtocolChain)tlsProtocolChain){
            final /* synthetic */ ProtocolChain val$tlsProtocolChain;
            {
                this.val$tlsProtocolChain = protocolChain;
            }

            public ProtocolChain poll() {
                return this.val$tlsProtocolChain;
            }

            public boolean offer(ProtocolChain instance) {
                return true;
            }
        };
        return tlsProtocolChainHandler;
    }

    public synchronized void stop() throws IOException {
        this.controller.stop();
    }

    public void startCtx(String ctx) {
        Lease<TargetTuple[]> lease = SipBindingResolver.instance().lease(ctx);
        try {
            block9: for (TargetTuple targetTuple : lease.getResource()) {
                switch (targetTuple.getProtocol().ordinal()) {
                    case 1: {
                        UDPSelectorHandler udpSelector = this.createUdpEndpoint(targetTuple.getSocketAddress());
                        this.controller.addSelectorHandler((SelectorHandler)udpSelector);
                        continue block9;
                    }
                    case 2: {
                        TCPSelectorHandler tcpSelector = this.createTcpEndpoint(targetTuple.getSocketAddress());
                        this.controller.addSelectorHandler((SelectorHandler)tcpSelector);
                        continue block9;
                    }
                    case 3: {
                        SSLSelectorHandler tlsSelector = this.createTLSEndpoint(targetTuple.getSocketAddress());
                        this.controller.addSelectorHandler((SelectorHandler)tlsSelector);
                        try {
                            tlsSelector.setProtocolChainInstanceHandler(this.setupTLSSupport());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue block9;
                    }
                }
            }
        }
        catch (LeaseExpiredException e) {
            e.printStackTrace();
        }
    }

    void initPipeline() {
        this.ericssonThreadPoolWrapper = new DefaultPipeline(100, 20, "SipContainer", 5060);
        SipContainerThreadPool tp = SipContainerThreadPool.getInstance();
        tp.initialize(this.ericssonThreadPoolWrapper);
    }

    public void next(SipServletRequestImpl req) {
        LayerHelper.next(req, (Layer)this, this.nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        LayerHelper.next(resp, (Layer)this, this.nextLayer);
    }

    public void registerNext(Layer layer) {
        this.nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        try {
            ByteBuffer buffer = byteBuffersPool.poll();
            if (buffer == null) {
                buffer = ByteBufferFactory.allocateView((boolean)false);
            }
            this.connectionManager.send(req.toBuffer(buffer), req.getRemote());
            buffer.clear();
            byteBuffersPool.offer(buffer);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to send response : " + req.toDebugString(), e);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Done sending req : " + req.toDebugString());
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        try {
            this.connectionManager.send(resp.toBuffer(), resp.getRemote());
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Failed to send response : " + resp.toDebugString(), e);
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.info("Done sending resp : " + resp.toDebugString());
        }
    }

    TCPSelectorHandler createTcpEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        TCPSelectorHandler selectorHandler = new TCPSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLinger(linger);
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        selectorHandler.setSocketTimeout(keepAliveTimeoutInSeconds * 1000);
        return selectorHandler;
    }

    SSLSelectorHandler createTLSEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        SSLSelectorHandler selectorHandler = new SSLSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLinger(linger);
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        selectorHandler.setSocketTimeout(keepAliveTimeoutInSeconds * 1000);
        return selectorHandler;
    }

    UDPSelectorHandler createUdpEndpoint(InetSocketAddress addr) {
        int keepAliveTimeoutInSeconds = 600;
        int linger = -1;
        UDPSelectorHandler selectorHandler = new UDPSelectorHandler();
        selectorHandler.setPort(addr.getPort());
        selectorHandler.setInet(addr.getAddress());
        selectorHandler.setLogger(this.logger);
        selectorHandler.setReuseAddress(true);
        return selectorHandler;
    }

    public void run() {
        try {
            this.controller.start();
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Exception, RUN ON GNM called!", e);
        }
    }

    class ConnectionManager {
        private ConcurrentHashMap<TargetTuple, ConnectorHandler> streams = new ConcurrentHashMap();

        public ConnectionManager(Controller controller) {
        }

        public void send(ByteBuffer bb, TargetTuple tt) throws IOException {
            if (tt.getProtocol().ordinal() == 2 || tt.getProtocol().ordinal() == 3) {
                ConnectorHandler handler = this.streams.get(tt);
                if (handler == null && tt.getProtocol().ordinal() == 2) {
                    handler = this.createHandlerTCP(tt);
                } else if (handler == null && tt.getProtocol().ordinal() == 3) {
                    handler = this.createHandlerTLS(tt);
                }
                bb.flip();
                try {
                    handler.write(bb, true);
                }
                catch (IOException ex) {
                    this.streams.remove(tt);
                    CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Write failed: " + handler.getUnderlyingChannel(), ex);
                    this.send(bb, tt);
                }
            } else {
                ConnectorHandler handler = this.streams.get(tt);
                if (handler == null) {
                    handler = this.createHandlerUDP(tt);
                }
                bb.flip();
                try {
                    handler.write(bb, false);
                }
                catch (IOException ex) {
                    this.streams.remove(tt);
                    CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Write failed: " + handler.getUnderlyingChannel(), ex);
                    throw ex;
                }
            }
        }

        private ConnectorHandler createHandlerTCP(TargetTuple tt) throws IOException {
            ConnectorHandler cached;
            InetSocketAddress remote = tt.getSocketAddress();
            final TCPConnectorHandler connectorHandler = (TCPConnectorHandler)CtxAwareGrizzlyNetworkManager.this.controller.acquireConnectorHandler(Controller.Protocol.TCP);
            CallbackHandler<Context> callbackHandler = new CallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                    try {
                        connectorHandler.finishConnect(key);
                        CtxAwareGrizzlyNetworkManager.this.controller.registerKey(key, 1, Controller.Protocol.TCP);
                    }
                    catch (IOException ex) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Connect failed: ", ex);
                    }
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        Context ctx = (Context)ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        ctx.getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            long t1 = 0L;
            if (CtxAwareGrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                t1 = System.currentTimeMillis();
            }
            connectorHandler.connect((SocketAddress)remote, (CallbackHandler)callbackHandler);
            if (CtxAwareGrizzlyNetworkManager.this.logger.isLoggable(Level.FINE)) {
                CtxAwareGrizzlyNetworkManager.this.logger.log(Level.FINE, "================>>> " + (System.currentTimeMillis() - t1));
            }
            if ((cached = this.streams.putIfAbsent(tt, (ConnectorHandler)connectorHandler)) != null) {
                connectorHandler.close();
                return cached;
            }
            return connectorHandler;
        }

        public void waitOnLatch(CountDownLatch latch, int timeout, TimeUnit timeUnit) {
            try {
                latch.await(timeout, timeUnit);
            }
            catch (InterruptedException ex) {
                CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Wait on latch: ", ex);
            }
        }

        private SSLConnectorHandler createHandlerTLS(TargetTuple tt) throws IOException {
            InetSocketAddress remote = tt.getSocketAddress();
            final CountDownLatch handshakeDoneLatch = new CountDownLatch(1);
            final SSLConnectorHandler connectorHandler = new SSLConnectorHandler(CtxAwareGrizzlyNetworkManager.this.sslContext);
            connectorHandler.setController(CtxAwareGrizzlyNetworkManager.this.controller);
            final ByteBuffer inBuffer = ByteBufferFactory.allocateView((boolean)false);
            SSLCallbackHandler<Context> sslCallbackHander = new SSLCallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    try {
                        SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                        try {
                            connectorHandler.finishConnect(key);
                        }
                        catch (IOException ex) {
                            CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Connect failed: ", ex);
                            return;
                        }
                        key.attach(connectorHandler.getSSLEngine());
                        if (connectorHandler.isConnected()) {
                            if (connectorHandler.handshake(inBuffer, true)) {
                                this.onHandshake(ioEvent);
                            }
                            connectorHandler.getSSLEngine().getSession().putValue("handshake", Boolean.TRUE);
                            CtxAwareGrizzlyNetworkManager.this.controller.registerKey(key, 1, Controller.Protocol.TLS);
                        }
                    }
                    catch (IOException e) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Connect failed: ", e);
                    }
                }

                public void onHandshake(IOEvent<Context> ioEvent) {
                    inBuffer.clear();
                    handshakeDoneLatch.countDown();
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        Context ctx = (Context)ioEvent.attachment();
                        SelectionKey key = ctx.getSelectionKey();
                        key.interestOps(key.interestOps() & 0xFFFFFFFE);
                        ctx.getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            connectorHandler.connect((SocketAddress)remote, (SSLCallbackHandler)sslCallbackHander);
            this.waitOnLatch(handshakeDoneLatch, 10, TimeUnit.SECONDS);
            this.streams.put(tt, (ConnectorHandler)connectorHandler);
            return connectorHandler;
        }

        private UDPConnectorHandler createHandlerUDP(TargetTuple tt) throws IOException {
            InetSocketAddress remote = tt.getSocketAddress();
            final UDPConnectorHandler connectorHandler = (UDPConnectorHandler)CtxAwareGrizzlyNetworkManager.this.controller.acquireConnectorHandler(Controller.Protocol.UDP);
            CallbackHandler<Context> callbackHandler = new CallbackHandler<Context>(){

                public void onConnect(IOEvent<Context> ioEvent) {
                    SelectionKey key = ((Context)ioEvent.attachment()).getSelectionKey();
                    try {
                        connectorHandler.finishConnect(key);
                        CtxAwareGrizzlyNetworkManager.this.controller.registerKey(key, 1, Controller.Protocol.UDP);
                    }
                    catch (IOException ex) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Connect failed: ", ex);
                    }
                }

                public void onRead(IOEvent<Context> ioEvent) {
                    try {
                        ((Context)ioEvent.attachment()).getProtocolChain().execute((Context)ioEvent.attachment());
                    }
                    catch (Throwable e) {
                        CtxAwareGrizzlyNetworkManager.this.logger.log(Level.SEVERE, "Read failed: ", e);
                    }
                }

                public void onWrite(IOEvent<Context> ioEvent) {
                    throw new IllegalStateException("Should not end up here!");
                }
            };
            connectorHandler.connect((SocketAddress)remote, (CallbackHandler)callbackHandler);
            this.streams.put(tt, (ConnectorHandler)connectorHandler);
            return connectorHandler;
        }
    }
}

