/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.HttpConnectionPool;
import com.ericsson.ssa.container.HttpHost;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpConnection {
    private static Logger log = Logger.getLogger("SipContainer");
    protected static final int DEFAULT_SOCKET_TIMEOUT = 120000;
    protected static final int MAX_RECEIVE_BUFFER_SIZE = 2048;
    protected static final int MAX_SEND_BUFFER_SIZE = 2048;
    private static final byte[] NEWLINE = new byte[]{13, 10};
    private HttpConnectionPool pool;
    private HttpHost host;
    private Socket socket;
    private int socketTimeout;
    private boolean isOpen;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Config _config = ConfigFactory.getConfig();

    public HttpConnection(HttpHost host) {
        this(host, 120000);
    }

    public HttpConnection(HttpHost host, int socketTimeout) {
        this.host = host;
        this.socketTimeout = socketTimeout;
    }

    protected HttpConnection(HttpHost host, HttpConnectionPool pool) {
        this(host, 120000, pool);
    }

    protected HttpConnection(HttpHost host, int socketTimeout, HttpConnectionPool pool) {
        this.host = host;
        this.socketTimeout = socketTimeout;
        this.pool = pool;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStale() throws IOException {
        boolean isStale;
        block10: {
            isStale = true;
            if (this.isOpen()) {
                try {
                    isStale = false;
                    if (this.inputStream.available() > 0) break block10;
                    this.socket.setSoTimeout(1);
                    this.inputStream.mark(1);
                    try {
                        if (this.inputStream.read() == -1) {
                            isStale = true;
                        } else {
                            this.inputStream.reset();
                        }
                    }
                    finally {
                        this.socket.setSoTimeout(this.socketTimeout);
                    }
                }
                catch (InterruptedIOException e) {
                    if (!(e instanceof SocketTimeoutException)) {
                        throw e;
                    }
                }
                catch (IOException e) {
                    isStale = true;
                }
            }
        }
        return isStale;
    }

    public void open() throws IOException, IllegalStateException {
        if (this.isOpen()) {
            throw new IllegalStateException("The connection is already opened.");
        }
        try {
            int outBufSize;
            InetSocketAddress socketAddress = new InetSocketAddress(this.host.getHostname(), this.host.getPort());
            if (this.socket == null) {
                this.socket = new Socket();
                InetAddress ia = InetAddress.getByName(this._config.get("HOST"));
                InetSocketAddress localBind = new InetSocketAddress(ia, 0);
                this.socket.bind(localBind);
                this.socket.connect(socketAddress);
            }
            this.socket.setSoTimeout(this.socketTimeout);
            int inBufSize = this.socket.getReceiveBufferSize();
            if (inBufSize <= 0 || inBufSize > 2048) {
                inBufSize = 2048;
            }
            if ((outBufSize = this.socket.getSendBufferSize()) <= 0 || outBufSize > 2048) {
                outBufSize = 2048;
            }
            this.inputStream = new BufferedInputStream(this.socket.getInputStream(), inBufSize);
            this.outputStream = new BufferedOutputStream(this.socket.getOutputStream(), outBufSize);
            this.isOpen = true;
        }
        catch (IOException e) {
            this.closeConnection();
            throw e;
        }
    }

    public void close() {
        this.closeConnection();
    }

    public void release() throws UnsupportedOperationException {
        if (this.pool == null) {
            throw new UnsupportedOperationException("This connection is not managed by any connection pool.");
        }
        this.pool.releaseConnection(this);
    }

    public OutputStream getOutputStream() throws IllegalStateException {
        this.assertOpened();
        return this.outputStream;
    }

    public InputStream getInputStream() throws IllegalStateException {
        this.assertOpened();
        return this.inputStream;
    }

    public void flushOutputStream() throws IOException {
        this.assertOpened();
        this.outputStream.flush();
    }

    public String readLine() throws IOException {
        return this.readLine("ISO-8859-1");
    }

    public String readLine(String charset) throws IOException {
        int ch;
        this.assertOpened();
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((ch = this.inputStream.read()) >= 0) {
            buf.write(ch);
            if (ch != 10) continue;
        }
        if (buf.size() == 0) {
            return null;
        }
        byte[] buffer = buf.toByteArray();
        int len = buffer.length;
        int offset = 0;
        if (len > 0 && buffer[len - 1] == 10) {
            ++offset;
            if (len > 1 && buffer[len - 2] == 13) {
                ++offset;
            }
        }
        return new String(buffer, 0, len - offset, charset);
    }

    public void write(byte[] data) throws IOException, IllegalStateException {
        this.write(data, 0, data.length);
    }

    public void write(byte[] data, int offset, int length) throws IOException, IllegalStateException {
        this.assertOpened();
        this.outputStream.write(data, offset, length);
    }

    public void writeLine(byte[] data) throws IOException, IllegalStateException {
        this.write(data);
        this.writeLine();
    }

    public void writeLine() throws IOException, IllegalStateException {
        this.write(NEWLINE);
    }

    public void print(String data) throws IOException, IllegalStateException {
        this.print(data, "ISO-8859-1");
    }

    public void print(String data, String charset) throws IOException, IllegalStateException {
        try {
            this.write(data.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unsupported encoding '" + charset + "'. Using default system encoding instead.");
            this.write(data.getBytes());
        }
    }

    public void printLine(String data) throws IOException, IllegalStateException {
        this.printLine(data, "ISO-8859-1");
    }

    public void printLine(String data, String charset) throws IOException, IllegalStateException {
        try {
            this.writeLine(data.getBytes(charset));
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unsupported encoding '" + charset + "'. Using default system encoding instead.");
            this.writeLine(data.getBytes());
        }
    }

    public String toString() {
        String socketInfo = "Socket not yet created";
        if (this.socket != null) {
            socketInfo = "localaddr=" + this.socket.getLocalSocketAddress() + ", remoteaddr=" + this.socket.getRemoteSocketAddress();
        }
        return "Connection(isOpen=" + this.isOpen() + ", SocketInfo=" + socketInfo + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
            }
            finally {
                this.inputStream = null;
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
            }
            finally {
                this.outputStream = null;
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "The socket was closed for connection: " + this);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.socket = null;
            }
        }
        this.isOpen = false;
    }

    private void assertOpened() throws IllegalStateException {
        if (!this.isOpen()) {
            throw new IllegalStateException("The connection must to be opened first.");
        }
    }
}

