/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Request;
import org.apache.coyote.tomcat5.CoyoteRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFormData {
    private static final Logger log = Logger.getLogger("SipContainer");
    private static final int INITIAL_FORM_DATA_SIZE = 4096;
    private ByteArrayOutputStream data = new ByteArrayOutputStream(4096);

    public HttpFormData(Request request) {
        this.recreateFormData(request);
    }

    public byte[] getData() {
        return this.data.toByteArray();
    }

    public int getLength() {
        return this.data.size();
    }

    private void recreateFormData(Request req) {
        HttpServletRequest request = HttpFormData.getHttpRequest(req);
        String encoding = "ISO-8859-1";
        if (request.getCharacterEncoding() != null) {
            encoding = request.getCharacterEncoding();
        }
        try {
            boolean isFirstParameter = true;
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.data, encoding);
            Map<String, HashSet<String>> excludedParameters = HttpFormData.getQueryParameters(req);
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String[] parameterValues;
                String parameterName = (String)parameterNames.nextElement();
                for (String parameterValue : parameterValues = request.getParameterValues(parameterName)) {
                    if (excludedParameters != null && this.containsParameter(excludedParameters, parameterName, parameterValue)) continue;
                    if (!isFirstParameter) {
                        writer.append('&');
                    } else {
                        isFirstParameter = false;
                    }
                    writer.append(URLEncoder.encode(parameterName, encoding));
                    if (parameterValue == null || parameterValue.length() <= 0) continue;
                    writer.append('=');
                    writer.append(URLEncoder.encode(parameterValue, encoding));
                }
            }
            writer.flush();
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unknown character encoding used. Unable to recreate form data.");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static Map<String, HashSet<String>> getQueryParameters(Request req) throws UnsupportedEncodingException {
        String[] pairs;
        HttpServletRequest request = HttpFormData.getHttpRequest(req);
        String query = request.getQueryString();
        if (query == null) {
            return null;
        }
        HashMap<String, HashSet<String>> parameters = new HashMap<String, HashSet<String>>();
        String encoding = "ISO-8859-1";
        for (String pair : pairs = query.split("&")) {
            String[] fields = pair.split("=");
            String name = URLDecoder.decode(fields[0], encoding);
            String value = URLDecoder.decode(fields[1], encoding);
            HashSet<String> values = (HashSet<String>)parameters.get(name);
            if (values == null) {
                values = new HashSet<String>();
                parameters.put(name, values);
            }
            values.add(value);
        }
        return parameters;
    }

    private boolean containsParameter(Map<String, HashSet<String>> parameters, String parameterName, String parameterValue) {
        if (parameters.containsKey(parameterName)) {
            return parameters.get(parameterName).contains(parameterValue);
        }
        return false;
    }

    private static HttpServletRequest getHttpRequest(Request req) {
        return (CoyoteRequest)req;
    }
}

