/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import java.net.URI;

public final class HttpHost
implements Cloneable {
    private static final int HTTP_DEFAULT_PORT = 80;
    private String hostname;
    private int port;

    public HttpHost(String hostname, int port) {
        if (hostname == null) {
            throw new IllegalArgumentException("Host name must be specified.");
        }
        this.hostname = hostname;
        this.port = port < 0 ? 80 : port;
    }

    public HttpHost(String hostname) {
        this(hostname, -1);
    }

    public HttpHost(URI uri) {
        this(uri.getHost(), uri.getPort());
    }

    private HttpHost(HttpHost source) {
        this.hostname = source.hostname;
        this.port = source.port;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public Object clone() {
        return new HttpHost(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpHost) {
            if (obj == this) {
                return true;
            }
            HttpHost that = (HttpHost)obj;
            if (!this.hostname.equalsIgnoreCase(that.hostname)) {
                return false;
            }
            return this.port == that.port;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.hostname.hashCode();
        hash = 31 * hash + this.port;
        return hash;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("http://");
        s.append(this.hostname);
        if (this.port != 80) {
            s.append(':');
            s.append(this.port);
        }
        return s.toString();
    }
}

