/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.Link;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.container.SipParserErrorHandlerImpl;
import com.ericsson.ssa.container.processor.QueuedProcessor;
import com.ericsson.ssa.container.processor.QueuedTask;
import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipParser;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.ServletTimer;

public abstract class LinkBase
implements Link {
    protected static final int BUFFER_SIZE = 4096;
    private Logger _log = Logger.getLogger("SipContainer");
    protected OLDNetworkManager _networkManager;
    protected SipContainerThreadPool _threadPool = SipContainerThreadPool.getInstance();
    protected Layer _nextLayer;
    protected SipParser _parser = SipParser.getInstance();
    protected ByteBuffer _readBuffer = null;
    protected ByteBuffer _writeBuffer = null;
    protected ReentrantLock _readMutex = new ReentrantLock();
    protected SipServletMessageImpl _message = null;
    private QueuedProcessor _writeProcessor;
    private ServletTimer _linkAliveTimer;
    private boolean _enableLinkAliveTimer;
    private AtomicBoolean _linkActive = new AtomicBoolean(false);

    public LinkBase(OLDNetworkManager networkManager, Layer next, boolean enableLinkAliveTimer) {
        this._networkManager = networkManager;
        this._nextLayer = next;
        this._enableLinkAliveTimer = enableLinkAliveTimer;
        this._writeProcessor = new QueuedProcessor(this._networkManager.getSipLinkMaxQueueLength(), 0L);
        if (this._enableLinkAliveTimer) {
            this._linkAliveTimer = TimerServiceImpl.getInstance().createTimer(this, this._networkManager.getSipLinkAliveTimeout() * 1000L, this._networkManager.getSipLinkAliveTimeout() * 1000L, false, false, (Serializable)((Object)"Link alive timer"));
        }
    }

    public LinkBase(OLDNetworkManager networkManager, Layer next) {
        this(networkManager, next, false);
    }

    public abstract void write(InetSocketAddress var1, ByteBuffer var2) throws IOException;

    public void dispatch(SipServletRequestImpl req) {
        Dispatcher nextDispatcher = req.popDispatcher();
        if (nextDispatcher != null) {
            nextDispatcher.dispatch(req);
            return;
        }
        this.putTask(new WriteRequestTask(req));
    }

    private void sendError(final SipServletRequestImpl req, boolean async) {
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "Send 503 due to failure when writing: " + req);
        }
        if (req.getMethod().equals("ACK")) {
            return;
        }
        if (async) {
            this._threadPool.execute(new Runnable(){

                public void run() {
                    SipServletResponseImpl resp = req.createTerminatingResponse(503);
                    LinkBase.this._nextLayer.next(resp);
                }
            });
        } else {
            SipServletResponseImpl resp = req.createTerminatingResponse(503);
            this._nextLayer.next(resp);
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        Dispatcher nextDispatcher = resp.popDispatcher();
        if (nextDispatcher != null) {
            nextDispatcher.dispatch(resp);
            return;
        }
        this.putTask(new WriteResponseTask(resp));
    }

    public final void close() throws IOException {
        this.shutdownWriteProcessor();
        this.closeImpl();
    }

    protected void shutdownWriteProcessor() {
        this.cancelLinkAliveTimer();
        this._writeProcessor.shutdown();
    }

    protected abstract void closeImpl() throws IOException;

    public void timeout(ServletTimer timer) {
        block4: {
            if (!this._linkActive.getAndSet(false)) {
                this._writeProcessor.shutdown();
                try {
                    if (this._log.isLoggable(Level.FINE)) {
                        this._log.log(Level.FINE, this + " Closed link " + this.getInfo() + " due to no activity for " + this._networkManager.getSipLinkAliveTimeout() + " seconds");
                    }
                    this.close();
                }
                catch (IOException e) {
                    if (!this._log.isLoggable(Level.FINE)) break block4;
                    this._log.log(Level.FINE, "Failure when closing link: " + e);
                }
            }
        }
    }

    public void markAsActive() {
        this._linkActive.set(true);
    }

    private void cancelLinkAliveTimer() {
        if (this._linkAliveTimer != null) {
            this._linkAliveTimer.cancel();
        }
    }

    private void putTaskImpl(QueuedTask task) throws QueuedProcessor.ProcessorException {
        this.markAsActive();
        this._writeProcessor.put(task);
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "writeProcessor: " + this._writeProcessor);
        }
    }

    protected void putTask(QueuedTask task) {
        try {
            this.putTaskImpl(task);
        }
        catch (QueuedProcessor.ProcessorException e) {
            this._log.log(Level.FINE, "Failed to put task for writing due to exceeded queue size.");
        }
    }

    private void putTask(WriteRequestTask task) {
        try {
            this.putTaskImpl(task);
        }
        catch (QueuedProcessor.ProcessorException e) {
            SipServletRequestImpl request = task.getRequest();
            this._log.log(Level.FINE, "Network OUT request " + request.getMethod() + " is dropped due to exceeded queue size --> \r\n" + request.toString());
            this.sendError(request, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(ByteBuffer buffer, InetSocketAddress local, TargetTuple remote) {
        SipServletMessageImpl parsedMessage = null;
        try {
            int initialSize = 0;
            int remaining = buffer.remaining();
            while (remaining > 0 && initialSize != remaining) {
                initialSize = remaining;
                SipParserErrorHandlerImpl sipParserErrorHandler = new SipParserErrorHandlerImpl(this);
                sipParserErrorHandler.setErrorResponseEnabled(this._networkManager.isErrorResponseEnabled());
                parsedMessage = this._parser.parseMessage(this._message, buffer, local, remote, sipParserErrorHandler);
                remaining = buffer.remaining();
                if (parsedMessage != null && parsedMessage.isMessageComplete() && remaining > 0) {
                    final SipServletMessageImpl msg = parsedMessage;
                    parsedMessage = null;
                    this._threadPool.execute(new Runnable(){

                        public void run() {
                            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                                LinkBase.this._log.log(Level.FINE, "Executing Inner Task -> lock = " + LinkBase.this._readMutex.isHeldByCurrentThread());
                            }
                            LinkBase.this.processMessage(msg);
                            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                                LinkBase.this._log.log(Level.FINE, "Executing Inner Task -> lock = " + LinkBase.this._readMutex.isHeldByCurrentThread());
                            }
                        }
                    });
                }
                if (remaining <= 0 || initialSize == remaining) continue;
                this._message = parsedMessage;
                buffer.mark();
                buffer.compact();
                buffer.flip();
                if (!this._log.isLoggable(Level.FINE)) continue;
                this._log.log(Level.FINE, "Position = " + buffer.position() + " ,Remains = " + buffer.remaining());
            }
            if (parsedMessage == null) {
                if (this._log.isLoggable(Level.FINE)) {
                    this._log.log(Level.FINE, "The parsed request is null - not continuing!(" + buffer.position() + ')');
                }
                int p = buffer.limit();
                buffer.clear();
                buffer.position(p);
                this._message = null;
                if (PerformanceMBeanListener.isEnabled()) {
                    this._networkManager.incrEasInvalidSipMessages();
                }
                return;
            }
            if (!parsedMessage.isMessageComplete()) {
                if (this._log.isLoggable(Level.FINE)) {
                    this._log.log(Level.FINE, "The parsed request is not complete - not continuing! (" + buffer.position() + ')');
                }
                if (buffer.hasRemaining()) {
                    buffer.compact();
                } else {
                    buffer.clear();
                }
                this._message = parsedMessage;
                return;
            }
            buffer.clear();
            this._message = null;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                if (this._log.isLoggable(Level.INFO)) {
                    this._log.log(Level.INFO, "Exception processing request " + this.getInfo() + ": " + t.getMessage(), t);
                }
            } else {
                this._log.log(Level.SEVERE, "Caught Throwable: ", t);
            }
            if (this._readMutex.isLocked() && this._readMutex.isHeldByCurrentThread()) {
                this._message = null;
                buffer.clear();
            }
            if (PerformanceMBeanListener.isEnabled()) {
                this._networkManager.incrEasInvalidSipMessages();
            }
            return;
        }
        finally {
            this._readMutex.unlock();
        }
        this.processMessage(parsedMessage);
    }

    protected void processMessage(SipServletMessageImpl message) {
        if (message instanceof SipServletRequestImpl) {
            SipServletRequestImpl req = (SipServletRequestImpl)message;
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Network IN request " + req.getMethod() + " --> \r\n" + req.toString());
            }
            if (this.hasBodyWithoutContentType(message)) {
                return;
            }
            req.pushTransactionDispatcher(this);
            req.pushApplicationDispatcher(this._networkManager);
            this._nextLayer.next(req);
            if (PerformanceMBeanListener.isEnabled()) {
                this._networkManager.incrEasReceivedSipRequests();
            }
        } else {
            SipServletResponseImpl resp = (SipServletResponseImpl)message;
            Header cseq = resp.getRawHeader("Cseq");
            if (cseq == null) {
                if (PerformanceMBeanListener.isEnabled()) {
                    this._networkManager.incrEasInvalidSipMessages();
                }
                return;
            }
            String c = cseq.getValue();
            int index = c.indexOf(32);
            resp.setMethod(c.substring(index + 1));
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Network IN response " + resp.getStatus() + " " + resp.getMethod() + " --> \r\n" + resp.toString());
            }
            this._nextLayer.next(resp);
            if (PerformanceMBeanListener.isEnabled()) {
                this._networkManager.incrEasReceivedSipResponses();
            }
        }
    }

    public boolean hasBodyWithoutContentType(SipServletMessageImpl message) {
        if (message.hasBody() && message.getContentType() == null) {
            block9: {
                try {
                    String phraze;
                    SipServletRequestImpl req;
                    SipServletResponseImpl resp;
                    if (this._log.isLoggable(Level.FINE)) {
                        this._log.log(Level.FINE, "Missing Content-Type header field, the request has a body.");
                    }
                    if ((resp = (req = (SipServletRequestImpl)message).createTerminatingResponse(400, phraze = "Missing Content-Type header field")) != null) {
                        while (resp.popDispatcher() != null) {
                        }
                        TargetResolver tr = TargetResolver.getInstance();
                        TargetTuple tt = tr.resolveResponse(resp);
                        if (tt != null) {
                            resp.setRemote(tt);
                            this.dispatch(resp);
                        }
                    } else if (this._log.isLoggable(Level.FINE)) {
                        this._log.log(Level.FINE, "failed to find out where to send error response " + this.getInfo() + ".");
                    }
                }
                catch (Exception ignore) {
                    if (!this._log.isLoggable(Level.FINE)) break block9;
                    this._log.log(Level.FINE, "Unexpected exception " + this.getInfo() + ": " + ignore);
                }
            }
            return true;
        }
        return false;
    }

    private class WriteRequestTask
    extends WriteTask {
        SipServletRequestImpl request;

        public WriteRequestTask(SipServletRequestImpl request) {
            this.request = request;
        }

        public SipServletRequestImpl getRequest() {
            return this.request;
        }

        public void doErrorAction(String cause) {
            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                LinkBase.this._log.log(Level.FINE, "Network OUT request " + this.request.getMethod() + " is dropped due to " + cause + " --> \r\n" + this.request.toString());
            }
            LinkBase.this.sendError(this.request, true);
        }

        public void run() {
            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                LinkBase.this._log.log(Level.FINE, "Network OUT request " + this.request.getMethod() + " is going to be written to link: " + LinkBase.this.getInfo() + "--> \r\n" + this.request.toString());
            }
            this.writeRequest(this.request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeRequest(SipServletRequestImpl req) {
            try {
                req.toBufferInit();
                while (req.toBufferHasRemaining()) {
                    LinkBase.this._writeBuffer.clear();
                    req.toBuffer(LinkBase.this._writeBuffer);
                    if (LinkBase.this._log.isLoggable(Level.FINE)) {
                        LinkBase.this._log.log(Level.FINE, "Sending:" + LinkBase.this._writeBuffer.position() + " bytes");
                    }
                    LinkBase.this._writeBuffer.flip();
                    LinkBase.this.write(req.getRemote().getSocketAddress(), LinkBase.this._writeBuffer);
                }
            }
            catch (IOException ioe) {
                if (LinkBase.this._log.isLoggable(Level.INFO)) {
                    LinkBase.this._log.log(Level.INFO, "Got IOException in write " + LinkBase.this.getInfo() + ": ", ioe);
                }
                LinkBase.this.sendError(req, true);
                return;
            }
            catch (Throwable t) {
                if (LinkBase.this._log.isLoggable(Level.INFO)) {
                    LinkBase.this._log.log(Level.INFO, "Got unexpected exception in dispatch " + LinkBase.this.getInfo() + ": ", t);
                }
                LinkBase.this.sendError(req, true);
                return;
            }
            finally {
                if (!LinkBase.this.isOpen()) {
                    LinkBase.this.shutdownWriteProcessor();
                }
            }
            if (PerformanceMBeanListener.isEnabled()) {
                LinkBase.this._networkManager.incrEasSentSipRequests();
            }
        }
    }

    private class WriteResponseTask
    extends WriteTask {
        SipServletResponseImpl response;

        public WriteResponseTask(SipServletResponseImpl response) {
            this.response = response;
        }

        public void run() {
            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                LinkBase.this._log.log(Level.FINE, "Network OUT response " + this.response.getMethod() + " is going to be written to link: " + LinkBase.this.getInfo() + " --> \r\n" + this.response.toString());
            }
            this.writeResponse(this.response);
        }

        public void doErrorAction(String cause) {
            if (LinkBase.this._log.isLoggable(Level.FINE)) {
                LinkBase.this._log.log(Level.FINE, "Network OUT response " + this.response.getMethod() + " is dropped due to " + cause + " --> \r\n" + this.response.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeResponse(SipServletResponseImpl resp) {
            try {
                ByteBuffer buf = resp.toBuffer();
                buf.flip();
                LinkBase.this.write(resp.getRemote().getSocketAddress(), buf);
            }
            catch (IOException ioe) {
                if (LinkBase.this._log.isLoggable(Level.INFO)) {
                    LinkBase.this._log.log(Level.INFO, "Got IOException in write " + LinkBase.this.getInfo() + ": ", ioe);
                }
            }
            catch (Throwable t) {
                if (LinkBase.this._log.isLoggable(Level.INFO)) {
                    LinkBase.this._log.log(Level.INFO, "Got unexpected exception in dispatch " + LinkBase.this.getInfo() + ": ", t);
                }
            }
            finally {
                if (!LinkBase.this.isOpen()) {
                    LinkBase.this.shutdownWriteProcessor();
                }
            }
            if (PerformanceMBeanListener.isEnabled()) {
                LinkBase.this._networkManager.incrEasSentSipResponses();
            }
        }
    }

    private abstract class WriteTask
    implements QueuedTask {
        long timeout;

        public WriteTask() {
            this.timeout = System.currentTimeMillis() + (long)Math.min(LinkBase.this._networkManager.getSipLinkTimeout() * LinkBase.this._networkManager.getSipLinkTimeoutRetries() * LinkBase.this._networkManager.getSipLinkMaxQueueLength(), 32000);
        }

        public String getError() {
            if (System.currentTimeMillis() > this.timeout) {
                return "write task is stale";
            }
            return null;
        }
    }
}

