/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.container.StreamResponseDispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipParser;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.sun.grizzly.Context;
import com.sun.grizzly.Controller;
import com.sun.grizzly.DefaultPipeline;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.ByteBufferInputStream;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageProcessorFilter
implements ProtocolFilter,
Callable {
    private static final Logger logger = Logger.getLogger("SipContainer");
    private static final DefaultPipeline highPriorityThreadPool = new DefaultPipeline(10, 10, "SipListenerPriority", 0);
    private static boolean usePriorityQueue = System.getProperty("sip.network.grizzly.highPriorityThreadPool") != null;
    private final Layer _networkHandler;

    public MessageProcessorFilter(Layer layer) {
        this._networkHandler = layer;
        if (usePriorityQueue) {
            highPriorityThreadPool.setQueueSizeInBytes(-1);
            highPriorityThreadPool.initPipeline();
            highPriorityThreadPool.startPipeline();
        }
    }

    public boolean execute(Context ctx) throws IOException {
        SipServletMessageImpl parsedMessage = null;
        Socket s = null;
        InetSocketAddress remoteAddress = null;
        SipServletMessageImpl _message = null;
        WorkerThread workerThread = (WorkerThread)Thread.currentThread();
        ByteBuffer buffer = workerThread.getByteBuffer();
        SipParser _parser = SipParser.getInstance();
        Controller.Protocol prot = ctx.getProtocol();
        final SelectionKey key = ctx.getSelectionKey();
        final SelectorHandler handler = ctx.getController().getSelectorHandler(prot);
        TargetTuple remote = null;
        InetSocketAddress local = null;
        X509Certificate[] x509Certs = null;
        switch (prot) {
            case TCP: {
                s = ((SocketChannel)key.channel()).socket();
                remoteAddress = (InetSocketAddress)s.getRemoteSocketAddress();
                remote = new TargetTuple(SipTransports.TCP_PROT, remoteAddress);
                local = (InetSocketAddress)s.getLocalSocketAddress();
                break;
            }
            case UDP: {
                DatagramSocket d = ((DatagramChannel)key.channel()).socket();
                remoteAddress = (InetSocketAddress)ctx.getAttribute("socketAddress");
                remote = new TargetTuple(SipTransports.UDP_PROT, remoteAddress);
                local = (InetSocketAddress)d.getLocalSocketAddress();
                break;
            }
            case TLS: {
                s = ((SocketChannel)key.channel()).socket();
                remoteAddress = (InetSocketAddress)s.getRemoteSocketAddress();
                remote = new TargetTuple(SipTransports.TLS_PROT, remoteAddress);
                local = (InetSocketAddress)s.getLocalSocketAddress();
                Object[] certs = (Object[])ctx.removeAttribute("Sip.Certs");
                if (certs == null || certs.length <= 0) break;
                ArrayList<X509Certificate> al = new ArrayList<X509Certificate>();
                for (int i = 0; i < certs.length; ++i) {
                    if (certs[i] instanceof X509Certificate) {
                        al.add((X509Certificate)certs[i]);
                        continue;
                    }
                    logger.warning("Certificate provided by TLS implementation is not of type X509. " + certs[i].getClass());
                }
                x509Certs = al.toArray(new X509Certificate[al.size()]);
            }
        }
        try {
            int initialSize = 0;
            buffer.flip();
            int remaining = buffer.remaining();
            while (remaining > 0 && initialSize != remaining || parsedMessage == null) {
                initialSize = remaining;
                parsedMessage = _parser.parseMessage(_message, buffer, local, remote, null);
                remaining = buffer.remaining();
                if (parsedMessage != null && parsedMessage.isMessageComplete() && remaining > 0) {
                    final SipServletMessageImpl msg = parsedMessage;
                    msg.setCertificate(x509Certs);
                    parsedMessage = null;
                    _message = null;
                    if (usePriorityQueue) {
                        highPriorityThreadPool.execute(new Callable(){

                            public Object call() {
                                MessageProcessorFilter.this.processMessage(msg, key, handler);
                                return null;
                            }
                        });
                        continue;
                    }
                    SipContainerThreadPool.getInstance().execute(new Runnable(){

                        public void run() {
                            MessageProcessorFilter.this.processMessage(msg, key, handler);
                        }
                    });
                    continue;
                }
                if (parsedMessage != null && parsedMessage.isMessageComplete()) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The parsed request is not complete - reading more! (" + buffer.position() + ')');
                }
                if (buffer.hasRemaining()) {
                    buffer.compact();
                } else {
                    buffer.clear();
                }
                ByteBufferInputStream inputStream = new ByteBufferInputStream();
                inputStream.setSecure(prot == Controller.Protocol.TLS);
                inputStream.setSelectionKey(ctx.getSelectionKey());
                int nRead = inputStream.read(buffer);
                if (nRead <= 0) {
                    logger.severe("Unable to read more bytes after 30 seconds pause. Closing the connection.");
                    ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
                    return false;
                }
                remaining = buffer.remaining();
                _message = parsedMessage;
            }
            buffer.clear();
            _message = null;
        }
        catch (Throwable t) {
            if (t instanceof Exception) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Exception processing request " + t.getMessage(), t);
                }
            } else {
                logger.log(Level.SEVERE, "Caught Throwable: ", t);
            }
            buffer.clear();
            ctx.setKeyRegistrationState(Context.KeyRegistrationState.CANCEL);
            return false;
        }
        this.processMessage(parsedMessage, key, handler);
        return true;
    }

    public boolean postExecute(Context context) throws IOException {
        return true;
    }

    protected void processMessage(SipServletMessageImpl message, SelectionKey key, SelectorHandler handler) {
        if (message.getMessageType() == SipServletMessageImpl.SipMessageType.SipRequest) {
            SipServletRequestImpl req = (SipServletRequestImpl)message;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Network IN request " + req.getMethod() + " --> \r\n" + req.toString());
            }
            if (this.hasBodyWithoutContentType(message)) {
                return;
            }
            if (req.getRemote().getProtocol().ordinal() == 2 || req.getRemote().getProtocol().ordinal() == 3) {
                SocketChannel channel = (SocketChannel)key.channel();
                StreamResponseDispatcher rd = new StreamResponseDispatcher(handler, channel, this._networkHandler);
                req.pushTransactionDispatcher(rd);
            } else {
                req.pushTransactionDispatcher(this._networkHandler);
            }
            req.pushApplicationDispatcher(this._networkHandler);
            this._networkHandler.next(req);
        } else {
            SipServletResponseImpl resp = (SipServletResponseImpl)message;
            Header cseq = resp.getRawHeader("Cseq");
            String c = cseq.getValue();
            int index = c.indexOf(32);
            resp.setMethod(c.substring(index + 1));
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Network IN response " + resp.getStatus() + " " + resp.getMethod() + " --> \r\n" + resp.toString());
            }
            this._networkHandler.next(resp);
        }
    }

    public boolean hasBodyWithoutContentType(SipServletMessageImpl message) {
        if (message.hasBody() && message.getContentType() == null) {
            block8: {
                try {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Missing Content-Type header field, the request has a body.");
                    }
                    SipServletRequestImpl req = (SipServletRequestImpl)message;
                    String phraze = "Missing Content-Type header field";
                    SipServletResponseImpl resp = req.createTerminatingResponse(400, phraze);
                    while (resp.popDispatcher() != null) {
                    }
                    TargetResolver tr = TargetResolver.getInstance();
                    TargetTuple tt = tr.resolveResponse(resp);
                    if (tt != null) {
                        resp.setRemote(tt);
                        this._networkHandler.dispatch(resp);
                    } else if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "failed to find out where to send error response");
                    }
                }
                catch (Exception ignore) {
                    if (!logger.isLoggable(Level.FINE)) break block8;
                    logger.log(Level.FINE, "unexpected exception: " + ignore);
                }
            }
            return true;
        }
        return false;
    }

    public Object call() throws Exception {
        return null;
    }
}

