/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.event.ConfigAddEvent;
import com.ericsson.ssa.config.event.ConfigChangeListener;
import com.ericsson.ssa.config.event.ConfigRemoveEvent;
import com.ericsson.ssa.config.event.ConfigUpdateEvent;
import com.ericsson.ssa.config.lease.Lease;
import com.ericsson.ssa.config.lease.LeaseGranter;
import com.ericsson.ssa.container.SipBindingListener;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipBindingResolver
extends LeaseGranter<TargetTuple[]> {
    private static final SipBindingResolver INSTANCE = new SipBindingResolver();
    private static final String CTX_PARENT = "/SipService/SipListener";
    private static final String CTX_PARENT_REGEXP = "/SipService/SipListener";
    private static final String CTX_REGEXP = "/SipService/SipListener/([^/]+)";
    private static final String SIP_CONTAINER = "/SipContainer";
    public static final String PUBLIC_BINDING_CTX = "PUBLIC_BINDING_CTX";
    private String m_LanAddress = null;
    private Config config = ConfigFactory.getConfig();
    private Logger logger = Logger.getLogger("SipContainer");
    private ParentCtxChangeListener parentCtxListener = new ParentCtxChangeListener();
    private Map<String, TargetTuple[]> contexts = new HashMap<String, TargetTuple[]>();
    private Map<String, CtxChangeListener> ctxListeners = new HashMap<String, CtxChangeListener>();
    private Map<String, List<Lease<TargetTuple[]>>> leases = new HashMap<String, List<Lease<TargetTuple[]>>>();
    private List<SipBindingListener> sipBindingListeners = new ArrayList<SipBindingListener>();

    public static SipBindingResolver instance() {
        return INSTANCE;
    }

    public void init() {
        ConfigFactory.instance().registerConfigChangeListener(CTX_REGEXP, this.parentCtxListener);
        for (String childName : this.config.getChildNames("/SipService/SipListener")) {
            String ctx = this.getCtxForName(childName);
            this.contexts.put(ctx, this.resolveLocalTargetTuples(ctx));
        }
        this.contexts.put(PUBLIC_BINDING_CTX, this.resolvePublicTargetTuples());
    }

    public String[] getLocalContexts() {
        ArrayList<String> ctxs = new ArrayList<String>(this.contexts.keySet());
        ctxs.remove(PUBLIC_BINDING_CTX);
        return ctxs.toArray(new String[ctxs.size()]);
    }

    public Lease<TargetTuple[]> lease(String ctx) {
        Lease<TargetTuple[]> lease = null;
        TargetTuple[] tuples = this.contexts.get(ctx);
        if (tuples != null) {
            lease = new Lease<TargetTuple[]>(tuples, ctx, this);
            if (this.leases.containsKey(ctx)) {
                this.leases.get(ctx).add(lease);
            } else {
                ArrayList<Lease<TargetTuple[]>> leasesOfCtx = new ArrayList<Lease<TargetTuple[]>>();
                leasesOfCtx.add(lease);
                this.leases.put(ctx, leasesOfCtx);
            }
        }
        return lease;
    }

    @Override
    public boolean renew(Lease<TargetTuple[]> lease) {
        return this.leases.containsKey(lease.getLeaseCtx()) && this.leases.get(lease.getLeaseCtx()).contains(lease);
    }

    @Override
    public void cancel(Lease<TargetTuple[]> lease) {
        if (this.leases.containsKey(lease.getLeaseCtx())) {
            this.leases.get(lease.getLeaseCtx()).remove(lease);
        }
    }

    public void registerSipBindingListener(SipBindingListener listener) {
        this.sipBindingListeners.add(listener);
    }

    public void deregisterSipBindingListener(SipBindingListener listener) {
        this.sipBindingListeners.remove(listener);
    }

    private void processNewSipBindingAvalable(String context) {
        for (SipBindingListener listener : this.sipBindingListeners) {
            listener.newSipBindingAvaliable(context);
        }
    }

    private String getCtxForName(String name) {
        return "/SipService/SipListener/" + name;
    }

    private String getCtxRegExp(String ctx) {
        return ctx;
    }

    private TargetTuple[] resolveLocalTargetTuples(String ctx) {
        String address = this.resolveLocalAddress(this.config.get(ctx, "Address"));
        int port = this.resolveLocalPort(this.config.get(ctx, "Port"));
        String transport = this.config.get(ctx, "Transport");
        ArrayList<SipTransports> transports = new ArrayList<SipTransports>();
        for (String prot : transport.split("_")) {
            try {
                transports.add(SipTransports.getTransport(prot));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }
        TargetTuple[] targetTuples = new TargetTuple[transports.size()];
        int i = 0;
        for (SipTransports st : transports) {
            targetTuples[i++] = new TargetTuple(st, address, port);
        }
        return targetTuples;
    }

    private String resolveLocalAddress(String anLocalAddress) {
        String address = anLocalAddress != null && anLocalAddress.length() > 0 ? anLocalAddress : "0.0.0.0";
        return address;
    }

    private int resolveLocalPort(String aLocalPort) {
        int port = aLocalPort != null && aLocalPort.length() > 0 ? Integer.parseInt(aLocalPort) : Integer.parseInt("5060");
        return port;
    }

    private TargetTuple[] resolvePublicTargetTuples() {
        String address = this.resolvePublicAddress(this.config.get(SIP_CONTAINER, "ExtenalAddress"));
        int port = this.resolvePublicPort(this.config.get(SIP_CONTAINER, "Port"));
        TargetTuple[] targetTuples = new TargetTuple[]{new TargetTuple(SipTransports.UNDEFINED_PROT, address, port)};
        return targetTuples;
    }

    private String resolvePublicAddress(String anPublicAddress) {
        String address = anPublicAddress != null && anPublicAddress.length() > 0 ? anPublicAddress : this.getLanAddress();
        return address;
    }

    private int resolvePublicPort(String aPublicPort) {
        int port = aPublicPort != null && aPublicPort.length() > 0 ? Integer.parseInt(aPublicPort) : Integer.parseInt("5060");
        return port;
    }

    private String getLanAddress() {
        if (this.m_LanAddress != null) {
            return this.m_LanAddress;
        }
        String lanAddress = "";
        String preferedPrefix = "172.";
        String avoidedPrefix = "127.";
        String avoidedInterfacenamePrefix = "i4dd";
        String me = "getLanAddress(): ";
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, me + "try to find a configured IP address of a physical network interface");
        }
        int score = 0;
        Enumeration<NetworkInterface> nifs = null;
        try {
            nifs = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            this.logger.log(Level.SEVERE, me + "SocketException when trying to get our network interfaces", se);
        }
        if (nifs != null) {
            while (nifs.hasMoreElements()) {
                NetworkInterface nif = nifs.nextElement();
                String ifName = nif.getName();
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, me + "found interface: " + ifName);
                }
                int addrCount = 0;
                Enumeration<InetAddress> addrs = nif.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    int newscore;
                    String addrString;
                    InetAddress addr = addrs.nextElement();
                    ++addrCount;
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.log(Level.FINE, me + "found address " + addr + " for interface " + ifName);
                    }
                    if ((addrString = addr.getHostAddress()).startsWith(preferedPrefix)) {
                        newscore = 40;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!this.logger.isLoggable(Level.FINE)) continue;
                            this.logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (addrString.startsWith(avoidedPrefix)) {
                        newscore = 10;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!this.logger.isLoggable(Level.FINE)) continue;
                            this.logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (ifName.startsWith(avoidedInterfacenamePrefix)) {
                        newscore = 20;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!this.logger.isLoggable(Level.FINE)) continue;
                            this.logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    if (addrString.indexOf(":") >= 0) {
                        newscore = 25;
                        if (score < newscore) {
                            lanAddress = addrString;
                            score = newscore;
                            if (!this.logger.isLoggable(Level.FINE)) continue;
                            this.logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                            continue;
                        }
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                        continue;
                    }
                    newscore = 30;
                    if (score < newscore) {
                        lanAddress = addrString;
                        score = newscore;
                        if (!this.logger.isLoggable(Level.FINE)) continue;
                        this.logger.log(Level.FINE, me + "score: " + newscore + ", best so far");
                        continue;
                    }
                    if (!this.logger.isLoggable(Level.FINE)) continue;
                    this.logger.log(Level.FINE, me + "score: " + newscore + ", ignored");
                }
                if (addrCount < 1) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.log(Level.INFO, me + "found no configured IP addresses for interface " + ifName);
                    continue;
                }
                if (addrCount <= 1 || !this.logger.isLoggable(Level.INFO)) continue;
                this.logger.log(Level.INFO, me + "found " + addrCount + " configured IP addresses for interface " + ifName);
            }
        }
        if (lanAddress == null) {
            this.logger.log(Level.SEVERE, me + "no interface with a configured IP address found, using 0.0.0.0");
            lanAddress = "0.0.0.0";
        } else if (score < 30) {
            this.logger.log(Level.WARNING, me + "only found unsuitable IP addresses; using " + lanAddress + " in lack of better");
        }
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "parameter <LanAddress>: using " + (score > 30 ? "preferred " : "") + "value '" + lanAddress + "'");
        }
        this.m_LanAddress = lanAddress;
        return lanAddress;
    }

    public String reportBindings() {
        StringBuffer buf = new StringBuffer("SipBindings: ");
        for (Map.Entry<String, TargetTuple[]> entries : this.contexts.entrySet()) {
            buf.append("context: '");
            buf.append(entries.getKey());
            buf.append("'.\n");
            for (TargetTuple tuple : entries.getValue()) {
                buf.append(tuple);
            }
        }
        return buf.toString();
    }

    class CtxChangeListener
    implements ConfigChangeListener {
        CtxChangeListener() {
        }

        public void handleConfigEvent(ConfigAddEvent event) {
        }

        public void handleConfigEvent(ConfigUpdateEvent event) {
            SipBindingResolver.this.contexts.put(event.getNode(), SipBindingResolver.this.resolveLocalTargetTuples(event.getNode()));
            List leasesOfCtx = (List)SipBindingResolver.this.leases.remove(event.getNode());
            if (leasesOfCtx != null) {
                for (Lease lease : leasesOfCtx) {
                    lease.cancel();
                }
            }
        }

        public void handleConfigEvent(ConfigRemoveEvent event) {
        }
    }

    class ParentCtxChangeListener
    implements ConfigChangeListener {
        ParentCtxChangeListener() {
        }

        public void handleConfigEvent(ConfigAddEvent event) {
            SipBindingResolver.this.contexts.put(event.getNode(), SipBindingResolver.this.resolveLocalTargetTuples(event.getNode()));
            CtxChangeListener listener = new CtxChangeListener();
            SipBindingResolver.this.ctxListeners.put(event.getNode(), listener);
            ConfigFactory.instance().registerConfigChangeListener(SipBindingResolver.this.getCtxRegExp(event.getNode()), listener);
            SipBindingResolver.this.processNewSipBindingAvalable(event.getNode());
        }

        public void handleConfigEvent(ConfigUpdateEvent event) {
        }

        public void handleConfigEvent(ConfigRemoveEvent event) {
            CtxChangeListener listener;
            List leasesOfCtx = (List)SipBindingResolver.this.leases.remove(event.getNode());
            TargetTuple[] tuples = (TargetTuple[])SipBindingResolver.this.contexts.remove(event.getNode());
            if (leasesOfCtx != null) {
                for (Lease lease : leasesOfCtx) {
                    lease.cancel();
                }
            }
            if ((listener = (CtxChangeListener)SipBindingResolver.this.ctxListeners.remove(event.getNode())) != null) {
                ConfigFactory.instance().deregisterConfigChangeListener(listener);
            }
        }
    }
}

