/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.container.LinkBase;
import com.ericsson.ssa.container.SipParserErrorHandler;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetResolver;
import com.ericsson.ssa.sip.dns.TargetTuple;

public class SipParserErrorHandlerImpl
extends SipParserErrorHandler {
    public SipParserErrorHandlerImpl(LinkBase base) {
        super(base);
    }

    public void handleError(SipServletRequestImpl req, int code, String errorStr) {
        if (this.getErrorResponseEnabled()) {
            req.pushTransactionDispatcher(this.getMyDispatcher());
            SipServletResponseImpl resp = req.createResponseImpl(code, errorStr);
            if (resp.getHeader("To") != null && resp.getTo() != null && resp.getTo().getParameter("tag") == null) {
                resp.createTag("To");
            }
            try {
                TargetResolver tr = TargetResolver.getInstance();
                TargetTuple tt = tr.resolveResponse(resp);
                resp.setRemote(tt);
            }
            catch (Exception e) {
                e.printStackTrace();
                resp.setRemote(req.getRemote());
            }
            resp.popDispatcher().dispatch(resp);
        }
    }
}

