/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.sun.grizzly.Controller;
import com.sun.grizzly.SelectorHandler;
import com.sun.grizzly.util.OutputWriter;
import com.sun.grizzly.util.SSLOutputWriter;
import com.sun.grizzly.util.ThreadAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StreamResponseDispatcher
implements Dispatcher {
    private final SelectorHandler streamHandler;
    private final SocketChannel socketChannel;
    private final Layer backup;
    private Logger logger = Logger.getLogger("SipContainer");
    ThreadAttachment currentTA = null;

    public StreamResponseDispatcher(SelectorHandler handler, SocketChannel channel, Layer failback) {
        this.streamHandler = handler;
        this.socketChannel = channel;
        this.backup = failback;
        if (handler.protocol() == Controller.Protocol.TLS) {
            this.currentTA = ((WorkerThread)Thread.currentThread()).detach(true);
        }
    }

    public void dispatch(SipServletRequestImpl req) {
        throw new IllegalStateException("Not designed for connection reuse!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(SipServletResponseImpl resp) {
        try {
            if (this.streamHandler.protocol() == Controller.Protocol.TCP) {
                OutputWriter.flushChannel((SelectableChannel)this.socketChannel, (ByteBuffer)((ByteBuffer)resp.toBuffer().flip()));
            } else if (this.streamHandler.protocol() == Controller.Protocol.TLS) {
                ((WorkerThread)Thread.currentThread()).attach(this.currentTA);
                ThreadAttachment threadAttachment = this.currentTA;
                synchronized (threadAttachment) {
                    SSLOutputWriter.flushChannel((SelectableChannel)this.socketChannel, (ByteBuffer)((ByteBuffer)resp.toBuffer().flip()));
                }
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Sent response OUT :\n" + resp.toString());
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Failed to reuse connection for response", e);
            }
            this.backup.dispatch(resp);
        }
    }
}

