/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.Link;
import com.ericsson.ssa.container.LinkBase;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.container.processor.QueuedTask;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPLink
extends LinkBase
implements Link {
    private Logger _log = Logger.getLogger("SipContainer");
    private final TargetTuple _targetTuple;
    private SocketChannel _socketChannel = null;
    private InetSocketAddress _local = null;
    private ReentrantLock _linkMutex = new ReentrantLock();
    private boolean _isOpen = false;
    private ConnectType _connectType;
    private AtomicBoolean isClosing = new AtomicBoolean();
    private AtomicBoolean isOpening = new AtomicBoolean();
    private Config _config = ConfigFactory.getConfig();

    public TCPLink(TargetTuple t, OLDNetworkManager n, Layer l) throws IOException {
        super(n, l, true);
        InetAddress ia = InetAddress.getByName(this._config.get("HOST"));
        InetSocketAddress localBind = new InetSocketAddress(ia, 0);
        this._socketChannel = SocketChannel.open();
        this._socketChannel.configureBlocking(false);
        this._socketChannel.socket().bind(localBind);
        this._socketChannel.connect(new InetSocketAddress(t.getIP(), t.getPort()));
        this._local = (InetSocketAddress)this._socketChannel.socket().getLocalSocketAddress();
        this._targetTuple = t;
        this.setConnectionType(ConnectType.CONNECT_REUSE);
        this.init();
    }

    public TCPLink(SocketChannel channel, OLDNetworkManager n, Layer l, boolean acceptRegister) throws IOException {
        super(n, l, true);
        this._socketChannel = channel;
        this._local = (InetSocketAddress)this._socketChannel.socket().getLocalSocketAddress();
        this._targetTuple = new TargetTuple(SipTransports.TCP_PROT, (InetSocketAddress)this._socketChannel.socket().getRemoteSocketAddress());
        this._socketChannel.configureBlocking(false);
        this.init();
        this._socketChannel.register(this._networkManager.getSelector(), 1, this);
        if (acceptRegister) {
            this.setConnectionType(ConnectType.ACCEPT_REGISTER);
            this._networkManager.addAcceptedConnection(this);
        } else {
            this.setConnectionType(ConnectType.ACCEPT_UNREGISTER);
        }
        this.setOpen(true);
    }

    private ConnectType getConnectionType() {
        return this._connectType;
    }

    private void setConnectionType(ConnectType type) {
        this._connectType = type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect() throws IOException {
        int selectRetries;
        Selector connectSel = Selector.open();
        this._socketChannel.register(connectSel, 8);
        long waitTime = this._networkManager.getSipLinkTimeout();
        try {
            int sel;
            for (selectRetries = this._networkManager.getSipLinkTimeoutRetries(); selectRetries > 0 && (sel = connectSel.select(waitTime)) < 1; --selectRetries) {
                if (sel >= 0) continue;
                this._log.log(Level.SEVERE, "connect error (select failed after " + selectRetries + ". , socketChannel=" + this._socketChannel.toString());
                throw new IOException("connect error (select failed after " + (this._networkManager.getSipLinkTimeout() - selectRetries) + " retries, socketChannel=" + this._socketChannel.toString());
            }
        }
        finally {
            connectSel.close();
        }
        if (selectRetries <= 0) {
            throw new IOException("Unable to connect to " + this._targetTuple);
        }
        this._socketChannel.finishConnect();
    }

    private void setOpen(boolean isOpen) {
        this._isOpen = isOpen;
    }

    public synchronized boolean isOpen() {
        return this._socketChannel != null ? this._isOpen : false;
    }

    public void open() throws IOException {
        if (this.getConnectionType() != ConnectType.CONNECT_REUSE) {
            throw new IOException("Not allowed to open link, must use connect constructor " + this.getInfo());
        }
        if (this._socketChannel == null) {
            throw new IOException("Connection is closed to " + this.getInfo());
        }
        if (this.isOpening.getAndSet(true)) {
            return;
        }
        this.putTask(new OpenTask());
    }

    private void init() {
        int size;
        try {
            size = this._socketChannel.socket().getReceiveBufferSize();
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "SO_RCVBUF size = " + size);
            }
            this._readBuffer = ByteBuffer.allocate(size);
        }
        catch (SocketException ignore) {
            this._readBuffer = ByteBuffer.allocate(4096);
        }
        try {
            size = this._socketChannel.socket().getSendBufferSize();
            if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "SO_SNDBUF size = " + size);
            }
            this._writeBuffer = ByteBuffer.allocate(size);
        }
        catch (SocketException ignore) {
            this._writeBuffer = ByteBuffer.allocate(4096);
        }
    }

    public TargetTuple getTargetTuple() {
        return this._targetTuple;
    }

    public String getTransport() {
        return this._targetTuple.getProtocol().name();
    }

    protected void closeImpl() {
        if (this.isClosing.getAndSet(true)) {
            return;
        }
        this._threadPool.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TCPLink.this._socketChannel != null) {
                    TCPLink.this._linkMutex.lock();
                    try {
                        if (TCPLink.this._socketChannel != null) {
                            TCPLink.this.doClose();
                        } else if (TCPLink.this._log.isLoggable(Level.INFO)) {
                            TCPLink.this._log.log(Level.INFO, "Tried to remove a closed link " + TCPLink.this.getInfo());
                        }
                    }
                    finally {
                        TCPLink.this._linkMutex.unlock();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        try {
            block12: {
                if (!this._socketChannel.socket().isOutputShutdown()) {
                    try {
                        this._socketChannel.socket().shutdownOutput();
                    }
                    catch (IOException e) {
                        if (!this._log.isLoggable(Level.INFO)) break block12;
                        this._log.log(Level.INFO, "Failed to graceful shutdown link " + this.getInfo());
                    }
                }
            }
            this._socketChannel.close();
        }
        catch (Throwable ignore) {
            if (this._log.isLoggable(Level.INFO)) {
                this._log.log(Level.INFO, "Failed to close link " + this.getInfo());
            }
        }
        finally {
            this.setOpen(false);
            this._socketChannel = null;
            if (this.getConnectionType() == ConnectType.CONNECT_REUSE) {
                this._networkManager.removeActiveConnection(this);
            } else if (this.getConnectionType() == ConnectType.ACCEPT_REGISTER) {
                this._networkManager.removeAcceptedConnection(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = -1;
        this._readMutex.lock();
        try {
            if (this._socketChannel != null) {
                n = this._socketChannel.read(this._readBuffer);
                if (this._log.isLoggable(Level.FINE)) {
                    this._log.log(Level.FINE, "Read == " + n);
                }
            } else if (this._log.isLoggable(Level.FINE)) {
                this._log.log(Level.FINE, "Link is closed " + this.getInfo());
            }
        }
        catch (IOException ioe) {
            if (this._log.isLoggable(Level.INFO)) {
                this._log.log(Level.INFO, "Got IOException for link: " + this.getInfo() + ", " + ioe + ":" + ioe.getMessage());
            }
        }
        catch (Throwable t) {
            this._log.log(Level.SEVERE, "Caught Throwable for socketChannel " + this.getTargetTuple() + ": ", t);
        }
        finally {
            if (n <= 0) {
                if (n < 0) {
                    this.closeImpl();
                }
                this._networkManager.releaseSelectorSemaphore();
                this._readMutex.unlock();
            }
        }
        if (n > 0) {
            this._readBuffer.flip();
            this._networkManager.releaseSelectorSemaphore();
            this.handleMessage(this._readBuffer, this.getLocal(), new TargetTuple(SipTransports.TCP_PROT, this.getRemote()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InetSocketAddress remote, ByteBuffer message) throws IOException {
        if (this._socketChannel == null) {
            throw new IOException("Link is closed " + this.getInfo());
        }
        while (message.hasRemaining()) {
            if (this._socketChannel.write(message) != 0) continue;
            Selector writeSel = Selector.open();
            this._socketChannel.register(writeSel, 4);
            int selectRetries = 0;
            long waitTime = this._networkManager.getSipLinkTimeout();
            try {
                int sel;
                while ((sel = writeSel.select(waitTime)) < 1) {
                    ++selectRetries;
                    int left = message.remaining();
                    if (sel < 0) {
                        String info = this._socketChannel.toString();
                        this._log.log(Level.SEVERE, "select failed (" + selectRetries + "), socketChannel=" + info + ", discarding buffer (" + left + " bytes) ...");
                        this.close();
                        message.clear();
                        throw new IOException("write error (select failed after " + selectRetries + " retries, socketChannel=" + info + ", discarding buffer (" + left + " bytes).");
                    }
                    if (selectRetries == this._networkManager.getSipLinkTimeoutRetries()) {
                        String info = this._socketChannel.toString();
                        this.close();
                        message.clear();
                        throw new IOException("write error (max " + this._networkManager.getSipLinkTimeoutRetries() + " select retries reached, socketChannel=" + info + ", discarding buffer (" + left + " bytes).");
                    }
                    if (!this._log.isLoggable(Level.FINE)) continue;
                    this._log.log(Level.FINE, "selected (" + selectRetries + "), socketChannel=" + this._socketChannel.toString() + ", buffer (" + left + " bytes) ...");
                }
            }
            finally {
                writeSel.close();
            }
        }
    }

    public InetSocketAddress getLocal() {
        return this._local;
    }

    public InetSocketAddress getRemote() {
        return this._targetTuple.getSocketAddress();
    }

    public SelectableChannel getSelectableChannel() {
        return this._socketChannel;
    }

    public void dispatch(final SipServletResponseImpl resp) {
        this.putTask(new QueuedTask(){

            public void doErrorAction(String cause) {
            }

            public String getError() {
                return null;
            }

            public void run() {
                if (!TCPLink.this.isOpen()) {
                    if (TCPLink.this.getRemote().equals(resp.getRemote().getSocketAddress())) {
                        if (TCPLink.this._log.isLoggable(Level.INFO)) {
                            TCPLink.this._log.log(Level.INFO, "Unfortunately the 'received' parameter has already been established once and failed. Drop response " + resp.toString());
                        }
                        return;
                    }
                    if (TCPLink.this._log.isLoggable(Level.INFO)) {
                        TCPLink.this._log.log(Level.INFO, "Try 'received' parameter since link is not open to " + TCPLink.this.getInfo() + " for response " + resp.toString());
                    }
                    resp.pushTransactionDispatcher(TCPLink.this._networkManager);
                }
                TCPLink.super.dispatch(resp);
            }
        });
    }

    public String getInfo() {
        StringBuilder sb = new StringBuilder("[ip: ");
        sb.append(this.getTargetTuple().getIP());
        sb.append(":");
        sb.append(this.getTargetTuple().getPort());
        sb.append("/");
        sb.append(this.getTargetTuple().getProtocol().name());
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConnectType {
        CONNECT_REUSE,
        ACCEPT_REGISTER,
        ACCEPT_UNREGISTER;

    }

    private final class OpenTask
    implements QueuedTask {
        private OpenTask() {
        }

        public void doErrorAction(String cause) {
        }

        public String getError() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            TCPLink.this._linkMutex.lock();
            try {
                if (TCPLink.this._socketChannel == null) {
                    if (TCPLink.this._log.isLoggable(Level.FINE)) {
                        TCPLink.this._log.log(Level.FINE, "Connection is closed to " + TCPLink.this.getInfo() + " shutting down write processor for link");
                    }
                    TCPLink.this.shutdownWriteProcessor();
                }
                if (!TCPLink.this._socketChannel.isConnected()) {
                    if (TCPLink.this._socketChannel.isConnectionPending()) {
                        try {
                            TCPLink.this.finishConnect();
                            TCPLink.this.init();
                            TCPLink.this._networkManager.registerConnection(TCPLink.this);
                            TCPLink.this.setOpen(true);
                            TCPLink.this._networkManager.getSelector().wakeup();
                        }
                        catch (IOException e) {
                            TCPLink.this.doClose();
                            if (TCPLink.this._log.isLoggable(Level.FINE)) {
                                TCPLink.this._log.log(Level.FINE, "Failed to connect " + TCPLink.this.getInfo() + " exception: " + e + " shutting down write processor for link");
                            }
                            TCPLink.this.shutdownWriteProcessor();
                        }
                        catch (Throwable t) {
                            TCPLink.this.doClose();
                            if (TCPLink.this._log.isLoggable(Level.FINE)) {
                                TCPLink.this._log.log(Level.FINE, "Failed to connect " + TCPLink.this.getInfo() + " exception: " + t + " shutting down write processor for link");
                            }
                            TCPLink.this.shutdownWriteProcessor();
                        }
                    } else {
                        if (TCPLink.this._log.isLoggable(Level.INFO)) {
                            TCPLink.this._log.log(Level.INFO, "Lets close connection " + TCPLink.this._targetTuple + " since state is undefined [isConnected()=" + TCPLink.this._socketChannel.isConnected() + ", isConnectionPending()=" + TCPLink.this._socketChannel.isConnectionPending() + ", isOpen() " + TCPLink.this._socketChannel.isOpen() + ", isBlocking() " + TCPLink.this._socketChannel.isBlocking() + ", isRegistered() " + TCPLink.this._socketChannel.isRegistered() + "]. ");
                        }
                        TCPLink.this.doClose();
                        TCPLink.this.shutdownWriteProcessor();
                    }
                }
            }
            finally {
                TCPLink.this._linkMutex.unlock();
            }
        }
    }
}

