/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.container.Link;
import com.ericsson.ssa.container.LinkBase;
import com.ericsson.ssa.container.OLDNetworkManager;
import com.ericsson.ssa.container.TCPLink;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPListener
extends LinkBase
implements Link {
    private static final String TRANSPORT_TCP = "TCP";
    private Logger _log = Logger.getLogger("SipContainer");
    private ServerSocketChannel _serverSocketChannel = null;
    private int _port = -1;
    private final boolean _acceptRegister;
    private Config _config = ConfigFactory.getConfig();

    public TCPListener(int port, OLDNetworkManager n, Layer l, boolean acceptRegister) {
        super(n, l);
        this._port = port;
        this._acceptRegister = acceptRegister;
    }

    private boolean isAcceptRegister() {
        return this._acceptRegister;
    }

    public String getTransport() {
        return TRANSPORT_TCP;
    }

    public TargetTuple getTargetTuple() {
        return null;
    }

    public boolean isOpen() {
        return this._serverSocketChannel != null ? this._serverSocketChannel.isOpen() : false;
    }

    public void open() throws IOException {
        this._serverSocketChannel = ServerSocketChannel.open();
        this._serverSocketChannel.configureBlocking(false);
        InetAddress ia = InetAddress.getByName(this._config.get("HOST"));
        this._serverSocketChannel.socket().bind(new InetSocketAddress(ia, this._port));
        this._serverSocketChannel.register(this._networkManager.getSelector(), 16, this);
        this._networkManager.getSelector().wakeup();
        if (this._log.isLoggable(Level.FINE)) {
            this._log.log(Level.FINE, "Opening " + ia + ":" + this._port);
        }
    }

    protected void closeImpl() throws IOException {
        this._serverSocketChannel.close();
    }

    public void run() {
        block2: {
            try {
                SocketChannel newChannel = this._serverSocketChannel.accept();
                new TCPLink(newChannel, this._networkManager, this._nextLayer, this.isAcceptRegister());
            }
            catch (IOException ioe) {
                if (!this._log.isLoggable(Level.FINE)) break block2;
                this._log.log(Level.FINE, "", ioe);
            }
        }
    }

    public void dispatch(SipServletRequestImpl req) {
    }

    public void dispatch(SipServletResponseImpl resp) {
    }

    public InetSocketAddress getLocal() {
        return (InetSocketAddress)this._serverSocketChannel.socket().getLocalSocketAddress();
    }

    public InetSocketAddress getRemote() {
        return null;
    }

    public SelectableChannel getSelectableChannel() {
        return this._serverSocketChannel;
    }

    public void write(InetSocketAddress remote, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Can't write to a TCP listener socket!");
    }

    public String getInfo() {
        return this.getClass().getName();
    }
}

