/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.ExpandWar;

public class HostDeployer {
    StandardHost host;

    public HostDeployer(StandardHost host) {
        this.host = host;
    }

    public synchronized void install(String contextPath, URL war) throws IOException {
        String url = war.toString();
        String docBase = null;
        boolean isWAR = false;
        if (url.startsWith("jar:")) {
            if (!(url = url.substring(4, url.length() - 2)).toLowerCase().endsWith(".war") && !url.toLowerCase().endsWith(".sar")) {
                throw new IllegalArgumentException();
            }
            isWAR = true;
        }
        if (url.startsWith("file://")) {
            docBase = url.substring(7);
        } else if (url.startsWith("file:")) {
            docBase = url.substring(5);
        } else {
            throw new IllegalArgumentException();
        }
        boolean isAppBase = false;
        File appBase = new File(this.host.getAppBase());
        if (!appBase.isAbsolute()) {
            appBase = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        File contextFile = new File(docBase);
        File baseDir = contextFile.getParentFile();
        if (appBase.getCanonicalPath().equals(baseDir.getCanonicalPath())) {
            isAppBase = true;
        }
        if (isWAR && this.host.isUnpackWARs()) {
            docBase = contextPath.equals("") ? ExpandWar.expand((Host)this.host, (URL)war, (String)"/ROOT") : ExpandWar.expand((Host)this.host, (URL)war, (String)contextPath);
        }
        try {
            Class<?> clazz = Class.forName(this.host.getContextClass());
            Context context = (Context)clazz.newInstance();
            context.setPath(contextPath);
            context.setDocBase(docBase);
            if (context instanceof Lifecycle) {
                clazz = Class.forName(this.host.getConfigClass());
                LifecycleListener listener = (LifecycleListener)clazz.newInstance();
                ((Lifecycle)context).addLifecycleListener(listener);
            }
            this.host.fireContainerEvent("pre_install", (Object)context);
            this.host.addChild((Container)context);
            this.host.fireContainerEvent("install", (Object)context);
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }
}

