/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.mbeans;

import com.ericsson.ssa.container.mbeans.MBeanCollectionProxy;
import com.ericsson.ssa.container.startup.NamingService;
import com.sun.org.apache.commons.modeler.Registry;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanUtil {
    private static MBeanUtil instance = new MBeanUtil();
    private static Logger logger = Logger.getLogger("SipContainer");
    private Registry registry = Registry.getRegistry(null, null);
    private MBeanServer server = this.registry.getMBeanServer();
    private ObjectName loaderMbeanName = null;
    private String jmxDefaultHost = "127.0.0.1";
    private int jmxDefaultPort = 1099;

    public static MBeanUtil getInstance() {
        return instance;
    }

    public void createServer() {
        try {
            this.loaderMbeanName = new ObjectName("Sailfin:type=loader");
            this.registry = Registry.getRegistry(null, null);
            this.server = this.registry.getMBeanServer();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed creating MBeanServer ", e);
        }
    }

    public MBeanServer getServer() {
        if (this.server == null) {
            this.createServer();
        }
        return this.server;
    }

    public void registerMBean(Object mbean, String mbeanName) {
        try {
            ObjectName oname = new ObjectName(mbeanName);
            this.registry.registerComponent(mbean, oname, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void registerMBeanCollection(List mBeanCollection, String mbeanName) {
        try {
            ObjectName oname = new ObjectName(mbeanName);
            Object mBeanCollectionProxy = MBeanCollectionProxy.createProxy(mBeanCollection);
            this.registry.registerComponent(mBeanCollectionProxy, oname, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void startRemoteAdapter() {
        try {
            if (this.server == null) {
                this.createServer();
            }
            ObjectName namingName = ObjectName.getInstance("naming:type=rmiregistry");
            NamingService ns = new NamingService();
            ns.setPort(this.getJmxDefaultPort());
            this.server.registerMBean(ns, namingName);
            this.server.invoke(namingName, "start", null, null);
            int namingPort = (Integer)this.server.getAttribute(namingName, "Port");
            String jndiPath = "/jmxconnector";
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + this.getJmxDefaultHost() + "/jndi/rmi://" + this.getJmxDefaultHost() + ":" + this.getJmxDefaultPort() + jndiPath);
            logger.log(Level.INFO, "Service URL is " + url);
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.server);
            connectorServer.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void loadDescriptors(Class clazz, String descriptorFileName) throws Exception {
        InputStream is = clazz.getClassLoader().getResourceAsStream(descriptorFileName);
        if (is == null) {
            is = clazz.getResourceAsStream(descriptorFileName);
        }
        if (is != null) {
            this.registry.loadMetadata((Object)is);
        }
    }

    public void loadDefaultDescriptors() throws Exception {
        InputStream is = MBeanUtil.class.getClassLoader().getResourceAsStream("mbeans-descriptors.xml");
        if (is == null) {
            is = MBeanUtil.class.getResourceAsStream("mbeans-descriptors.xml");
        }
        if (is != null) {
            this.registry.loadMetadata((Object)is);
        }
    }

    public void createMBean(String className, String name) {
        try {
            ObjectName oName = new ObjectName(name);
            this.server.createMBean(className, oName, this.loaderMbeanName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public String getJmxDefaultHost() {
        return this.jmxDefaultHost;
    }

    public void setJmxDefaultHost(String jmxDefaultHost) {
        this.jmxDefaultHost = jmxDefaultHost;
    }

    public int getJmxDefaultPort() {
        return this.jmxDefaultPort;
    }

    public void setJmxDefaultPort(int jmxDefaultPort) {
        this.jmxDefaultPort = jmxDefaultPort;
    }
}

