/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.sim;

import com.ericsson.ssa.container.annotation.AnnotationHandler;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.ServiceHandler;
import com.ericsson.ssa.sip.SipServletReadOnlyRequestImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipServletReadOnlyRequest;
import javax.servlet.sip.TooManyHopsException;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.tomcat5.CoyoteResponse;

public class ApplicationDispatcher
extends ValveBase
implements Layer,
ContainerListener,
LifecycleListener,
ServiceHandler {
    public static final String APPLICATION_DISPATCHER = "com.ericsson.ssa.container.sim.ApplicationDispatcher/1.0";
    private static ApplicationDispatcher m_singeltonInstance = new ApplicationDispatcher();
    private static TreeMap<String, ServletDispatcher> m_contextMapping = new TreeMap();
    private Logger m_logger = Logger.getLogger("SipContainer");
    private Layer m_nextLayer = null;
    private SipApplicationRouter m_applicationRouter = null;
    private Dispatcher m_serviceDispatcher = new Dispatcher(){

        public void dispatch(SipServletRequestImpl req) {
            ApplicationDispatcher.this.dispatchViaStatelessProxy(req);
        }

        public void dispatch(SipServletResponseImpl resp) {
            this.dispatch(resp);
        }
    };

    protected ApplicationDispatcher() {
    }

    public synchronized void start() {
        if (this.m_applicationRouter == null) {
            throw new RuntimeException("Can not start without application router.");
        }
        this.m_applicationRouter.init(new ArrayList<String>(m_contextMapping.keySet()));
    }

    public synchronized void stop() {
        this.m_applicationRouter.destroy();
    }

    public void lifecycleEvent(LifecycleEvent event) {
    }

    public void containerEvent(ContainerEvent event) {
        this.m_logger.fine("Got Container event!");
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
            CoyoteResponse coyoteResponse = (CoyoteResponse)response.getResponse();
            coyoteResponse.setStatus(500);
            coyoteResponse.setDetailMessage(sm.getString("standardHost.noContext"));
            return 2;
        }
        if (context.getLoader() != null) {
            Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        }
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        response.setSuspended(false);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
    }

    public void dispatch(SipServletRequestImpl request) {
        if (request.isInitial()) {
            request.pushApplicationDispatcher(this);
            this.invokeServletDispatchers(request);
        } else {
            this.dispatchViaStatelessProxy(request);
        }
    }

    private void invokeServletDispatchers(SipServletRequestImpl request) {
        request.setSent(false);
        Object stateInfo = request.getStateInfo();
        SipApplicationRouterInfo info = this.m_applicationRouter.getNextApplication((SipServletReadOnlyRequest)new SipServletReadOnlyRequestImpl(request), false, SipApplicationRoutingDirective.NEW, stateInfo);
        String newStateInfo = null;
        if (info != null) {
            newStateInfo = info.getStateInfo();
        }
        request.setStateInfo(newStateInfo);
        while (info != null) {
            if (info.isExternal()) {
                this.dispatchViaStatelessProxy(request);
                return;
            }
            String application = info.getNextApplicationName();
            if (application == null) {
                this.dispatchViaStatelessProxy(request);
                return;
            }
            ServletDispatcher sd = m_contextMapping.get(application);
            try {
                sd.invoke(request, info);
            }
            catch (TooManyHopsException tmhe) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.log(Level.FINE, "Too Many Hops Exception ", tmhe);
                }
                SipServletResponseImpl response = request.createTerminatingResponse(483);
                response.popDispatcher().dispatch(response);
                return;
            }
            catch (Exception e) {
                if (this.m_logger.isLoggable(Level.FINE)) {
                    this.m_logger.log(Level.FINE, "Error invoking service ", e);
                }
                SipServletResponseImpl response = request.createTerminatingResponse(500);
                response.popDispatcher().dispatch(response);
                return;
            }
            if (request.hasSent()) {
                return;
            }
            info = this.m_applicationRouter.getNextApplication((SipServletReadOnlyRequest)new SipServletReadOnlyRequestImpl(request), false, SipApplicationRoutingDirective.CONTINUE, (Object)newStateInfo);
            newStateInfo = null;
            if (info != null) {
                newStateInfo = info.getStateInfo();
            }
            request.setStateInfo(newStateInfo);
        }
        this.dispatchViaStatelessProxy(request);
    }

    public void dispatch(SipServletResponseImpl response) {
        try {
            response.popDispatcher().dispatch(response);
        }
        catch (Exception ex) {
            this.m_logger.log(Level.SEVERE, "Unhandled exception ", ex);
        }
    }

    private void dispatchViaStatelessProxy(SipServletRequestImpl request) {
        int maxForwards = request.getMaxForwards();
        if (--maxForwards <= 0) {
            SipServletResponseImpl response = request.createTerminatingResponse(483);
            if (response != null) {
                this.dispatch(response);
            }
            return;
        }
        request.setMaxForwards(maxForwards);
        this.log("The default proxy will decrease the Max-Forwards by one.");
        Dispatcher dispatcher = request.popDispatcher();
        if (dispatcher instanceof ApplicationDispatcher || dispatcher == this.m_serviceDispatcher) {
            request.popDispatcher().dispatch(request);
        } else {
            dispatcher.dispatch(request);
        }
    }

    public void addServletDispatcher(String applicationName, ServletDispatcher servletDispatcher) {
        m_contextMapping.put(applicationName, servletDispatcher);
        ArrayList<String> apps = new ArrayList<String>(1);
        apps.add(applicationName);
        this.m_applicationRouter.deployedApplications(apps);
    }

    public void removeServletDispatcher(String applicationName) {
        m_contextMapping.remove(applicationName);
        ArrayList<String> apps = new ArrayList<String>(1);
        apps.add(applicationName);
        this.m_applicationRouter.undeployedApplications(apps);
    }

    public ServletDispatcher getServletDispatcher(String applicationName) {
        return m_contextMapping.get(applicationName);
    }

    public Servlet getHandler(String applicationName, String handler) {
        ServletDispatcher disp = m_contextMapping.get(applicationName);
        if (disp != null) {
            return disp.getHandler(handler);
        }
        return null;
    }

    public void next(SipServletRequestImpl request) {
        LayerHelper.next(request, (Layer)this, this.m_nextLayer);
    }

    public void next(SipServletResponseImpl response) {
        LayerHelper.next(response, (Layer)this, this.m_nextLayer);
    }

    public void registerNext(Layer layer) {
        this.m_nextLayer = layer;
    }

    public static ApplicationDispatcher getInstance() {
        return m_singeltonInstance;
    }

    public void setApplicationRouter(SipApplicationRouter aRouter) {
        this.m_logger.log(Level.FINE, "Setting Application Router: " + aRouter);
        this.m_applicationRouter = aRouter;
        AnnotationHandler.processSipAnnotation(this.m_applicationRouter);
    }

    public void setApplicationRouterClass(String className) {
        this.m_logger.log(Level.FINE, "Instantiating Application Route : " + className);
        try {
            Class<?> ar = Class.forName(className);
            this.m_applicationRouter = (SipApplicationRouter)ar.newInstance();
            AnnotationHandler.processSipAnnotation(this.m_applicationRouter);
        }
        catch (ClassNotFoundException e) {
            this.m_logger.log(Level.WARNING, "Faild to instantiate ApplicationRouter", e);
        }
        catch (InstantiationException e) {
            this.m_logger.log(Level.WARNING, "Faild to instantiate ApplicationRouter", e);
        }
        catch (IllegalAccessException e) {
            this.m_logger.log(Level.WARNING, "Faild to instantiate ApplicationRouter", e);
        }
    }

    public void pushServiceDispatcher(SipServletRequestImpl request) {
        request.pushApplicationDispatcher(this.m_serviceDispatcher);
    }

    public String getInfo() {
        return APPLICATION_DISPATCHER;
    }

    private void log(String log) {
        if (this.m_logger.isLoggable(Level.FINE)) {
            this.m_logger.log(Level.FINE, log);
        }
    }
}

