/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.sim;

import com.ericsson.ssa.annotations.SipAnnotationDescriptor;
import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.container.auth.AuthModule;
import com.ericsson.ssa.container.sim.ApplicationDispatcher;
import com.ericsson.ssa.container.sim.ServletStartupOrderComparator;
import com.ericsson.ssa.container.sim.SipServletWrapper;
import com.ericsson.ssa.dd.ServletMapping;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.fm.FmEventSender;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.ThreadData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.TooManyHopsException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.InstanceListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.tomcat5.CoyoteRequestFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletDispatcher
extends ValveBase {
    private static Logger logger = Logger.getLogger("SipContainer");
    SipApplication sipApplicationModel;
    private SipFactoryFacade m_sipFactory = null;
    private HashMap<String, Wrapper> wrappers = new HashMap(5, 0.75f);
    private AuthModule authModule = null;
    private SipSessionManager m_SipSessionManager = null;

    public ServletDispatcher(SipSessionManager manager) {
        this.m_SipSessionManager = manager;
    }

    public SipApplication getSipApplicationModel() {
        return this.sipApplicationModel;
    }

    public void setSipApplicationModel(SipApplication sipApplicationModel) {
        this.sipApplicationModel = sipApplicationModel;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        return 1;
    }

    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        CoyoteRequestFacade coyoteRequest = (CoyoteRequestFacade)request.getRequest();
        HttpSession session = coyoteRequest.getSession(false);
        ThreadData threadData = SipServletMessageImpl.getThreadLocalData();
        if (session != null && threadData != null && threadData.getSipApplicationSessionImpl() != null) {
            threadData.getSipApplicationSessionImpl().addSession(session);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Added a HttpSession (" + session.getId() + ") to a SipApplicationSession " + threadData.getSipApplicationSessionImpl().getId());
            }
        }
    }

    private void createSession(SipServletRequestImpl req, SipApplicationSessionImpl appSess, String handlerName, SipApplicationRouterInfo info) {
        SipSessionBase s = req.getSessionImpl();
        if (s == null) {
            String id = DialogFragment.createKey(req.getCallId(), req.getFrom().getParameter("tag"));
            DialogSet existingDs = SessionManager.getInstance().getEarlyDialog(id);
            if (existingDs != null) {
                req.setDialog(new DialogFragment(existingDs, true));
            } else {
                DialogSet ds = new DialogSet(req.getCallId(), req.getFrom());
                DialogFragment df = new DialogFragment(ds);
                req.setDialog(df);
            }
        }
        DialogFragment d = req.getDialog();
        s = this.m_SipSessionManager.createSipSession(d.getDialogSet(), req.getTo(), appSess, handlerName);
        s.setRegion(info.getRegion());
        s.setSubscriberURI(info.getSubscriberURI());
        req.setSession(s);
    }

    public void invoke(SipServletRequestImpl request, SipApplicationRouterInfo info) throws TooManyHopsException, Exception {
        String authMethod;
        if (this.sipApplicationModel != null && (authMethod = this.sipApplicationModel.getLoginConfigAuthMethod()) != null && authMethod.length() != 0 && this.authModule == null) {
            this.authModule = new AuthModule(this.sipApplicationModel);
        }
        SipApplicationSessionImpl as = null;
        List<String> servlets = this.findServlets(request);
        if (!servlets.isEmpty()) {
            as = this.m_sipFactory.createApplicationSession(request);
            for (String servletToInvoke : servlets) {
                boolean permissionGranted = true;
                if (!permissionGranted) {
                    if (request.getUserPrincipal() == null && this.authModule.needsAuthentication(servletToInvoke, request.getMethod())) {
                        this.authModule.authenticate(request, servletToInvoke);
                        if (request.getUserPrincipal() == null) {
                            return;
                        }
                        if (!this.authModule.checkServletConstraints(request, servletToInvoke)) {
                            return;
                        }
                    } else if (this.authModule.needsAuthentication(servletToInvoke, request.getMethod()) && !this.authModule.checkServletConstraints(request, servletToInvoke)) {
                        return;
                    }
                }
                request.setAuthModule(this.authModule);
                as.setCurrentServlet(servletToInvoke);
                this.createSession(request, as, servletToInvoke, info);
                SipServletWrapper wrap = (SipServletWrapper)this.wrappers.get(servletToInvoke);
                this.doPreInvoke(request);
                wrap.invokeServlet(request);
                this.doPostInvoke(request);
                if (!request.hasSent()) continue;
                return;
            }
        }
    }

    public void initialize() {
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = this.sipApplicationModel.getServlets();
        for (String servletName : servlets.keySet()) {
            Wrapper wrapper = this.initializeWrapper(servletName);
            this.wrappers.put(servletName, wrapper);
            this.getContainer().addChild((Container)wrapper);
        }
        Container host = this.getContainer().getParent();
        Valve[] valves = host.getPipeline().getValves();
        for (int i = 0; i < valves.length; ++i) {
            Valve valve = valves[i];
            String valveInfo = valve.getInfo();
            if (!"com.ericsson.ssa.container.sim.ApplicationDispatcher/1.0".equals(valveInfo)) continue;
            ((ApplicationDispatcher)valve).addServletDispatcher(this.getContainer().getName(), this);
            return;
        }
        SipAnnotationDescriptor sad = this.getAnnotationDescriptor();
        this.m_sipFactory.initKeyMethod(sad.getSipApplicationKeyMethod());
    }

    private SipAnnotationDescriptor getAnnotationDescriptor() {
        StandardContext context = (StandardContext)this.getContainer();
        String deploymentPath = context.getDocBase() + "/WEB-INF/classes";
        ClassLoader cl = context.getLoader().getClassLoader();
        SipAnnotationDescriptor sad = new SipAnnotationDescriptor(cl, deploymentPath);
        sad.processAnnotations();
        return sad;
    }

    public void unInitialize() {
        Container host = this.getContainer().getParent();
        Valve[] valves = host.getPipeline().getValves();
        for (int i = 0; i < valves.length; ++i) {
            Valve valve = valves[i];
            String valveInfo = valve.getInfo();
            if (!"com.ericsson.ssa.container.sim.ApplicationDispatcher/1.0".equals(valveInfo)) continue;
            ((ApplicationDispatcher)valve).removeServletDispatcher(this.getContainer().getName());
            return;
        }
    }

    protected Wrapper initializeWrapper(String servletName) {
        SipServletWrapper wrapper = new SipServletWrapper(this.m_sipFactory, this.sipApplicationModel.getServlet(servletName));
        StandardContext context = (StandardContext)this.getContainer();
        String[] instanceListeners = context.findInstanceListeners();
        for (int i = 0; i < instanceListeners.length; ++i) {
            try {
                Class<?> clazz = Class.forName(instanceListeners[i]);
                InstanceListener listener = (InstanceListener)clazz.newInstance();
                wrapper.addInstanceListener(listener);
                continue;
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Failed creating instance listener for Wrapper", t);
            }
        }
        wrapper.setServletClass(this.sipApplicationModel.getServlet(servletName).getServletClass());
        wrapper.setParent(this.container);
        return wrapper;
    }

    protected List<String> findServlets(SipServletRequest request) {
        ArrayList<String> matchingServlets = new ArrayList<String>();
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = this.sipApplicationModel.getServlets();
        Map<String, ServletMapping> mappings = this.sipApplicationModel.getServletMappings();
        for (String servletName : servlets.keySet()) {
            ServletMapping mapping = mappings.get(servletName);
            if (mapping == null || !mapping.getPattern().getTopCondition().evaluate(request)) continue;
            matchingServlets.add(servletName);
        }
        return matchingServlets;
    }

    public boolean findServlet(String servletName) {
        Map<String, com.ericsson.ssa.dd.Servlet> servlets = this.sipApplicationModel.getServlets();
        return servlets.containsKey(servletName);
    }

    public void loadServletsMarkedOnStartup() {
        TreeSet<com.ericsson.ssa.dd.Servlet> set = new TreeSet<com.ericsson.ssa.dd.Servlet>(new ServletStartupOrderComparator());
        set.addAll(this.sipApplicationModel.getServlets().values());
        for (com.ericsson.ssa.dd.Servlet servlet : set) {
            if (servlet.getLoadOnStartup() < 0) continue;
            Wrapper wrapper = this.getWrapper(servlet.getServletName());
            try {
                wrapper.allocate();
            }
            catch (ServletException e) {
                logger.log(Level.SEVERE, String.format("Servlet '%1$s' threw an exception during initialization.", wrapper.getName()), StandardWrapper.getRootCause((ServletException)e));
                Context context = (Context)this.container;
                FmEventSender.servletInitializationFailed(context.getName(), wrapper.getName(), e.getMessage());
            }
        }
    }

    protected Wrapper getWrapper(String servletName) {
        Wrapper wrapper = this.wrappers.get(servletName);
        if (wrapper == null) {
            wrapper = this.initializeWrapper(servletName);
            this.wrappers.put(servletName, wrapper);
        }
        return wrapper;
    }

    public void addWrapper(String servletName, Wrapper wrapper) {
        this.wrappers.put(servletName, wrapper);
    }

    public Servlet getHandler(String handler) {
        Servlet servlet = null;
        Wrapper wrap = this.wrappers.get(handler);
        if (wrap != null) {
            try {
                servlet = wrap.allocate();
            }
            catch (ServletException e) {
                logger.log(Level.SEVERE, "Error allocating Servlet " + handler, e);
            }
        }
        return servlet;
    }

    public SipFactoryFacade getSipFactory() {
        return this.m_sipFactory;
    }

    public void setSipFactory(SipFactoryFacade sipFactory) {
        this.m_sipFactory = sipFactory;
    }

    public void doPreInvoke(SipServletRequest request) {
        StandardContext context = (StandardContext)this.getContainer();
        Object[] instances = context.getApplicationEventListeners();
        ServletRequestEvent event = null;
        if (instances != null && instances.length > 0) {
            event = new ServletRequestEvent(((StandardContext)this.container).getServletContext(), (ServletRequest)request);
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                context.fireContainerEvent("beforeRequestInitialized", (Object)listener);
                try {
                    listener.requestInitialized(event);
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed calling requestInitialized()", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPostInvoke(SipServletRequest request) {
        StandardContext context = (StandardContext)this.getContainer();
        Object[] instances = context.getApplicationEventListeners();
        ServletRequestEvent event = new ServletRequestEvent(context.getServletContext(), (ServletRequest)request);
        if (instances != null && instances.length > 0) {
            for (int i = 0; i < instances.length; ++i) {
                if (instances[i] == null || !(instances[i] instanceof ServletRequestListener)) continue;
                ServletRequestListener listener = (ServletRequestListener)instances[i];
                context.fireContainerEvent("beforeRequestDestroyed", (Object)listener);
                try {
                    listener.requestDestroyed(event);
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Failed calling requestDestroyed()", t);
                    continue;
                }
                finally {
                    context.fireContainerEvent("afterRequestDestroyed", (Object)listener);
                }
            }
        }
    }
}

