/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.sim;

import com.ericsson.ssa.config.SipFactoryFacade;
import com.ericsson.ssa.container.sim.SipServletFacade;
import com.ericsson.ssa.dd.Parameter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.annotation.SipFactory;
import javax.servlet.sip.annotation.SipSessionsUtil;
import javax.servlet.sip.annotation.TimerService;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardWrapper;

public class SipServletWrapper
extends StandardWrapper {
    private static final long serialVersionUID = 3545793282447063096L;
    private static Logger logger = Logger.getLogger("SipContainer");
    private com.ericsson.ssa.dd.Servlet servlet;
    private boolean unloading = false;
    private SipServletFacade instance;
    private SipFactoryFacade sipFactory = null;
    Servlet servletInstance;

    public SipServletWrapper(SipFactoryFacade sipFactory, com.ericsson.ssa.dd.Servlet servlet) {
        this.sipFactory = sipFactory;
        this.servlet = servlet;
        this.setName(servlet.getServletName());
    }

    public void service(ServletRequest request) throws Exception {
        this.getInstanceSupport().fireInstanceEvent("beforeDispatch", (Servlet)this.instance);
        try {
            this.allocate().service(request, null);
        }
        catch (ServletException e) {
            logger.log(Level.SEVERE, "Exception in Servlet.service()", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception in Servlet.service()", e);
        }
        this.getInstanceSupport().fireInstanceEvent("afterDispatch", (Servlet)this.instance);
    }

    public void invokeServlet(SipServletRequest request) throws Exception {
        try {
            if (this.servletInstance == null) {
                this.allocate();
            }
            this.getInstanceSupport().fireInstanceEvent("beforeDispatch", this.servletInstance);
            this.instance.service((ServletRequest)request, null);
            this.getInstanceSupport().fireInstanceEvent("afterDispatch", this.servletInstance);
        }
        catch (ServletException e) {
            logger.log(Level.SEVERE, "Exception allocating servlet ", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Exception allocating servlet ", e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception allocating servlet ", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Servlet allocate() throws ServletException {
        if (this.unloading) {
            throw new ServletException("The servlet is currently unloading: " + this.getName());
        }
        if (this.instance == null) {
            SipServletWrapper sipServletWrapper = this;
            synchronized (sipServletWrapper) {
                if (this.instance == null) {
                    this.instance = this.doLoad();
                }
            }
        }
        return this.instance;
    }

    public synchronized void load() throws ServletException {
        this.doLoad();
    }

    public synchronized void unload() throws ServletException {
        this.unloading = true;
        try {
            this.getInstanceSupport().fireInstanceEvent("beforeDestroy", (Servlet)this.instance);
            if (this.instance != null) {
                this.instance.destroy();
            }
        }
        catch (Throwable t) {
            throw new ServletException(sm.getString("standardWrapper.destroyException", (Object)this.getName()), t);
        }
        finally {
            try {
                this.getInstanceSupport().fireInstanceEvent("afterDestroy", (Servlet)this.instance);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Should not happen!!! (TR reported)", t);
            }
            this.instance = null;
            this.unloading = false;
        }
    }

    public String getInitParameter(String name) {
        Parameter parameter = this.servlet.getInitParameter(name);
        if (parameter != null) {
            return parameter.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getInitParameters() {
        com.ericsson.ssa.dd.Servlet servlet = this.servlet;
        synchronized (servlet) {
            return Collections.enumeration(this.servlet.getInitParameters().entrySet());
        }
    }

    public Enumeration getInitParameterNames() {
        Map initParams = this.servlet.getInitParameters();
        if (initParams == null || initParams.isEmpty()) {
            return Collections.enumeration(Collections.emptyMap().keySet());
        }
        return Collections.enumeration(this.servlet.getInitParameters().keySet());
    }

    public String getServletName() {
        return this.servlet.getServletName();
    }

    protected SipServletFacade doLoad() throws ServletException {
        SipServletFacade facade;
        Loader loader = this.getLoader();
        if (loader == null) {
            this.unavailable(null);
            throw new ServletException("Missing loader: " + this.getName());
        }
        ClassLoader classLoader = this.getLoader().getClassLoader();
        Class<?> servletClass = null;
        try {
            if (classLoader != null) {
                try {
                    servletClass = classLoader.loadClass(this.getServletClass());
                }
                catch (ClassNotFoundException e) {
                    servletClass = Class.forName(this.getServletClass());
                }
            } else {
                servletClass = Class.forName(this.getServletClass());
            }
        }
        catch (ClassNotFoundException ex) {
            this.unavailable(null);
            throw new ServletException(String.format("Wrapper cannot find servlet class %1$s or a class it depends on", this.getServletClass()), (Throwable)ex);
        }
        Servlet target = null;
        try {
            this.servletInstance = target = (Servlet)servletClass.newInstance();
            this.doInjectAnnotations(target);
            facade = new SipServletFacade(target, this.servlet);
            this.registerListeners(target);
            this.getInstanceSupport().fireInstanceEvent("beforeInit", target);
            facade.init((ServletConfig)this);
            this.getInstanceSupport().fireInstanceEvent("afterInit", target);
        }
        catch (InstantiationException ex) {
            this.unavailable(null);
            this.getInstanceSupport().fireInstanceEvent("afterInit", target);
            throw new ServletException(String.format("Servlet class %1$s cannot be instantiated.", this.getServletClass()), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            this.unavailable(null);
            this.getInstanceSupport().fireInstanceEvent("afterInit", target);
            throw new ServletException((Throwable)ex);
        }
        return facade;
    }

    public void registerListeners(Servlet instance) {
        ArrayList<String> sipServletsWithListeners = this.sipFactory.getSipApplicationListeners().getSipServletsWithListeners();
        ListIterator<String> it = sipServletsWithListeners.listIterator();
        boolean foundMe = false;
        while (it.hasNext()) {
            String servlet = it.next();
            if (!servlet.equals(this.getServletClass())) continue;
            foundMe = true;
            break;
        }
        if (!foundMe) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "registerListener no sip.xml entry");
            }
            return;
        }
        if (instance instanceof TimerListener) {
            this.sipFactory.getSipApplicationListeners().setTimerListener((TimerListener)instance);
        }
        if (instance instanceof SipApplicationSessionListener) {
            this.sipFactory.getSipApplicationListeners().addSipApplicationSessionListener((SipApplicationSessionListener)instance);
        }
        if (instance instanceof SipSessionListener) {
            this.sipFactory.getSipApplicationListeners().addSipSessionListener((SipSessionListener)instance);
        }
        if (instance instanceof SipErrorListener) {
            this.sipFactory.getSipApplicationListeners().addSipErrorListener((SipErrorListener)instance);
        }
        if (instance instanceof SipSessionAttributeListener) {
            this.sipFactory.getSipApplicationListeners().addSipSessionAttributeListener((SipSessionAttributeListener)instance);
        }
        if (instance instanceof ServletContextListener) {
            this.sipFactory.getSipApplicationListeners().addServletContextListener((ServletContextListener)instance);
        }
    }

    private void doInjectAnnotations(Servlet target) {
        Field[] fields = target.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            SipFactory annotation = field.getAnnotation(SipFactory.class);
            if (annotation != null) {
                field.setAccessible(true);
                try {
                    field.set(target, this.sipFactory);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
                }
            }
            if ((annotation = field.getAnnotation(TimerService.class)) != null) {
                field.setAccessible(true);
                try {
                    javax.servlet.sip.TimerService ts = (javax.servlet.sip.TimerService)this.getServletContext().getAttribute("javax.servlet.sip.TimerService");
                    field.set(target, ts);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
                }
                catch (IllegalAccessException e) {
                    logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
                }
            }
            if ((annotation = field.getAnnotation(SipSessionsUtil.class)) == null) continue;
            field.setAccessible(true);
            try {
                javax.servlet.sip.SipSessionsUtil sessionUtil = (javax.servlet.sip.SipSessionsUtil)this.sipFactory;
                this.getServletContext().getAttribute("javax.servlet.sip.TimerService");
                field.set(target, sessionUtil);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.log(Level.SEVERE, "Failed inject the SipFactory annotation", e);
            }
        }
    }
}

