/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.Condition;
import com.ericsson.ssa.dd.Operator;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.dd.SipParserException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndOperator
extends Operator {
    private static final long serialVersionUID = 3256720667486663224L;

    @Override
    public boolean evaluate(Object object) {
        for (int i = 0; i < this.subConditions.size(); ++i) {
            if (((Condition)this.subConditions.get(i)).evaluate(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList() throws SipParserException {
        Hashtable<String, ArrayList<String>> methodSessioncaseTableResult = new Hashtable<String, ArrayList<String>>();
        Hashtable<String, ArrayList<String>> methodSessionFilterTable = new Hashtable<String, ArrayList<String>>();
        for (int i = 0; i < this.subConditions.size(); ++i) {
            Hashtable<String, ArrayList<String>> curMethSessionTable = ((Condition)this.subConditions.get(i)).getMethodSessionCaseList();
            Enumeration<String> keysList = curMethSessionTable.keys();
            while (keysList.hasMoreElements()) {
                String curKey = keysList.nextElement();
                if (curKey.equals("request.method") || curKey.equals("request.session-case")) {
                    if (methodSessionFilterTable.containsKey(curKey)) {
                        throw new SipParserException("AND: Wrong Condition: two methods or session-case under the same AND condtion");
                    }
                    methodSessionFilterTable.put(curKey, curMethSessionTable.get(curKey));
                    continue;
                }
                if (methodSessioncaseTableResult.containsKey(curKey)) {
                    this.addOnlyNewElementToTheList(curMethSessionTable.get(curKey), methodSessioncaseTableResult.get(curKey));
                    continue;
                }
                methodSessioncaseTableResult.put(curKey, curMethSessionTable.get(curKey));
            }
        }
        if (!methodSessionFilterTable.isEmpty()) {
            if (!methodSessioncaseTableResult.isEmpty()) {
                throw new SipParserException("AND: Wrong Condition: two methods or session-case under the same AND condtion (not in the same level)");
            }
            if (methodSessionFilterTable.containsKey("request.method") && methodSessionFilterTable.containsKey("request.session-case")) {
                Iterator methodIter = ((ArrayList)methodSessionFilterTable.get("request.method")).iterator();
                while (methodIter.hasNext()) {
                    methodSessioncaseTableResult.put((String)methodIter.next(), (ArrayList<String>)methodSessionFilterTable.get("request.session-case"));
                }
            } else if (methodSessionFilterTable.containsKey("request.method") && !methodSessionFilterTable.containsKey("request.session-case")) {
                Iterator methodIter = ((ArrayList)methodSessionFilterTable.get("request.method")).iterator();
                while (methodIter.hasNext()) {
                    ArrayList<String> sessionCaseNotSpecify = new ArrayList<String>();
                    sessionCaseNotSpecify.add(SessionCase.EXTERNAL.toString());
                    methodSessioncaseTableResult.put((String)methodIter.next(), sessionCaseNotSpecify);
                }
            } else {
                throw new SipParserException("AND: impossible Condition: one session-case without any method associated");
            }
        }
        return methodSessioncaseTableResult;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subConditions.size(); ++i) {
            if (i > 0) {
                sb.append(" && ");
            }
            sb.append("(" + this.subConditions.get(i) + ")");
        }
        return sb.toString();
    }
}

