/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.Operand;
import com.ericsson.ssa.dd.SipParserException;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.servlet.sip.SipServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualOperand
extends Operand {
    private static final long serialVersionUID = 3258133544273786673L;
    private String variable;
    private String value;
    private boolean ignoreCase;

    public EqualOperand() {
    }

    public EqualOperand(String var, String value, boolean ignoreCase) throws SipParserException {
        this.variable = var;
        this.value = value;
        this.ignoreCase = ignoreCase;
        if (var == null || value == null) {
            throw new SipParserException("equals() value/variable must be non-null");
        }
        if (!this.isVarValueSupported(var, value)) {
            throw new SipParserException("equals() variable=" + var + "  value=" + value + ", not supported");
        }
    }

    @Override
    public boolean evaluate(Object object) {
        SipServletRequest request = (SipServletRequest)object;
        String a = request.getMethod();
        return this.ignoreCase ? this.value.equalsIgnoreCase(this.getAttributeValue(this.variable, request)) : this.value.equals(this.getAttributeValue(this.variable, request));
    }

    @Override
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList() throws SipParserException {
        Hashtable<String, ArrayList<String>> equalTable = new Hashtable<String, ArrayList<String>>();
        if (this.isMethodOrSessionCase(this.variable)) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(this.value);
            equalTable.put(this.variable, values);
        }
        return equalTable;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    public void setVariable(String variable) {
        this.variable = variable;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (value.trim().length() == 0) {
            throw new IllegalArgumentException("balba");
        }
        this.value = value;
    }

    public String toString() {
        return "" + this.variable.toString() + " == \"" + this.value.toString() + "\"";
    }

    public void setIgnoreCase(String ignoreCase) {
        this.ignoreCase = Boolean.parseBoolean(ignoreCase);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }
}

