/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.EjbLocalReference;
import com.ericsson.ssa.dd.EjbReference;
import com.ericsson.ssa.dd.EnvironmentEntry;
import com.ericsson.ssa.dd.LoginAuthentication;
import com.ericsson.ssa.dd.Parameter;
import com.ericsson.ssa.dd.ResourceEnvironmentReference;
import com.ericsson.ssa.dd.ResourceReference;
import com.ericsson.ssa.dd.SecurityConstraint;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.Servlet;
import com.ericsson.ssa.dd.ServletMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipApplication
implements Serializable {
    private static final long serialVersionUID = 3258415023411114551L;
    public static final int UNKNOWN_TIMEOUT_VALUE = Integer.MIN_VALUE;
    private String smallIcon;
    private String largeIcon;
    private String displayName;
    private String description;
    private boolean distributable;
    private Map<String, Parameter> contextParameters;
    private Collection<String> listeners;
    private Map<String, Servlet> servlets;
    private Map<String, ServletMapping> servletMappings;
    private long proxyConfigSequentialSearchTimeout;
    private int sessionConfigTimeout = Integer.MIN_VALUE;
    private Collection<ResourceEnvironmentReference> resourceEnvironmentReferences;
    private Collection<ResourceReference> resourceReferences;
    private Collection<SecurityConstraint> securityConstraints;
    private String loginConfigAuthMethod;
    private String loginConfigRealmName;
    private Map<String, SecurityRole> securityRoles;
    private Collection<EnvironmentEntry> environmentEntries;
    private Collection<EjbReference> ejbReferences;
    private Collection<EjbLocalReference> ejbLocalReferences;
    private String moduleName;
    private int version;
    private String defaultServlet;
    private String appName;

    public void addServlet(Servlet servlet) {
        if (this.servlets == null) {
            this.servlets = new LinkedHashMap<String, Servlet>();
        }
        if (this.servlets.get(servlet.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet with the same name in the sip deployment descriptor");
        }
        this.servlets.put(servlet.getServletName(), servlet);
        if (this.defaultServlet == null && servlet != null) {
            this.defaultServlet = servlet.getServletName();
        }
    }

    public void addServletMapping(ServletMapping servletMapping) {
        if (this.servletMappings == null) {
            this.servletMappings = new HashMap<String, ServletMapping>();
        }
        if (this.servlets.get(servletMapping.getServletName()) == null) {
            throw new RuntimeException("Cannot have a servlet mapping which servlet name doesn't match a servlet defined in the sip deployment descriptor");
        }
        if (this.servletMappings.get(servletMapping.getServletName()) != null) {
            throw new RuntimeException("Cannot have more than one servlet mapping per servlet name in the sip deployment descriptor");
        }
        this.servletMappings.put(servletMapping.getServletName(), servletMapping);
    }

    public void addListener(String listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<String>();
        }
        this.listeners.add(listener);
    }

    public void addContextParameter(Parameter parameter) {
        if (this.contextParameters == null) {
            this.contextParameters = new HashMap<String, Parameter>();
        }
        if (this.contextParameters.get(parameter.getName()) != null) {
            throw new RuntimeException("Each parameter name must be unique in the context parameter");
        }
        this.contextParameters.put(parameter.getName(), parameter);
    }

    public void addResourceEnvironmentReference(ResourceEnvironmentReference reference) {
        if (this.resourceEnvironmentReferences == null) {
            this.resourceEnvironmentReferences = new ArrayList<ResourceEnvironmentReference>();
        }
        this.resourceEnvironmentReferences.add(reference);
    }

    public void addResourceReference(ResourceReference reference) {
        if (this.resourceReferences == null) {
            this.resourceReferences = new ArrayList<ResourceReference>();
        }
        this.resourceReferences.add(reference);
    }

    public void addSecurityConstraint(SecurityConstraint constraint) {
        if (this.securityConstraints == null) {
            this.securityConstraints = new ArrayList<SecurityConstraint>();
        }
        this.securityConstraints.add(constraint);
    }

    public void addEnvironmentEntry(EnvironmentEntry environmentEntry) {
        if (this.environmentEntries == null) {
            this.environmentEntries = new ArrayList<EnvironmentEntry>();
        }
        this.environmentEntries.add(environmentEntry);
    }

    public void addEjbReference(EjbReference ejbReference) {
        if (this.ejbReferences == null) {
            this.ejbReferences = new ArrayList<EjbReference>();
        }
        this.ejbReferences.add(ejbReference);
    }

    public void addEjbLocalReference(EjbLocalReference ejbLocalReference) {
        if (this.ejbLocalReferences == null) {
            this.ejbLocalReferences = new ArrayList<EjbLocalReference>();
        }
        this.ejbLocalReferences.add(ejbLocalReference);
    }

    public void addSecurityRole(SecurityRole securityRole) {
        if (this.securityRoles == null) {
            this.securityRoles = new HashMap<String, SecurityRole>();
        }
        this.securityRoles.put(securityRole.getName(), securityRole);
    }

    public Map<String, Servlet> getServlets() {
        return this.servlets != null ? this.servlets : Collections.EMPTY_MAP;
    }

    public Servlet getServlet(String servletName) {
        return this.servlets.get(servletName);
    }

    public String getDefaultServlet() {
        return this.defaultServlet;
    }

    public Map<String, ServletMapping> getServletMappings() {
        return this.servletMappings != null ? this.servletMappings : Collections.EMPTY_MAP;
    }

    public ServletMapping getServletMappings(String servletName) {
        return this.servletMappings.get(servletName);
    }

    public Map<String, Parameter> getContextParameters() {
        return this.contextParameters != null ? this.contextParameters : Collections.EMPTY_MAP;
    }

    public Parameter getContextParameter(String contextParameterName) {
        return this.contextParameters.get(contextParameterName);
    }

    public Collection<EjbLocalReference> getEjbLocalReferences() {
        return this.ejbLocalReferences != null ? this.ejbLocalReferences : Collections.EMPTY_LIST;
    }

    public Collection<EjbReference> getEjbReferences() {
        return this.ejbReferences != null ? this.ejbReferences : Collections.EMPTY_LIST;
    }

    public Collection<EnvironmentEntry> getEnvironmentEntries() {
        return this.environmentEntries != null ? this.environmentEntries : Collections.EMPTY_LIST;
    }

    public Collection<String> getListeners() {
        return this.listeners != null ? this.listeners : Collections.EMPTY_LIST;
    }

    public Collection<ResourceEnvironmentReference> getResourceEnvironmentReferences() {
        return this.resourceEnvironmentReferences != null ? this.resourceEnvironmentReferences : Collections.EMPTY_LIST;
    }

    public Collection<ResourceReference> getResourceReferences() {
        return this.resourceReferences != null ? this.resourceReferences : Collections.EMPTY_LIST;
    }

    public Collection<SecurityConstraint> getSecurityConstraints() {
        return this.securityConstraints != null ? this.securityConstraints : Collections.EMPTY_LIST;
    }

    public Map<String, SecurityRole> getSecurityRoles() {
        return this.securityRoles != null ? this.securityRoles : Collections.EMPTY_MAP;
    }

    public SecurityRole getSecurityRoles(String roleName) {
        return this.securityRoles.get(roleName);
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDistributable() {
        return this.distributable;
    }

    public void setDistributable() {
        this.distributable = true;
    }

    public long getProxyConfigSequentialSearchTimeout() {
        return this.proxyConfigSequentialSearchTimeout;
    }

    public void setProxyConfigSequentialSearchTimeout(String proxyConfigSequentialSearchTimeout) {
        this.proxyConfigSequentialSearchTimeout = Long.valueOf(proxyConfigSequentialSearchTimeout);
    }

    public int getSessionConfigTimeout() {
        return this.sessionConfigTimeout;
    }

    public void setSessionConfigTimeout(String sessionConfigTimeout) {
        if (!sessionConfigTimeout.equals("")) {
            this.sessionConfigTimeout = Integer.valueOf(sessionConfigTimeout);
        }
    }

    public String getLoginConfigAuthMethod() {
        return this.loginConfigAuthMethod;
    }

    public void setLoginConfigAuthMethod(String loginConfigAuthMethod) {
        if (!LoginAuthentication.contains(loginConfigAuthMethod)) {
            throw new RuntimeException("Legal values for the auth-method are " + LoginAuthentication.printNames());
        }
        this.loginConfigAuthMethod = loginConfigAuthMethod;
    }

    public String getLoginConfigRealmName() {
        return this.loginConfigRealmName;
    }

    public void setLoginConfigRealmName(String loginConfigRealmName) {
        this.loginConfigRealmName = loginConfigRealmName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setAppName(String name) {
        this.appName = name;
    }

    public String getAppName() {
        return this.appName;
    }
}

